/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilesProcessorImpl;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!H\u0002J\b\u0010\"\u001a\u00020#H\u0014J\u000f\u0010$\u001a\u0004\u0018\u00010%H\u0004\u00a2\u0006\u0002\u0010&J\r\u0010'\u001a\u00070 \u00a2\u0006\u0002\b!H\u0002J\r\u0010(\u001a\u00070 \u00a2\u0006\u0002\b!H\u0002J\b\u0010)\u001a\u00020\nH&J\b\u0010*\u001a\u00020#H\u0004J\b\u0010+\u001a\u00020\nH&J\b\u0010,\u001a\u00020%H\u0002J\r\u0010-\u001a\u00070 \u00a2\u0006\u0002\b!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0012\u0010\u000f\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0012\u0010\u0015\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0019\u0010\u0017\u001a\u00070\n\u00a2\u0006\u0002\b\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0019\u0010\u001a\u001a\u00070\n\u00a2\u0006\u0002\b\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u001b\u0010\u001c\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001dX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\f\u00a8\u0006."}, d2={"Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "NOTIFICATION_LOCK", "Ljava/lang/Object;", "forAllProjectsActionText", "", "getForAllProjectsActionText", "()Ljava/lang/String;", "forCurrentProjectActionText", "getForCurrentProjectActionText", "muteActionText", "getMuteActionText", "notification", "Lcom/intellij/notification/Notification;", "notificationDisplayId", "getNotificationDisplayId", "showActionText", "getShowActionText", "viewFilesDialogCancelActionName", "Lcom/intellij/openapi/util/NlsContexts$Button;", "getViewFilesDialogCancelActionName", "viewFilesDialogOkActionName", "getViewFilesDialogOkActionName", "viewFilesDialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getViewFilesDialogTitle", "addForCurrentProjectAction", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "doProcess", "", "expireNotification", "", "()Lkotlin/Unit;", "forAllProjectsAction", "muteAction", "notificationMessage", "notificationNotPresent", "notificationTitle", "proposeToProcessFiles", "showAction", "intellij.platform.vcs.impl"})
public abstract class FilesProcessorWithNotificationImpl
extends FilesProcessorImpl {
    private final Object NOTIFICATION_LOCK = new Object();
    private Notification notification;
    @Nullable
    private final String viewFilesDialogTitle;
    @NotNull
    private final String viewFilesDialogOkActionName = CommonBundle.getAddButtonText();
    @NotNull
    private final String viewFilesDialogCancelActionName = CommonBundle.getCancelButtonText();

    @NotNull
    public abstract String getNotificationDisplayId();

    @NotNull
    public abstract String getShowActionText();

    @NotNull
    public abstract String getForCurrentProjectActionText();

    @Nullable
    public abstract String getForAllProjectsActionText();

    @NotNull
    public abstract String getMuteActionText();

    @NotNull
    public abstract String notificationTitle();

    @NotNull
    public abstract String notificationMessage();

    @Nullable
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    @NotNull
    protected String getViewFilesDialogOkActionName() {
        return this.viewFilesDialogOkActionName;
    }

    @NotNull
    protected String getViewFilesDialogCancelActionName() {
        return this.viewFilesDialogCancelActionName;
    }

    @Override
    protected boolean doProcess() {
        boolean processed = super.doProcess();
        if (!processed) {
            this.proposeToProcessFiles();
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void proposeToProcessFiles() {
        Object object = this.NOTIFICATION_LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.notAskedBefore() && this.notificationNotPresent()) {
                List list = CollectionsKt.mutableListOf((Object[])new NotificationAction[]{this.showAction(), this.addForCurrentProjectAction()});
                boolean bl4 = false;
                boolean bl5 = false;
                List $this$apply = list;
                boolean bl6 = false;
                if (this.getForAllProjectsActionText() != null) {
                    $this$apply.add(this.forAllProjectsAction());
                }
                $this$apply.add(this.muteAction());
                List notificationActions = list;
                Collection $this$toTypedArray$iv = notificationActions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                NotificationAction[] notificationActionArray = thisCollection$iv.toArray(new NotificationAction[0]);
                if (notificationActionArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.notification = VcsNotifier.getInstance(this.getProject()).notifyMinorInfo(true, this.getNotificationDisplayId(), this.notificationTitle(), this.notificationMessage(), Arrays.copyOf(notificationActionArray, notificationActionArray.length));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final NotificationAction showAction() {
        return NotificationAction.createSimple((String)this.getShowActionText(), (Runnable)new Runnable(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void run() {
                List<VirtualFile> allFiles = this.this$0.acquireValidFiles();
                Object object = allFiles;
                boolean bl = false;
                if (!object.isEmpty()) {
                    object = SelectFilesDialog.init(this.this$0.getProject(), allFiles, null, null, true, true, this.this$0.getViewFilesDialogOkActionName(), this.this$0.getViewFilesDialogCancelActionName());
                    bl = false;
                    boolean bl2 = false;
                    Object $this$with = object;
                    boolean bl3 = false;
                    $this$with.setTitle(this.this$0.getViewFilesDialogTitle());
                    ((SelectFilesDialog)((Object)$this$with)).setSelectedFiles((Collection<VirtualFile>)allFiles);
                    if ($this$with.showAndGet()) {
                        Collection<VirtualFile> userSelectedFiles = ((SelectFilesDialog)((Object)$this$with)).getSelectedFiles();
                        this.this$0.doActionOnChosenFiles(userSelectedFiles);
                        this.this$0.removeFiles(userSelectedFiles);
                        if (this.this$0.isFilesEmpty()) {
                            this.this$0.expireNotification();
                        }
                    }
                }
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    private final NotificationAction addForCurrentProjectAction() {
        return NotificationAction.create((String)this.getForCurrentProjectActionText(), (BiConsumer)new BiConsumer<AnActionEvent, Notification>(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void accept(AnActionEvent $noName_0, Notification $noName_1) {
                this.this$0.doActionOnChosenFiles((Collection<? extends VirtualFile>)this.this$0.acquireValidFiles());
                this.this$0.rememberForCurrentProject();
                PropertiesComponent.getInstance((Project)this.this$0.getProject()).setValue(this.this$0.getAskedBeforeProperty(), true);
                this.this$0.expireNotification();
                this.this$0.clearFiles();
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    private final NotificationAction forAllProjectsAction() {
        String string = this.getForAllProjectsActionText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return NotificationAction.create((String)string, (BiConsumer)new BiConsumer<AnActionEvent, Notification>(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void accept(AnActionEvent $noName_0, Notification $noName_1) {
                this.this$0.doActionOnChosenFiles((Collection<? extends VirtualFile>)this.this$0.acquireValidFiles());
                this.this$0.rememberForCurrentProject();
                PropertiesComponent.getInstance((Project)this.this$0.getProject()).setValue(this.this$0.getAskedBeforeProperty(), true);
                this.this$0.rememberForAllProjects();
                this.this$0.expireNotification();
                this.this$0.clearFiles();
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    private final NotificationAction muteAction() {
        return NotificationAction.create((String)this.getMuteActionText(), (BiConsumer)new BiConsumer<AnActionEvent, Notification>(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void accept(AnActionEvent $noName_0, Notification notification) {
                this.this$0.setForCurrentProject(false);
                PropertiesComponent.getInstance((Project)this.this$0.getProject()).setValue(this.this$0.getAskedBeforeProperty(), true);
                notification.expire();
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean notificationNotPresent() {
        Object object = this.NOTIFICATION_LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Notification notification = this.notification;
            bl2 = notification != null ? notification.isExpired() : true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Unit expireNotification() {
        Unit unit;
        Object object = this.NOTIFICATION_LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Unit unit2;
            boolean bl3 = false;
            Notification notification = this.notification;
            if (notification != null) {
                notification.expire();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    public FilesProcessorWithNotificationImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        super(project, parentDisposable);
    }
}

