/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.EditAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ConversionResultImpl
implements ConversionResult {
    public static final ConversionResultImpl CONVERSION_NOT_NEEDED = new ConversionResultImpl(false, false, false);
    public static final ConversionResultImpl CONVERSION_CANCELED = new ConversionResultImpl(true, true, false);
    public static final ConversionResultImpl ERROR_OCCURRED = new ConversionResultImpl(true, false, true);
    private final boolean myConversionNeeded;
    private final boolean myConversionCanceled;
    private final boolean myErrorOccurred;
    private final Set<Path> myChangedFiles = new HashSet<Path>();
    private final Set<Path> myCreatedFiles = new HashSet<Path>();

    public ConversionResultImpl(boolean conversionNeeded, boolean conversionCanceled, boolean errorOccurred) {
        this.myConversionNeeded = conversionNeeded;
        this.myConversionCanceled = conversionCanceled;
        this.myErrorOccurred = errorOccurred;
    }

    public ConversionResultImpl(List<? extends ConversionRunner> converters) {
        this(true, false, false);
        for (ConversionRunner conversionRunner : converters) {
            this.myChangedFiles.addAll(conversionRunner.getAffectedFiles());
            this.myCreatedFiles.addAll(conversionRunner.getCreatedFiles());
        }
    }

    public boolean conversionNotNeeded() {
        return !this.myConversionNeeded;
    }

    public boolean openingIsCanceled() {
        return this.myConversionCanceled || this.myErrorOccurred;
    }

    public void postStartupActivity(@NotNull Project project) {
        List<VirtualFile> createdFiles;
        Application app = ApplicationManager.getApplication();
        if (app.isHeadlessEnvironment() || app.isUnitTestMode()) {
            return;
        }
        List<VirtualFile> changedFiles = ConversionResultImpl.findVirtualFiles(this.myChangedFiles);
        if (!changedFiles.isEmpty()) {
            EditAction.editFilesAndShowErrors(project, changedFiles);
        }
        if (!ConversionResultImpl.containsFilesUnderVcs(createdFiles = ConversionResultImpl.findVirtualFiles(this.myCreatedFiles), project)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Collection selected = AbstractVcsHelper.getInstance((Project)project).selectFilesToProcess(createdFiles, VcsBundle.message((String)"dialog.title.files.created", (Object[])new Object[0]), VcsBundle.message((String)"label.select.files.to.be.added.to.version.control", (Object[])new Object[0]), null, null, VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION);
            if (selected != null && !selected.isEmpty()) {
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
                changeListManager.addUnversionedFiles(changeListManager.getDefaultChangeList(), new ArrayList(selected));
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static boolean containsFilesUnderVcs(@NotNull List<VirtualFile> files, Project project) {
        for (VirtualFile file : files) {
            if (ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> findVirtualFiles(@NotNull Collection<Path> ioFiles) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(ioFiles.size());
        for (Path file : ioFiles) {
            ContainerUtil.addIfNotNull(files, (Object)LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString())));
        }
        return files;
    }
}

