/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;

class StartUseVcsDialog
extends DialogWrapper {
    private final Map<String, String> myVcses;
    private VcsCombo myVcsCombo;
    private String mySelected;

    StartUseVcsDialog(@NotNull Project project) {
        super(project, true);
        this.myVcses = StartUseVcsDialog.getVcses(project);
        this.setTitle(VcsBundle.message((String)"dialog.enable.version.control.integration.title", (Object[])new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVcsCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.select.vcs.label.text", (Object[])new Object[0]));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.insets((int)5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridx;
        this.myVcsCombo = new VcsCombo(this.prepareComboData());
        mainPanel.add((Component)this.myVcsCombo, gb);
        String path2 = SystemInfo.isMac ? VcsBundle.message((String)"vcs.settings.path.mac", (Object[])new Object[0]) : VcsBundle.message((String)"vcs.settings.path", (Object[])new Object[0]);
        JLabel helpText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.hint.text", (Object[])new Object[0]) + path2);
        helpText.setUI((LabelUI)new MultiLineLabelUI());
        helpText.setForeground(UIUtil.getInactiveTextColor());
        gb.anchor = 18;
        gb.gridx = 0;
        ++gb.gridy;
        gb.gridwidth = 2;
        mainPanel.add((Component)helpText, gb);
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        wrapper.add((Component)mainPanel, gbc);
        return wrapper;
    }

    protected String getHelpId() {
        return "reference.version.control.enable.version.control.integration";
    }

    protected void doOKAction() {
        this.mySelected = this.myVcsCombo.getSelectedItem();
        super.doOKAction();
    }

    private String @NotNull [] prepareComboData() {
        ArrayList<String> keys = new ArrayList<String>(this.myVcses.keySet());
        keys.sort((o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.equals("Git")) {
                return -1;
            }
            if (o2.equals("Git")) {
                return 1;
            }
            return o1.compareTo((String)o2);
        });
        return ArrayUtil.toStringArray(keys);
    }

    @NotNull
    String getVcs() {
        return this.myVcses.get(this.mySelected);
    }

    private static Map<String, String> getVcses(@NotNull Project project) {
        VcsDescriptor[] allVcss = ProjectLevelVcsManager.getInstance((Project)project).getAllVcss();
        HashMap<String, String> map2 = new HashMap<String, String>(allVcss.length);
        for (VcsDescriptor vcs : allVcss) {
            map2.put(vcs.getDisplayName(), vcs.getName());
        }
        return map2;
    }

    private static class VcsCombo
    extends JComboBox<String> {
        private VcsCombo(String @NotNull [] items) {
            super(items);
            this.setSelectedIndex(0);
            this.setEditable(false);
        }

        @Override
        public String getSelectedItem() {
            return (String)super.getSelectedItem();
        }
    }
}

