/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClonePathProvider {
    private static final ExtensionPointName<ClonePathProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.clonePathProvider");

    @NotNull
    public static String defaultParentDirectoryPath(@NotNull Project project, @NotNull DvcsRememberedInputs rememberedInputs) {
        for (ClonePathProvider provider : EP_NAME.getExtensionList()) {
            String directoryPath = provider.getParentDirectoryPath(project, rememberedInputs);
            if (!StringUtil.isNotEmpty((String)directoryPath)) continue;
            return directoryPath;
        }
        String parentDirectory = rememberedInputs.getCloneParentDir();
        return StringUtil.isEmptyOrSpaces((String)parentDirectory) ? ProjectUtil.getBaseDir() : parentDirectory;
    }

    @NotNull
    public static String relativeDirectoryPathForVcsUrl(@NotNull Project project, @NotNull String vcsUrl) {
        for (ClonePathProvider provider : EP_NAME.getExtensionList()) {
            String directoryPath = provider.getRelativeDirectoryPathForVcsUrl(project, vcsUrl);
            if (!StringUtil.isNotEmpty((String)directoryPath)) continue;
            return directoryPath;
        }
        String encoded = PathUtil.getFileName((String)vcsUrl);
        try {
            return URLUtil.decode((String)encoded);
        }
        catch (Exception e) {
            return encoded;
        }
    }

    @Nullable
    public abstract String getParentDirectoryPath(@NotNull Project var1, @NotNull DvcsRememberedInputs var2);

    @Nullable
    public abstract String getRelativeDirectoryPathForVcsUrl(@NotNull Project var1, @NotNull String var2);
}

