/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRepositoryManager<T extends Repository>
implements RepositoryManager<T> {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final String myRepoDirName;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;

    protected AbstractRepositoryManager(@NotNull AbstractVcs vcs, @NotNull String repoDirName) {
        this.myGlobalRepositoryManager = VcsRepositoryManager.getInstance(vcs.getProject());
        this.myVcs = vcs;
        this.myRepoDirName = repoDirName;
    }

    @Nullable
    public T getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRoot(root));
    }

    @Nullable
    public T getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRootQuick(root));
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull T repository) {
        this.myGlobalRepositoryManager.addExternalRepository(root, (Repository)repository);
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        this.myGlobalRepositoryManager.removeExternalRepository(root);
    }

    public boolean isExternal(@NotNull T repository) {
        return this.myGlobalRepositoryManager.isExternal((Repository)repository);
    }

    @Nullable
    public T getRepositoryForFile(@NotNull VirtualFile file) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file));
    }

    @Nullable
    public T getRepositoryForFileQuick(@NotNull VirtualFile file) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFileQuick(file));
    }

    @Nullable
    public T getRepositoryForFile(@NotNull FilePath file) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file, false));
    }

    @Nullable
    public T getRepositoryForFileQuick(@NotNull FilePath file) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file, true));
    }

    @NotNull
    protected List<T> getRepositories(Class<T> type) {
        return ContainerUtil.findAll(this.myGlobalRepositoryManager.getRepositories(), type);
    }

    @NotNull
    public abstract List<T> getRepositories();

    public boolean moreThanOneRoot() {
        return this.getRepositories().size() > 1;
    }

    public void updateRepository(@Nullable VirtualFile root) {
        T repo = this.getRepositoryForRoot(root);
        if (repo != null) {
            repo.update();
        }
    }

    public void updateAllRepositories() {
        ContainerUtil.process(this.getRepositories(), repo -> {
            repo.update();
            return true;
        });
    }

    @Nullable
    private T validateAndGetRepository(@Nullable Repository repository) {
        if (repository == null || !this.myVcs.equals((Object)repository.getVcs())) {
            return null;
        }
        return (T)((Repository)ReadAction.compute(() -> {
            VirtualFile root = repository.getRoot();
            if (root.isValid()) {
                VirtualFile vcsDir = root.findChild(this.myRepoDirName);
                return vcsDir != null && vcsDir.exists() ? repository : null;
            }
            return null;
        }));
    }

    @NotNull
    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public boolean shouldProposeSyncControl() {
        return !MultiRootBranches.diverged(this.getRepositories());
    }
}

