/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.dvcs.push.ui.TextWithLinkNode;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.StepsProgressIndicator;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushController
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PushController.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final PushSource myPushSource;
    @NotNull
    private final Collection<? extends Repository> myAllRepos;
    @NotNull
    private final List<? extends Repository> myPreselectedRepositories;
    @NotNull
    private final List<PushSupport<Repository, PushSource, PushTarget>> myPushSupports;
    @NotNull
    private final PushLog myPushLog;
    @NotNull
    private final VcsPushDialog myDialog;
    @NotNull
    private final ModalityState myModalityState;
    @Nullable
    private final Repository myCurrentlyOpenedRepository;
    private final boolean mySingleRepoProject;
    private static final int DEFAULT_CHILDREN_PRESENTATION_NUMBER = 20;
    @NonNls
    private final ExecutorService myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DVCS Push");
    private final Map<RepositoryNode, MyRepoModel<Repository, PushSource, PushTarget>> myView2Model = new TreeMap<RepositoryNode, MyRepoModel<Repository, PushSource, PushTarget>>();

    public PushController(@NotNull Project project, @NotNull VcsPushDialog dialog, @NotNull Collection<? extends Repository> allRepos, @NotNull List<? extends Repository> preselectedRepositories, @Nullable Repository currentRepo, @Nullable PushSource pushSource) {
        this.myProject = project;
        this.myAllRepos = allRepos;
        this.myPreselectedRepositories = preselectedRepositories;
        this.myCurrentlyOpenedRepository = currentRepo;
        this.myPushSource = pushSource;
        this.myPushSupports = this.getAffectedSupports();
        this.mySingleRepoProject = this.isSingleRepoProject();
        this.myDialog = dialog;
        this.myModalityState = ModalityState.stateForComponent((Component)this.myDialog.getRootPane());
        CheckedTreeNode rootNode = new CheckedTreeNode(null);
        this.createTreeModel(rootNode);
        this.myPushLog = new PushLog(this.myProject, rootNode, this.isSyncStrategiesAllowed());
        this.myPushLog.getTree().addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PushController.this.myDialog.enableOkActions((Boolean)evt.getNewValue() == false);
            }
        });
        this.startLoadingCommits();
        Disposer.register((Disposable)dialog.getDisposable(), (Disposable)this);
    }

    private boolean isSyncStrategiesAllowed() {
        return !this.mySingleRepoProject && ContainerUtil.and(this.getAffectedSupports(), support -> support.mayChangeTargetsSync());
    }

    private boolean isSingleRepoProject() {
        return this.myAllRepos.size() == 1;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> List<PushSupport<R, S, T>> getAffectedSupports() {
        Set vcss = ContainerUtil.map2Set(this.myAllRepos, repository -> repository.getVcs());
        return ContainerUtil.map((Collection)vcss, vcs -> DvcsUtil.getPushSupport(vcs));
    }

    private void startLoadingCommits() {
        Object currentRepoModel;
        LinkedHashMap priorityLoading = new LinkedHashMap();
        LinkedHashMap others = new LinkedHashMap();
        RepositoryNode nodeForCurrentEditor = this.findNodeByRepo(this.myCurrentlyOpenedRepository);
        if (nodeForCurrentEditor != null && (this.isPreChecked((MyRepoModel<?, ?, ?>)(currentRepoModel = this.myView2Model.get(nodeForCurrentEditor))) || this.myPreselectedRepositories.isEmpty())) {
            priorityLoading.put(nodeForCurrentEditor, (MyRepoModel<?, ?, ?>)currentRepoModel);
            ((MyRepoModel)currentRepoModel).setChecked(true);
        }
        for (Map.Entry entry : this.myView2Model.entrySet()) {
            MyRepoModel model = (MyRepoModel)entry.getValue();
            RepositoryNode repoNode = (RepositoryNode)entry.getKey();
            if (this.isPreChecked(model)) {
                priorityLoading.putIfAbsent(repoNode, model);
                model.setChecked(true);
                continue;
            }
            if (!model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) continue;
            others.put(repoNode, model);
        }
        if (this.myPreselectedRepositories.isEmpty()) {
            boolean shouldScrollTo = this.myView2Model.values().stream().noneMatch(MyRepoModel::isSelected);
            this.myPushLog.highlightNodeOrFirst(nodeForCurrentEditor, shouldScrollTo);
        }
        this.loadCommitsFromMap(priorityLoading);
        this.loadCommitsFromMap(others);
    }

    private boolean isPreChecked(@NotNull MyRepoModel<?, ?, ?> model) {
        return Registry.is((String)"vcs.push.all.with.commits") || model.getSupport().getRepositoryManager().isSyncEnabled() || this.preselectByUser((Repository)model.getRepository());
    }

    private RepositoryNode findNodeByRepo(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myView2Model.entrySet(), entry1 -> {
            MyRepoModel model = (MyRepoModel)entry1.getValue();
            return model.getRepository().getRoot().equals(repository.getRoot());
        });
        return entry != null ? (RepositoryNode)entry.getKey() : null;
    }

    private void loadCommitsFromMap(@NotNull Map<RepositoryNode, MyRepoModel<?, ?, ?>> items) {
        for (Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>> entry : items.entrySet()) {
            RepositoryNode node = entry.getKey();
            this.loadCommits(entry.getValue(), node, true);
        }
    }

    private void createTreeModel(@NotNull CheckedTreeNode rootNode) {
        for (Repository repository : DvcsUtil.sortRepositories(this.myAllRepos)) {
            PushSupport support = this.getPushSupportByRepository(repository);
            if (support == null) continue;
            this.createRepoNode(repository, rootNode, (PushSource)ObjectUtils.chooseNotNull((Object)this.myPushSource, (Object)support.getSource(repository)), support);
        }
    }

    @Nullable
    private <R extends Repository, S extends PushSource, T extends PushTarget> PushSupport<R, S, T> getPushSupportByRepository(@NotNull R repository) {
        return (PushSupport)ContainerUtil.find(this.myPushSupports, support -> support.getVcs().equals((Object)repository.getVcs()));
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createRepoNode(@NotNull R repository, @NotNull CheckedTreeNode rootNode, @NotNull S source, @NotNull PushSupport<R, S, T> pushSupport) {
        PushTarget target = pushSupport.getDefaultTarget(repository, source);
        String repoName = this.getDisplayedRepoName(repository);
        final MyRepoModel<R, S, PushTarget> model = new MyRepoModel<R, S, PushTarget>(repository, pushSupport, this.mySingleRepoProject, source, target);
        if (target == null) {
            model.setError(VcsError.createEmptyTargetError((String)repoName));
        }
        PushTargetPanel pushTargetPanel = pushSupport.createTargetPanel(repository, source, target);
        final RepositoryWithBranchPanel repoPanel = new RepositoryWithBranchPanel(this.myProject, repoName, source.getPresentation(), pushTargetPanel);
        CheckBoxModel checkBoxModel = model.getCheckBoxModel();
        final RepositoryNode repoNode = this.mySingleRepoProject ? new SingleRepositoryNode(repoPanel, checkBoxModel) : new RepositoryNode(repoPanel, checkBoxModel, target != null);
        pushTargetPanel.setFireOnChangeAction(new Runnable(){

            @Override
            public void run() {
                repoPanel.fireOnChange();
                ((DefaultTreeModel)PushController.this.myPushLog.getTree().getModel()).nodeChanged((TreeNode)((Object)repoNode));
            }
        });
        this.myView2Model.put(repoNode, model);
        repoPanel.addRepoNodeListener(new RepositoryNodeListener<T>(){

            @Override
            public void onTargetChanged(T newTarget) {
                repoNode.setChecked(true);
                if (!newTarget.equals(model.getTarget()) || model.hasError() || !model.hasCommitInfo()) {
                    model.setTarget(newTarget);
                    model.clearErrors();
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onSelectionChanged(boolean isSelected) {
                PushController.this.myDialog.updateOkActions();
                if (isSelected && !model.hasCommitInfo() && !model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) {
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onTargetInEditMode(@NotNull String currentValue) {
                PushController.this.myPushLog.fireEditorUpdated(currentValue);
            }
        });
        rootNode.add((MutableTreeNode)((Object)repoNode));
    }

    @NotNull
    private String getDisplayedRepoName(@NotNull Repository repository) {
        String name = DvcsUtil.getShortRepositoryName(repository);
        int slash = name.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            return name;
        }
        String candidate = name.substring(slash + 1);
        return !this.containedInOtherNames(repository, candidate) ? candidate : name;
    }

    private boolean containedInOtherNames(@NotNull Repository except, String candidate) {
        return ContainerUtil.exists(this.myAllRepos, repository -> !repository.equals(except) && repository.getRoot().getName().equals(candidate));
    }

    public boolean isPushAllowed() {
        CheckboxTree tree = this.myPushLog.getTree();
        return !tree.isEditing() && ContainerUtil.exists(this.myPushSupports, support -> this.isPushAllowed((PushSupport<?, ?, ?>)support));
    }

    private boolean isPushAllowed(@NotNull PushSupport<?, ?, ?> pushSupport) {
        return ContainerUtil.exists(this.getNodesForSupport(pushSupport), node -> node.isChecked() && this.myView2Model.get(node).getTarget() != null);
    }

    @NotNull
    private Collection<RepositoryNode> getNodesForSupport(PushSupport<?, ?, ?> support) {
        return ContainerUtil.mapNotNull(this.myView2Model.entrySet(), entry -> support.equals(((MyRepoModel)entry.getValue()).getSupport()) ? (RepositoryNode)entry.getKey() : null);
    }

    private static boolean hasLoadingNodes(@NotNull Collection<RepositoryNode> nodes) {
        return ContainerUtil.exists(nodes, node -> node.isLoading());
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void loadCommits(@NotNull MyRepoModel<R, S, T> model, @NotNull RepositoryNode node, boolean initial) {
        node.cancelLoading();
        T target = model.getTarget();
        if (target == null) {
            node.stopLoading();
            return;
        }
        node.setEnabled(true);
        PushSupport support = model.getSupport();
        AtomicReference result2 = new AtomicReference();
        Runnable task2 = () -> {
            Object repository = model.getRepository();
            OutgoingResult outgoing = support.getOutgoingCommitsProvider().getOutgoingCommits(repository, new PushSpec(model.getSource(), model.getTarget()), initial);
            result2.compareAndSet(null, outgoing);
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    boolean shouldBeSelected;
                    OutgoingResult outgoing1 = (OutgoingResult)result2.get();
                    List errors = outgoing1.getErrors();
                    if (!errors.isEmpty()) {
                        shouldBeSelected = false;
                        model.setLoadedCommits(ContainerUtil.emptyList());
                        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), ContainerUtil.map((Collection)errors, error -> {
                            VcsLinkedTextComponent errorLinkText = new VcsLinkedTextComponent(error.getText(), new VcsLinkListener((VcsError)error, node, model){
                                final /* synthetic */ VcsError val$error;
                                final /* synthetic */ RepositoryNode val$node;
                                final /* synthetic */ MyRepoModel val$model;
                                {
                                    this.val$error = vcsError;
                                    this.val$node = repositoryNode;
                                    this.val$model = myRepoModel;
                                }

                                @Override
                                public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                                    this.val$error.handleError(new CommitLoader(){

                                        public void reloadCommits() {
                                            val$node.setChecked(true);
                                            PushController.this.loadCommits(val$model, val$node, false);
                                        }
                                    });
                                }
                            });
                            return new TextWithLinkNode(errorLinkText);
                        }));
                        if (node.isChecked()) {
                            node.setChecked(false);
                        }
                    } else {
                        List commits = outgoing1.getCommits();
                        model.setLoadedCommits(commits);
                        shouldBeSelected = this.shouldSelectNodeAfterLoad(model);
                        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), this.getPresentationForCommits(this.myProject, model.getLoadedCommits(), model.getNumberOfShownCommits()));
                        if (!commits.isEmpty() && shouldBeSelected) {
                            this.myPushLog.selectIfNothingSelected((TreeNode)((Object)node));
                        }
                    }
                    node.stopLoading();
                    this.updateLoadingPanel();
                    if (shouldBeSelected) {
                        node.setChecked(true);
                    } else if (initial) {
                        node.setChecked(false);
                    }
                    this.myDialog.updateOkActions();
                }, this.myModalityState);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        };
        node.startLoading((JTree)this.myPushLog.getTree(), this.myExecutorService.submit(task2, result2), initial);
        this.updateLoadingPanel();
    }

    private void updateLoadingPanel() {
        this.myPushLog.getTree().setPaintBusy(PushController.hasLoadingNodes(this.myView2Model.keySet()));
    }

    private boolean shouldSelectNodeAfterLoad(@NotNull MyRepoModel<?, ?, ?> model) {
        if (this.mySingleRepoProject) {
            return true;
        }
        return model.isSelected() && (PushController.hasCommitsToPush(model) || !model.getSupport().getRepositoryManager().isSyncEnabled() && !Registry.is((String)"vcs.push.all.with.commits"));
    }

    private boolean preselectByUser(@NotNull Repository repository) {
        return this.mySingleRepoProject || this.myPreselectedRepositories.contains(repository);
    }

    private static boolean hasCommitsToPush(@NotNull MyRepoModel<?, ?, ?> model) {
        Object target = model.getTarget();
        assert (target != null);
        return !model.getLoadedCommits().isEmpty() || target.hasSomethingToPush();
    }

    public PushLog getPushPanelLog() {
        return this.myPushLog;
    }

    @NotNull
    public PrePushHandler.Result executeHandlers(@NotNull ProgressIndicator indicator) throws ProcessCanceledException, HandlerException {
        List handlers = PrePushHandler.EP_NAME.getExtensionList((AreaInstance)this.myProject);
        if (handlers.isEmpty()) {
            return PrePushHandler.Result.OK;
        }
        List<PushInfo> pushDetails = this.preparePushDetails();
        StepsProgressIndicator stepsIndicator = new StepsProgressIndicator(indicator, handlers.size());
        stepsIndicator.setIndeterminate(false);
        stepsIndicator.setFraction(0.0);
        for (int index = 0; index < handlers.size(); ++index) {
            PrePushHandler.Result prePushHandlerResult;
            PrePushHandler handler = (PrePushHandler)handlers.get(index);
            stepsIndicator.checkCanceled();
            stepsIndicator.setText(handler.getPresentableName());
            try {
                prePushHandlerResult = handler.handle(pushDetails, (ProgressIndicator)stepsIndicator);
            }
            catch (Throwable e) {
                List<String> skippedHandlers = handlers.stream().skip(index + 1).map(h -> h.getPresentableName()).collect(Collectors.toList());
                throw new HandlerException(handler.getPresentableName(), skippedHandlers, e);
            }
            if (prePushHandlerResult != PrePushHandler.Result.OK) {
                return prePushHandlerResult;
            }
            stepsIndicator.setIndeterminate(false);
            stepsIndicator.nextStep();
        }
        return PrePushHandler.Result.OK;
    }

    public void push(boolean force) {
        for (PushSupport<Repository, PushSource, PushTarget> support : this.myPushSupports) {
            this.doPushSynchronously(support, force);
        }
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void doPushSynchronously(@NotNull PushSupport<R, S, T> support, boolean force) {
        VcsPushOptionValue options = this.myDialog.getAdditionalOptionValue(support);
        Pusher pusher = support.getPusher();
        Map<R, PushSpec<S, T>> specs = this.collectPushSpecsForVcs(support);
        if (!specs.isEmpty()) {
            pusher.push(specs, options, force);
        }
    }

    private static <R extends Repository, S extends PushSource, T extends PushTarget> List<? extends VcsFullCommitDetails> loadCommits(@NotNull MyRepoModel<R, S, T> model) {
        PushSupport<R, S, T> support = model.getSupport();
        R repository = model.getRepository();
        S source = model.getSource();
        T target = model.getTarget();
        if (target == null) {
            return ContainerUtil.emptyList();
        }
        OutgoingCommitsProvider outgoingCommitsProvider = support.getOutgoingCommitsProvider();
        return outgoingCommitsProvider.getOutgoingCommits(repository, new PushSpec(source, target), true).getCommits();
    }

    @NotNull
    private List<PushInfo> preparePushDetails() {
        ArrayList<PushInfoImpl> allDetails = new ArrayList<PushInfoImpl>();
        Collection<MyRepoModel<Repository, PushSource, PushTarget>> repoModels = this.getSelectedRepoNode();
        for (MyRepoModel<Repository, PushSource, PushTarget> model : repoModels) {
            PushTarget target = model.getTarget();
            if (target == null) continue;
            PushSpec pushSpec = new PushSpec(model.getSource(), target);
            ArrayList<VcsFullCommitDetails> loadedCommits = new ArrayList<VcsFullCommitDetails>(model.getLoadedCommits());
            if (loadedCommits.isEmpty()) {
                loadedCommits.addAll(PushController.loadCommits(model));
            }
            Collections.reverse(loadedCommits);
            allDetails.add(new PushInfoImpl(model.getRepository(), pushSpec, loadedCommits));
        }
        return Collections.unmodifiableList(allDetails);
    }

    @NotNull
    public Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> getSelectedPushSpecs() {
        HashMap<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> result2 = new HashMap<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>>();
        for (MyRepoModel<Repository, PushSource, PushTarget> repoModel : this.getSelectedRepoNode()) {
            PushTarget target = repoModel.getTarget();
            if (target == null) continue;
            PushSpec spec = new PushSpec(repoModel.getSource(), target);
            PushInfoImpl pushInfo = new PushInfoImpl(repoModel.getRepository(), spec, ContainerUtil.emptyList());
            ArrayList<PushInfoImpl> list = (ArrayList<PushInfoImpl>)result2.get(((MyRepoModel)repoModel).mySupport);
            if (list == null) {
                list = new ArrayList<PushInfoImpl>();
                result2.put((PushSupport<Repository, PushSource, PushTarget>)((MyRepoModel)repoModel).mySupport, list);
            }
            list.add(pushInfo);
        }
        return result2;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> Map<R, PushSpec<S, T>> collectPushSpecsForVcs(@NotNull PushSupport<R, S, T> pushSupport) {
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> allSpecs = this.getSelectedPushSpecs();
        Collection<PushInfo> pushInfos = allSpecs.get(pushSupport);
        return pushInfos != null ? ContainerUtil.map2Map(pushInfos, pushInfo -> {
            PushSpec<PushSource, PushTarget> pushSpec = pushInfo.getPushSpec();
            return new Pair((Object)pushInfo.getRepository(), pushSpec);
        }) : Collections.emptyMap();
    }

    private Collection<MyRepoModel<Repository, PushSource, PushTarget>> getSelectedRepoNode() {
        if (this.mySingleRepoProject) {
            return this.myView2Model.values();
        }
        return ContainerUtil.mapNotNull(this.myView2Model.entrySet(), entry -> {
            MyRepoModel model = (MyRepoModel)entry.getValue();
            return model.isSelected() && model.getTarget() != null ? model : null;
        });
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private void addMoreCommits(RepositoryNode repositoryNode) {
        MyRepoModel<Repository, PushSource, PushTarget> repoModel = this.myView2Model.get(repositoryNode);
        repoModel.increaseShownCommits();
        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)repositoryNode), this.getPresentationForCommits(this.myProject, repoModel.getLoadedCommits(), repoModel.getNumberOfShownCommits()));
    }

    @NotNull
    private List<DefaultMutableTreeNode> getPresentationForCommits(@NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits, int commitsNum) {
        Function commitToNode = commit -> new CommitNode(project, (VcsFullCommitDetails)commit);
        ArrayList<DefaultMutableTreeNode> childrenToShown = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < commits.size(); ++i) {
            if (i >= commitsNum) {
                VcsLinkedTextComponent moreCommitsLink = new VcsLinkedTextComponent("<a href='loadMore'>...</a>", new VcsLinkListener(){

                    @Override
                    public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                        TreeNode parent = sourceNode.getParent();
                        if (parent instanceof RepositoryNode) {
                            PushController.this.addMoreCommits((RepositoryNode)((Object)parent));
                        }
                    }
                });
                childrenToShown.add(new TextWithLinkNode(moreCommitsLink));
                break;
            }
            childrenToShown.add((DefaultMutableTreeNode)commitToNode.fun((Object)commits.get(i)));
        }
        return childrenToShown;
    }

    @NotNull
    public Map<PushSupport<?, ?, ?>, VcsPushOptionsPanel> createAdditionalPanels() {
        LinkedHashMap result2 = new LinkedHashMap();
        for (PushSupport<Repository, PushSource, PushTarget> support : this.myPushSupports) {
            ContainerUtil.putIfNotNull(support, (Object)support.createOptionsPanel(), result2);
        }
        return result2;
    }

    private static final class MyRepoModel<Repo extends Repository, S extends PushSource, T extends PushTarget> {
        @NotNull
        private final Repo myRepository;
        @NotNull
        private final PushSupport<Repo, S, T> mySupport;
        @NotNull
        private final S mySource;
        @Nullable
        private T myTarget;
        @Nullable
        VcsError myTargetError;
        int myNumberOfShownCommits;
        @NotNull
        List<? extends VcsFullCommitDetails> myLoadedCommits = Collections.emptyList();
        @NotNull
        private final CheckBoxModel myCheckBoxModel;

        MyRepoModel(@NotNull Repo repository, @NotNull PushSupport<Repo, S, T> supportForRepo, boolean isSelected, @NotNull S source, @Nullable T target) {
            this.myRepository = repository;
            this.mySupport = supportForRepo;
            this.myCheckBoxModel = new CheckBoxModel(isSelected);
            this.mySource = source;
            this.myTarget = target;
            this.myNumberOfShownCommits = 20;
        }

        @NotNull
        public Repo getRepository() {
            return this.myRepository;
        }

        @NotNull
        public PushSupport<Repo, S, T> getSupport() {
            return this.mySupport;
        }

        @NotNull
        public S getSource() {
            return this.mySource;
        }

        @Nullable
        public T getTarget() {
            return this.myTarget;
        }

        public void setTarget(@Nullable T target) {
            this.myTarget = target;
        }

        public boolean isSelected() {
            return this.myCheckBoxModel.isChecked();
        }

        public void setError(@Nullable VcsError error) {
            this.myTargetError = error;
        }

        public void clearErrors() {
            this.myTargetError = null;
        }

        public boolean hasError() {
            return this.myTargetError != null;
        }

        public int getNumberOfShownCommits() {
            return this.myNumberOfShownCommits;
        }

        public void increaseShownCommits() {
            this.myNumberOfShownCommits *= 2;
        }

        @NotNull
        public List<? extends VcsFullCommitDetails> getLoadedCommits() {
            return this.myLoadedCommits;
        }

        public void setLoadedCommits(@NotNull List<? extends VcsFullCommitDetails> loadedCommits) {
            this.myLoadedCommits = loadedCommits;
        }

        public boolean hasCommitInfo() {
            return this.myTargetError != null || !this.myLoadedCommits.isEmpty();
        }

        @NotNull
        public CheckBoxModel getCheckBoxModel() {
            return this.myCheckBoxModel;
        }

        public void setChecked(boolean checked) {
            this.myCheckBoxModel.setChecked(checked);
        }
    }

    private static class PushInfoImpl
    implements PushInfo {
        private final Repository myRepository;
        private final PushSpec<PushSource, PushTarget> myPushSpec;
        private final List<VcsFullCommitDetails> myCommits;

        private PushInfoImpl(@NotNull Repository repository, @NotNull PushSpec<PushSource, PushTarget> spec, @NotNull List<VcsFullCommitDetails> commits) {
            this.myRepository = repository;
            this.myPushSpec = spec;
            this.myCommits = commits;
        }

        @Override
        @NotNull
        public Repository getRepository() {
            return this.myRepository;
        }

        @Override
        @NotNull
        public PushSpec<PushSource, PushTarget> getPushSpec() {
            return this.myPushSpec;
        }

        @Override
        @NotNull
        public List<VcsFullCommitDetails> getCommits() {
            return this.myCommits;
        }
    }

    public static class HandlerException
    extends RuntimeException {
        private final String myFailedHandlerName;
        private final List<String> mySkippedHandlers;

        public HandlerException(@NotNull String failedHandlerName, @NotNull List<String> skippedHandlers, @NotNull Throwable cause) {
            super(cause);
            this.myFailedHandlerName = failedHandlerName;
            this.mySkippedHandlers = skippedHandlers;
        }

        @NotNull
        public String getFailedHandlerName() {
            return this.myFailedHandlerName;
        }

        @NotNull
        public List<String> getSkippedHandlers() {
            return this.mySkippedHandlers;
        }
    }
}

