/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.ProjectService;
import com.android.tools.game.ProjectWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import io.grpc.Status;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/game/ProjectServiceImpl;", "Lcom/android/tools/game/ProjectService;", "()V", "pool", "", "", "Lcom/android/tools/game/ProjectWrapper;", "projectManager", "Lcom/intellij/openapi/project/ProjectManager;", "kotlin.jvm.PlatformType", "createProject", "name", "path", "Ljava/nio/file/Path;", "getProject", "projectId", "android.game-tools.main"})
public final class ProjectServiceImpl
implements ProjectService {
    private final ProjectManager projectManager = ProjectManager.getInstance();
    private final Map<String, ProjectWrapper> pool = new HashMap();

    @Override
    @NotNull
    public ProjectWrapper getProject(@NotNull String projectId) {
        ProjectWrapper projectWrapper = this.pool.get(projectId);
        if (projectWrapper == null) {
            throw (Throwable)Status.NOT_FOUND.withDescription("Project '" + projectId + "' is not found.").asRuntimeException();
        }
        return projectWrapper;
    }

    @Override
    @NotNull
    public ProjectWrapper createProject(@NotNull String name, @NotNull Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw (Throwable)Status.INVALID_ARGUMENT.withDescription(path + " is not a valid directory to create project.").asRuntimeException();
        }
        String projectId = UUID.randomUUID().toString();
        Project project = this.projectManager.createProject(name, ((Object)path.toAbsolutePath()).toString());
        if (project == null) {
            throw (Throwable)Status.INTERNAL.withDescription("Cannot create project at location '" + path + "'.").asRuntimeException();
        }
        Project ideaProject = project;
        ProjectWrapper gameProject = new ProjectWrapper(projectId, ideaProject, path);
        this.pool.put(projectId, gameProject);
        return gameProject;
    }
}

