/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.SdkConstants;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.game.GameToolsServer;
import com.android.tools.game.GameToolsStarter;
import com.android.tools.game.GameToolsStarter$WhenMappings;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.ProjectServiceImpl;
import com.android.tools.game.ProjectWrapper;
import com.android.tools.game.WindowWrapper;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.profilers.AndroidProfilerService;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.util.SystemProperties;
import java.awt.Font;
import java.io.File;
import java.nio.file.Paths;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/game/GameToolsStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "mode", "Lcom/android/tools/game/GameToolsStarter$Mode;", "allowAnyModalityState", "", "fatal", "", "message", "", "getCommandName", "isHeadless", "main", "", "args", "", "([Ljava/lang/String;)V", "startApp", "Lcom/android/tools/game/WindowWrapper;", "appWindow", "Lcom/android/tools/game/GameToolsStarter$AppWindow;", "AppWindow", "Mode", "android.game-tools.main"})
public final class GameToolsStarter
implements ApplicationStarter {
    private final Logger logger;
    private Mode mode;

    @NotNull
    public String getCommandName() {
        return "game-tools";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(@NotNull String[] args) {
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)AndroidStudioEvent.IdeBrand.GAME_TOOLS);
        try {
            boolean bl;
            String string;
            int port = 0;
            AppWindow appWindow = null;
            File sdkPath = null;
            Iterator it = ArrayIteratorKt.iterator((Object[])args);
            while (it.hasNext()) {
                switch ((String)it.next()) {
                    case "--mode": {
                        this.mode = Mode.valueOf((String)it.next());
                        break;
                    }
                    case "--port": {
                        string = (String)it.next();
                        bl = false;
                        port = Integer.parseInt(string);
                        break;
                    }
                    case "--app-window": {
                        appWindow = AppWindow.valueOf((String)it.next());
                        break;
                    }
                    case "--android-sdk": {
                        sdkPath = new File((String)it.next());
                        break;
                    }
                }
            }
            if (sdkPath == null) {
                File file = IdeSdks.getInstance().getAndroidSdkPath();
                if (file == null) {
                    file = sdkPath = AndroidSdkInitializer.findOrGetAndroidSdkPath();
                }
                if (sdkPath == null) {
                    Void void_ = this.fatal("Cannot find Android SDK your system. Please install the Android SDK and set the 'ANDROID_SDK_ROOT' environment variable.");
                    throw null;
                }
            }
            File adbFile = new File(sdkPath, AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
            AndroidStudioAnalytics.getInstance().initializeAndroidStudioUsageTrackerAndPublisher();
            Runtime.getRuntime().addShutdownHook(new Thread(main.1.INSTANCE));
            AdbService.getInstance().getDebugBridge(adbFile).get();
            AndroidProfilerService.getInstance();
            Runnable runnable = SplashManager.getHideTask();
            if (runnable != null) {
                runnable.run();
            }
            string = KeymapManager.getInstance().getActiveKeymap();
            bl = false;
            boolean bl2 = false;
            String $this$apply = string;
            boolean bl3 = false;
            $this$apply.removeAllActionShortcuts("GotoAction");
            $this$apply.removeAllActionShortcuts("ShowSettings");
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GAME_TOOLS_PING).setProductDetails(AndroidStudioUsageTracker.getProductDetails()).setMachineDetails(AndroidStudioUsageTracker.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails()));
            Mode mode = this.mode;
            if (mode != null) {
                switch (GameToolsStarter$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                    case 1: {
                        if (port == 0) {
                            Void void_ = this.fatal("You must specify a port with '--port' in SERVER mode.");
                            throw null;
                        }
                        new GameToolsServer(port, null, null, 6, null).start();
                        return;
                    }
                    case 2: {
                        if (appWindow == null) {
                            Void void_ = this.fatal("You must specify a window to open with '--app-window [PROFILER]' in APP mode.");
                            throw null;
                        }
                        this.startApp(appWindow);
                        return;
                    }
                    case 3: {
                        GameToolsServer gameToolsServer = new GameToolsServer(0, null, null, 6, null);
                        gameToolsServer.start();
                        gameToolsServer.shutdown();
                        this.startApp(AppWindow.PROFILER).closeWindow();
                        return;
                    }
                }
            }
            Void void_ = this.fatal("You must specify a mode with '--mode [APP|SERVER|VERIFY]'.");
            throw null;
        }
        catch (Throwable e) {
            this.logger.error("GameToolsServer crashed!", e);
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final Void fatal(String message) {
        File ideaLog = new File(PathManager.getLogPath(), "idea.log");
        if (this.mode == Mode.SERVER || this.mode == Mode.VERIFY) {
            this.logger.error(message + " For more details, see " + ideaLog);
        } else {
            Font font = new JLabel().getFont();
            boolean bl = false;
            boolean bl2 = false;
            Font $this$run = font;
            boolean bl3 = false;
            String style = StringsKt.trimIndent((String)("\n          font-family:" + $this$run.getFamily() + ";\n          font-weight:" + ($this$run.isBold() ? "bold" : "normal") + ";\n          font-size:" + $this$run.getSize() + "pt;\n        "));
            JEditorPane messagePane = new JEditorPane("text/html", StringsKt.trimIndent((String)("\n          <html>\n            <body style=\"" + style + "\">\n              " + message + "\n              <br>\n              For more details, see the <a href=\"#placeholder\">idea.log</a>.\n            </body>\n          </html>\n          ")));
            messagePane.addHyperlinkListener(new HyperlinkListener(ideaLog){
                final /* synthetic */ File $ideaLog;

                public final void hyperlinkUpdate(HyperlinkEvent e) {
                    if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        RevealFileAction.openFile((File)this.$ideaLog);
                    }
                }
                {
                    this.$ideaLog = file;
                }
            });
            messagePane.setEditable(false);
            messagePane.setBackground(new JLabel().getBackground());
            JOptionPane.showMessageDialog(null, messagePane, "Error", 0);
        }
        int n = 1;
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private final WindowWrapper startApp(AppWindow appWindow) {
        switch (GameToolsStarter$WhenMappings.$EnumSwitchMapping$1[appWindow.ordinal()]) {
            case 1: {
                ProjectWrapper project = new ProjectServiceImpl().createProject("Empty Project", Paths.get(SystemProperties.getUserHome(), new String[0]));
                return new ProfilerServiceImpl().createProfilerWindow(project, (Function2<? super ProjectWrapper, ? super WindowWrapper, Unit>)((Function2)startApp.1.INSTANCE));
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public boolean isHeadless() {
        return false;
    }

    public boolean allowAnyModalityState() {
        return true;
    }

    public GameToolsStarter() {
        boolean $i$f$logger = false;
        this.logger = Logger.getInstance(GameToolsStarter.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/game/GameToolsStarter$Mode;", "", "(Ljava/lang/String;I)V", "SERVER", "APP", "VERIFY", "android.game-tools.main"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode SERVER;
        public static final /* enum */ Mode APP;
        public static final /* enum */ Mode VERIFY;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = SERVER = new Mode();
            modeArray[1] = APP = new Mode();
            modeArray[2] = VERIFY = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/game/GameToolsStarter$AppWindow;", "", "(Ljava/lang/String;I)V", "PROFILER", "android.game-tools.main"})
    private static final class AppWindow
    extends Enum<AppWindow> {
        public static final /* enum */ AppWindow PROFILER;
        private static final /* synthetic */ AppWindow[] $VALUES;

        static {
            AppWindow[] appWindowArray = new AppWindow[1];
            AppWindow[] appWindowArray2 = appWindowArray;
            appWindowArray[0] = PROFILER = new AppWindow();
            $VALUES = appWindowArray;
        }

        public static AppWindow[] values() {
            return (AppWindow[])$VALUES.clone();
        }

        public static AppWindow valueOf(String string) {
            return Enum.valueOf(AppWindow.class, string);
        }
    }
}

