/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class XmlUtils {
    private static final String TRUE_ATTRIBUTE_VALUE = "y";
    private static final String FALSE_ATTRIBUTE_VALUE = "n";

    private XmlUtils() {
    }

    static Long parseLongAttribute(XmlPullParser parser, String attributeName, Long defaultValue) throws XmlPullParserException {
        String attributeValueString = parser.getAttributeValue(null, attributeName);
        if (attributeValueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(attributeValueString);
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Attribute \"" + attributeName + "\" is not a long value: " + parser.getPositionDescription());
        }
    }

    static Boolean parseBooleanAttribute(XmlPullParser parser, String attributeName, Boolean defaultValue) throws XmlPullParserException {
        String attributeValueString = parser.getAttributeValue(null, attributeName);
        if (attributeValueString == null) {
            return defaultValue;
        }
        boolean isTrue = TRUE_ATTRIBUTE_VALUE.equals(attributeValueString);
        if (!isTrue && !FALSE_ATTRIBUTE_VALUE.equals(attributeValueString)) {
            throw new XmlPullParserException("Attribute \"" + attributeName + "\" is not \"y\" or \"n\": " + parser.getPositionDescription());
        }
        return isTrue;
    }

    static void findNextStartTagOrThrowNoRecurse(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (!XmlUtils.findNextStartTagOrEndTagNoRecurse(parser, elementName)) {
            throw new XmlPullParserException("No next element found with name " + elementName);
        }
    }

    static boolean findNextStartTagOrEndTagNoRecurse(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        int type;
        block4: while ((type = parser.next()) != 1) {
            switch (type) {
                case 2: {
                    String currentElementName = parser.getName();
                    if (elementName.equals(currentElementName)) {
                        return true;
                    }
                    parser.next();
                    XmlUtils.consumeUntilEndTag(parser, currentElementName);
                    continue block4;
                }
                case 3: {
                    return false;
                }
            }
        }
        throw new XmlPullParserException("Unexpected end of document while looking for " + elementName);
    }

    static void consumeUntilEndTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (XmlUtils.isEndTag(parser, elementName)) {
            return;
        }
        int requiredDepth = parser.getDepth();
        if (parser.getEventType() == 2) {
            --requiredDepth;
        }
        while (parser.getEventType() != 1) {
            int type = parser.next();
            int currentDepth = parser.getDepth();
            if (currentDepth < requiredDepth) {
                throw new XmlPullParserException("Unexpected depth while looking for end tag: " + parser.getPositionDescription());
            }
            if (currentDepth != requiredDepth || type != 3) continue;
            if (elementName.equals(parser.getName())) {
                return;
            }
            throw new XmlPullParserException("Unexpected eng tag: " + parser.getPositionDescription());
        }
        throw new XmlPullParserException("Unexpected end of document");
    }

    static void checkOnEndTag(XmlPullParser parser, String elementName) throws XmlPullParserException {
        if (!XmlUtils.isEndTag(parser, elementName)) {
            throw new XmlPullParserException("Unexpected tag encountered: " + parser.getPositionDescription());
        }
    }

    private static boolean isEndTag(XmlPullParser parser, String elementName) throws XmlPullParserException {
        return parser.getEventType() == 3 && parser.getName().equals(elementName);
    }

    static String normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    static String consumeText(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type = parser.next();
        if (type != 4) {
            throw new XmlPullParserException("Text not found. Found type=" + type + " at " + parser.getPositionDescription());
        }
        String text = parser.getText();
        type = parser.next();
        if (type != 3) {
            throw new XmlPullParserException("Unexpected nested tag or end of document when expecting text: type=" + type + " at " + parser.getPositionDescription());
        }
        return text;
    }

    static interface ReaderSupplier {
        public Reader get() throws IOException;

        public static ReaderSupplier forFile(String fileName, Charset charSet) throws IOException {
            Path file = Paths.get(fileName, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException(fileName + " does not exist");
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
                throw new IOException(fileName + " must be a regular readable file.");
            }
            return () -> Files.newBufferedReader(file, charSet);
        }

        public static ReaderSupplier forString(String xml2) {
            return () -> new StringReader(xml2);
        }
    }
}

