/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.utils.contrast;

import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Color;

public class ContrastUtils {
    public static final int WCAG_LARGE_TEXT_MIN_SIZE = 18;
    public static final int WCAG_LARGE_BOLD_TEXT_MIN_SIZE = 14;
    public static final int COLOR_SECURE_WINDOW_CENSOR = -16777216;
    public static final double CONTRAST_RATIO_WCAG_NORMAL_TEXT = 4.5;
    public static final double CONTRAST_RATIO_WCAG_LARGE_TEXT = 3.0;

    private ContrastUtils() {
    }

    public static double calculateLuminance(int color2) {
        double r = ContrastUtils.linearColor(Color.red(color2));
        double g = ContrastUtils.linearColor(Color.green(color2));
        double b = ContrastUtils.linearColor(Color.blue(color2));
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private static double linearColor(int component) {
        double sRGB = (double)component / 255.0;
        if (sRGB <= 0.03928) {
            return sRGB / 12.92;
        }
        return Math.pow((sRGB + 0.055) / 1.055, 2.4);
    }

    public static double colorDifference(int color1, int color2) {
        double c2;
        double[] lab1 = ContrastUtils.rgb2lab(color1);
        double[] lab2 = ContrastUtils.rgb2lab(color2);
        double deltaL = lab1[0] - lab2[0];
        double deltaA = lab1[1] - lab2[1];
        double deltaB = lab1[2] - lab2[2];
        double c1 = Math.hypot(lab1[1], lab1[2]);
        double deltaC = c1 - (c2 = Math.hypot(lab2[1], lab2[2]));
        double deltaH = deltaA * deltaA + deltaB * deltaB - deltaC * deltaC;
        deltaH = deltaH < 0.0 ? 0.0 : Math.sqrt(deltaH);
        double sc = 1.0 + 0.045 * c1;
        double sh = 1.0 + 0.015 * c1;
        double deltaLKlsl = deltaL / 1.0;
        double deltaCkcsc = deltaC / sc;
        double deltaHkhsh = deltaH / sh;
        return Math.sqrt(deltaLKlsl * deltaLKlsl + deltaCkcsc * deltaCkcsc + deltaHkhsh * deltaHkhsh);
    }

    public static double[] rgb2lab(int color2) {
        double r = ContrastUtils.linearColor(Color.red(color2));
        double g = ContrastUtils.linearColor(Color.green(color2));
        double b = ContrastUtils.linearColor(Color.blue(color2));
        double x = (r * 0.4124 + g * 0.3576 + b * 0.1805) / 0.95047;
        double y = (r * 0.2126 + g * 0.7152 + b * 0.0722) / 1.0;
        double z = (r * 0.0193 + g * 0.1192 + b * 0.9505) / 1.08883;
        x = x > 0.008856 ? Math.cbrt(x) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.cbrt(y) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.cbrt(z) : 7.787 * z + 0.13793103448275862;
        return new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
    }

    public static double calculateContrastRatio(int color1, int color2) {
        return ContrastUtils.calculateContrastRatio(ContrastUtils.calculateLuminance(color1), ContrastUtils.calculateLuminance(color2));
    }

    public static double calculateContrastRatio(double lum1, double lum2) {
        if (lum1 < 0.0 || lum2 < 0.0) {
            throw new IllegalArgumentException("Luminance values may not be negative.");
        }
        return (Math.max(lum1, lum2) + 0.05) / (Math.min(lum1, lum2) + 0.05);
    }

    public static String colorToHexString(int color2) {
        return String.format("#%06X", 0xFFFFFF & color2);
    }
}

