/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.uielement.DeviceState;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityHierarchy {
    private final DeviceState deviceState;
    private final List<? extends WindowHierarchyElement> windowHierarchyElements;
    private final WindowHierarchyElement activeWindow;
    protected final ViewElementClassNames viewElementClassNames;

    protected AccessibilityHierarchy(DeviceState deviceState, List<? extends WindowHierarchyElement> windowHierarchyElements, WindowHierarchyElement activeWindow, ViewElementClassNames viewElementClassNames) {
        this.deviceState = deviceState;
        this.windowHierarchyElements = windowHierarchyElements;
        this.activeWindow = activeWindow;
        this.viewElementClassNames = viewElementClassNames;
    }

    public DeviceState getDeviceState() {
        return this.deviceState;
    }

    public Collection<? extends WindowHierarchyElement> getAllWindows() {
        return Collections.unmodifiableCollection(this.windowHierarchyElements);
    }

    public WindowHierarchyElement getActiveWindow() {
        return this.activeWindow;
    }

    public WindowHierarchyElement getWindowById(int id2) {
        if (id2 < 0 || id2 >= this.windowHierarchyElements.size()) {
            throw new NoSuchElementException();
        }
        return this.windowHierarchyElements.get(id2);
    }

    public ViewHierarchyElement getViewById(long condensedUniqueId) {
        int windowId = (int)(condensedUniqueId >>> 32);
        int viewId = (int)condensedUniqueId;
        return this.getWindowById(windowId).getViewById(viewId);
    }

    public AccessibilityHierarchyProtos.AccessibilityHierarchyProto toProto() {
        AccessibilityHierarchyProtos.AccessibilityHierarchyProto.Builder builder = AccessibilityHierarchyProtos.AccessibilityHierarchyProto.newBuilder();
        builder.setDeviceState(this.deviceState.toProto()).setActiveWindowId(this.activeWindow.getId()).setViewElementClassNames(this.viewElementClassNames.toProto());
        for (WindowHierarchyElement windowHierarchyElement : this.windowHierarchyElements) {
            builder.addWindows(windowHierarchyElement.toProto());
        }
        return (AccessibilityHierarchyProtos.AccessibilityHierarchyProto)builder.build();
    }

    private void setAccessibilityHierarchy() {
        for (WindowHierarchyElement windowHierarchyElement : this.windowHierarchyElements) {
            windowHierarchyElement.setAccessibilityHierarchy(this);
        }
    }

    public static Builder newBuilder(AccessibilityHierarchyProtos.AccessibilityHierarchyProto proto) {
        Builder builder = new Builder();
        builder.proto = (AccessibilityHierarchyProtos.AccessibilityHierarchyProto)Preconditions.checkNotNull((Object)proto);
        return builder;
    }

    ViewElementClassNames getViewElementClassNames() {
        return this.viewElementClassNames;
    }

    public static class Builder {
        protected  @Nullable AccessibilityHierarchyProtos.AccessibilityHierarchyProto proto;

        public AccessibilityHierarchy build() {
            if (this.proto == null) {
                throw new IllegalStateException("Nothing from which to build");
            }
            AccessibilityHierarchy result = this.buildHierarchyFromProto(this.proto);
            return result;
        }

        private AccessibilityHierarchy buildHierarchyFromProto(AccessibilityHierarchyProtos.AccessibilityHierarchyProto proto) {
            DeviceState deviceState = new DeviceState(proto.getDeviceState());
            int activeWindowId = proto.getActiveWindowId();
            ArrayList<WindowHierarchyElement> windowHierarchyElements = new ArrayList<WindowHierarchyElement>(proto.getWindowsCount());
            for (AccessibilityHierarchyProtos.WindowHierarchyElementProto windowProto : proto.getWindowsList()) {
                windowHierarchyElements.add(WindowHierarchyElement.newBuilder(windowProto).build());
            }
            Preconditions.checkState((!windowHierarchyElements.isEmpty() ? 1 : 0) != 0, (Object)"Hierarchies must contain at least one window.");
            WindowHierarchyElement activeWindow = (WindowHierarchyElement)windowHierarchyElements.get(activeWindowId);
            ViewElementClassNames viewElementClassNames = new ViewElementClassNames(proto.getViewElementClassNames());
            AccessibilityHierarchy hierarchy = new AccessibilityHierarchy(deviceState, windowHierarchyElements, activeWindow, viewElementClassNames);
            hierarchy.setAccessibilityHierarchy();
            return hierarchy;
        }
    }

    static class ViewElementClassNames {
        protected ImmutableBiMap<String, Integer> uniqueViewElementsClassNames;

        protected ViewElementClassNames() {
        }

        public ViewElementClassNames(Map<String, Integer> viewElementsMap) {
            this.uniqueViewElementsClassNames = ImmutableBiMap.copyOf(viewElementsMap);
        }

        public ViewElementClassNames(AccessibilityHierarchyProtos.ViewElementClassNamesProto proto) {
            this.uniqueViewElementsClassNames = ImmutableBiMap.copyOf(proto.getClassNameMap());
        }

        public @Nullable Integer getIdentifierForClassName(String className) {
            return (Integer)this.uniqueViewElementsClassNames.get((Object)className);
        }

        public @Nullable String getClassNameForIdentifier(int id2) {
            return (String)this.uniqueViewElementsClassNames.inverse().get((Object)id2);
        }

        AccessibilityHierarchyProtos.ViewElementClassNamesProto toProto() {
            return (AccessibilityHierarchyProtos.ViewElementClassNamesProto)AccessibilityHierarchyProtos.ViewElementClassNamesProto.newBuilder().putAllClassName((Map<String, Integer>)this.uniqueViewElementsClassNames).build();
        }

        ImmutableBiMap<String, Integer> getMap() {
            return this.uniqueViewElementsClassNames;
        }
    }
}

