/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.view.inputmethod.ExtractedText;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CancellationGroup {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ArrayList<CountDownLatch> mLatchList = null;
    @GuardedBy(value={"mLock"})
    private boolean mCanceled = false;

    public Completable.Int createCompletableInt() {
        return new Completable.Int(this);
    }

    public Completable.CharSequence createCompletableCharSequence() {
        return new Completable.CharSequence(this);
    }

    public Completable.ExtractedText createCompletableExtractedText() {
        return new Completable.ExtractedText(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerLatch(CountDownLatch latch) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCanceled) {
                return false;
            }
            if (this.mLatchList == null) {
                this.mLatchList = new ArrayList(1);
            }
            this.mLatchList.add(latch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLatch(CountDownLatch latch) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLatchList != null) {
                this.mLatchList.remove(latch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCanceled) {
                this.mCanceled = true;
                if (this.mLatchList != null) {
                    this.mLatchList.forEach(CountDownLatch::countDown);
                    this.mLatchList.clear();
                    this.mLatchList = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCanceled;
        }
    }

    public static class Completable {
        private Completable() {
        }

        public static class ExtractedText
        extends Values<android.view.inputmethod.ExtractedText> {
            private ExtractedText(CancellationGroup factory) {
                super(factory);
            }
        }

        public static class CharSequence
        extends Values<java.lang.CharSequence> {
            private CharSequence(CancellationGroup factory) {
                super(factory);
            }
        }

        public static class Values<T>
        extends ValueBase {
            @GuardedBy(value={"mValueLock"})
            private T mValue = null;

            protected Values(CancellationGroup factory) {
                super(factory);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void onComplete(T value) {
                Object object = this.mValueLock;
                synchronized (object) {
                    if (this.mHasValue) {
                        throw new UnsupportedOperationException("onComplete() cannot be called multiple times");
                    }
                    this.mValue = value;
                    this.mHasValue = true;
                }
                this.onComplete();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T getValue() {
                Object object = this.mValueLock;
                synchronized (object) {
                    if (!this.mHasValue) {
                        throw new UnsupportedOperationException("getValue() is allowed only if hasValue() returns true");
                    }
                    return this.mValue;
                }
            }
        }

        public static class Int
        extends ValueBase {
            @GuardedBy(value={"mValueLock"})
            private int mValue = 0;

            private Int(CancellationGroup factory) {
                super(factory);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void onComplete(int value) {
                Object object = this.mValueLock;
                synchronized (object) {
                    if (this.mHasValue) {
                        throw new UnsupportedOperationException("onComplete() cannot be called multiple times");
                    }
                    this.mValue = value;
                    this.mHasValue = true;
                }
                this.onComplete();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getValue() {
                Object object = this.mValueLock;
                synchronized (object) {
                    if (!this.mHasValue) {
                        throw new UnsupportedOperationException("getValue() is allowed only if hasValue() returns true");
                    }
                    return this.mValue;
                }
            }
        }

        protected static class ValueBase {
            private final CountDownLatch mLatch = new CountDownLatch(1);
            private final CancellationGroup mParentGroup;
            protected final Object mValueLock = new Object();
            @GuardedBy(value={"mValueLock"})
            protected boolean mHasValue = false;

            protected ValueBase(CancellationGroup parentGroup) {
                this.mParentGroup = parentGroup;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasValue() {
                Object object = this.mValueLock;
                synchronized (object) {
                    return this.mHasValue;
                }
            }

            protected void onComplete() {
                this.mLatch.countDown();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean await(int timeout, TimeUnit timeUnit) {
                if (!this.mParentGroup.registerLatch(this.mLatch)) {
                    return false;
                }
                try {
                    boolean bl = this.mLatch.await(timeout, timeUnit);
                    return bl;
                }
                catch (InterruptedException e) {
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.mParentGroup.unregisterLatch(this.mLatch);
                }
            }
        }
    }
}

