/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content.om;

import android.content.pm.PackagePartitions;
import android.os.FileUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.content.om.OverlayScanner;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class OverlayConfigParser {
    static final boolean DEFAULT_ENABLED_STATE = false;
    static final boolean DEFAULT_MUTABILITY = true;
    private static final int MAXIMUM_MERGE_DEPTH = 5;
    private static final String CONFIG_DIRECTORY = "config";
    private static final String CONFIG_DEFAULT_FILENAME = "config/config.xml";

    OverlayConfigParser() {
    }

    static ArrayList<ParsedConfiguration> getConfigurations(OverlayPartition partition, OverlayScanner scanner) {
        File configFile;
        if (partition.getOverlayFolder() == null) {
            return null;
        }
        if (scanner != null) {
            scanner.scanDir(partition.getOverlayFolder());
        }
        if (!(configFile = new File(partition.getOverlayFolder(), CONFIG_DEFAULT_FILENAME)).exists()) {
            return null;
        }
        ParsingContext parsingContext = new ParsingContext(partition);
        OverlayConfigParser.readConfigFile(configFile, scanner, parsingContext);
        return parsingContext.mOrderedConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfigFile(File configFile, OverlayScanner scanner, ParsingContext parsingContext) {
        FileReader configReader;
        try {
            configReader = new FileReader(configFile);
        }
        catch (FileNotFoundException e) {
            Log.w("OverlayConfig", "Couldn't find or open overlay configuration file " + configFile);
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)configReader);
            XmlUtils.beginDocument(parser, CONFIG_DIRECTORY);
            int depth = parser.getDepth();
            block15: while (XmlUtils.nextElementWithin(parser, depth)) {
                String name;
                switch (name = parser.getName()) {
                    case "merge": {
                        OverlayConfigParser.parseMerge(configFile, parser, scanner, parsingContext);
                        continue block15;
                    }
                    case "overlay": {
                        OverlayConfigParser.parseOverlay(configFile, parser, scanner, parsingContext);
                        continue block15;
                    }
                }
                Log.w("OverlayConfig", String.format("Tag %s is unknown in %s at %s", name, configFile, parser.getPositionDescription()));
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.w("OverlayConfig", "Got exception parsing overlay configuration.", e);
        }
        finally {
            IoUtils.closeQuietly(configReader);
        }
    }

    private static void parseMerge(File configFile, XmlPullParser parser, OverlayScanner scanner, ParsingContext parsingContext) {
        File includedConfigFile;
        File configDirectory;
        String path = parser.getAttributeValue(null, "path");
        if (path == null) {
            throw new IllegalStateException(String.format("<merge> without path in %s at %s" + configFile, parser.getPositionDescription()));
        }
        if (path.startsWith("/")) {
            throw new IllegalStateException(String.format("Path %s must be relative to the directory containing overlay configurations  files in %s at %s ", path, configFile, parser.getPositionDescription()));
        }
        if (parsingContext.mMergeDepth++ == 5) {
            throw new IllegalStateException(String.format("Maximum <merge> depth exceeded in %s at %s", configFile, parser.getPositionDescription()));
        }
        try {
            configDirectory = new File(parsingContext.mPartition.getOverlayFolder(), CONFIG_DIRECTORY).getCanonicalFile();
            includedConfigFile = new File(configDirectory, path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Couldn't find or open merged configuration file %s in %s at %s", path, configFile, parser.getPositionDescription()), e);
        }
        if (!includedConfigFile.exists()) {
            throw new IllegalStateException(String.format("Merged configuration file %s does not exist in %s at %s", path, configFile, parser.getPositionDescription()));
        }
        if (!FileUtils.contains(configDirectory, includedConfigFile)) {
            throw new IllegalStateException(String.format("Merged file %s outside of configuration directory in %s at %s", includedConfigFile.getAbsolutePath(), includedConfigFile, parser.getPositionDescription()));
        }
        OverlayConfigParser.readConfigFile(includedConfigFile, scanner, parsingContext);
        parsingContext.mMergeDepth--;
    }

    private static void parseOverlay(File configFile, XmlPullParser parser, OverlayScanner scanner, ParsingContext parsingContext) {
        String packageName = parser.getAttributeValue(null, "package");
        if (packageName == null) {
            throw new IllegalStateException(String.format("\"<overlay> without package in %s at %s", configFile, parser.getPositionDescription()));
        }
        OverlayScanner.ParsedOverlayInfo info = null;
        if (!(scanner == null || (info = scanner.getParsedInfo(packageName)) != null && parsingContext.mPartition.containsOverlay(info.path))) {
            throw new IllegalStateException(String.format("overlay %s not present in partition %s in %s at %s", packageName, parsingContext.mPartition.getOverlayFolder(), configFile, parser.getPositionDescription()));
        }
        if (parsingContext.mConfiguredOverlays.contains(packageName)) {
            throw new IllegalStateException(String.format("overlay %s configured multiple times in a single partition in %s at %s", packageName, configFile, parser.getPositionDescription()));
        }
        boolean isEnabled = false;
        String enabled = parser.getAttributeValue(null, "enabled");
        if (enabled != null) {
            isEnabled = !"false".equals(enabled);
        }
        boolean isMutable = true;
        String mutable = parser.getAttributeValue(null, "mutable");
        if (mutable != null) {
            boolean bl = isMutable = !"false".equals(mutable);
            if (!isMutable && parsingContext.mFoundMutableOverlay) {
                throw new IllegalStateException(String.format("immutable overlays must precede mutable overlays: found in %s at %s", configFile, parser.getPositionDescription()));
            }
        }
        if (isMutable) {
            parsingContext.mFoundMutableOverlay = true;
        } else if (!isEnabled) {
            Log.w("OverlayConfig", "found default-disabled immutable overlay " + packageName);
        }
        ParsedConfiguration Config2 = new ParsedConfiguration(packageName, isEnabled, isMutable, ((ParsingContext)parsingContext).mPartition.policy, info);
        parsingContext.mConfiguredOverlays.add(packageName);
        parsingContext.mOrderedConfigurations.add(Config2);
    }

    private static class ParsingContext {
        private final OverlayPartition mPartition;
        private final ArrayList<ParsedConfiguration> mOrderedConfigurations = new ArrayList();
        private final ArraySet<String> mConfiguredOverlays = new ArraySet();
        private boolean mFoundMutableOverlay;
        private int mMergeDepth;

        private ParsingContext(OverlayPartition partition) {
            this.mPartition = partition;
        }
    }

    static class OverlayPartition
    extends PackagePartitions.SystemPartition {
        static final String POLICY_ODM = "odm";
        static final String POLICY_OEM = "oem";
        static final String POLICY_PRODUCT = "product";
        static final String POLICY_PUBLIC = "public";
        static final String POLICY_SYSTEM = "system";
        static final String POLICY_VENDOR = "vendor";
        public final String policy;

        OverlayPartition(PackagePartitions.SystemPartition partition) {
            super(partition);
            this.policy = OverlayPartition.policyForPartition(partition);
        }

        OverlayPartition(File folder, PackagePartitions.SystemPartition original) {
            super(folder, original);
            this.policy = OverlayPartition.policyForPartition(original);
        }

        private static String policyForPartition(PackagePartitions.SystemPartition partition) {
            switch (partition.type) {
                case 0: 
                case 5: {
                    return POLICY_SYSTEM;
                }
                case 1: {
                    return POLICY_VENDOR;
                }
                case 2: {
                    return POLICY_ODM;
                }
                case 3: {
                    return POLICY_OEM;
                }
                case 4: {
                    return POLICY_PRODUCT;
                }
            }
            throw new IllegalStateException("Unable to determine policy for " + partition.getFolder());
        }
    }

    public static class ParsedConfiguration {
        public final String packageName;
        public final boolean enabled;
        public final boolean mutable;
        public final String policy;
        public final OverlayScanner.ParsedOverlayInfo parsedInfo;

        ParsedConfiguration(String packageName, boolean enabled, boolean mutable, String policy, OverlayScanner.ParsedOverlayInfo parsedInfo) {
            this.packageName = packageName;
            this.enabled = enabled;
            this.mutable = mutable;
            this.policy = policy;
            this.parsedInfo = parsedInfo;
        }

        public String toString() {
            return this.getClass().getSimpleName() + String.format("{packageName=%s, enabled=%s, mutable=%s, policy=%s, parsedInfo=%s}", this.packageName, this.enabled, this.mutable, this.policy, this.parsedInfo);
        }
    }
}

