/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.SurfaceControl;
import android.window.TaskEmbedder;
import android.window.TaskOrganizer;
import android.window.WindowContainerToken;
import android.window.WindowContainerTransaction;
import android.window.WindowOrganizer;

public class TaskOrganizerTaskEmbedder
extends TaskEmbedder {
    private static final String TAG = "TaskOrgTaskEmbedder";
    private static final boolean DEBUG = false;
    private TaskOrganizer mTaskOrganizer;
    private ActivityManager.RunningTaskInfo mTaskInfo;
    private WindowContainerToken mTaskToken;
    private SurfaceControl mTaskLeash;
    private boolean mPendingNotifyBoundsChanged;

    public TaskOrganizerTaskEmbedder(Context context, TaskEmbedder.Host host) {
        super(context, host);
    }

    @Override
    public boolean isInitialized() {
        return this.mTaskOrganizer != null;
    }

    @Override
    public boolean onInitialize() {
        this.mTaskOrganizer = new TaskOrganizerImpl();
        this.mTaskOrganizer.registerOrganizer(6);
        this.mTaskOrganizer.setInterceptBackPressedOnTaskRoot(true);
        return super.onInitialize();
    }

    @Override
    protected boolean onRelease() {
        if (!this.isInitialized()) {
            return false;
        }
        this.mTaskOrganizer.unregisterOrganizer();
        this.resetTaskInfo();
        return true;
    }

    @Override
    public void start() {
        super.start();
        if (!this.isInitialized()) {
            return;
        }
        if (this.mTaskToken == null) {
            return;
        }
        WindowContainerTransaction wct = new WindowContainerTransaction();
        wct.setHidden(this.mTaskToken, false);
        WindowOrganizer.applyTransaction(wct);
        if (this.mListener != null) {
            this.mListener.onTaskVisibilityChanged(this.getTaskId(), true);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.isInitialized()) {
            return;
        }
        if (this.mTaskToken == null) {
            return;
        }
        WindowContainerTransaction wct = new WindowContainerTransaction();
        wct.setHidden(this.mTaskToken, true);
        WindowOrganizer.applyTransaction(wct);
        if (this.mListener != null) {
            this.mListener.onTaskVisibilityChanged(this.getTaskId(), false);
        }
    }

    @Override
    public void notifyBoundsChanged() {
        super.notifyBoundsChanged();
        if (this.mTaskToken == null) {
            this.mPendingNotifyBoundsChanged = true;
            return;
        }
        this.mPendingNotifyBoundsChanged = false;
        Rect screenBounds = this.mHost.getScreenBounds();
        if (screenBounds.left < 0 || screenBounds.top < 0) {
            screenBounds.offsetTo(0, 0);
        }
        WindowContainerTransaction wct = new WindowContainerTransaction();
        wct.setBounds(this.mTaskToken, screenBounds);
        WindowOrganizer.applyTransaction(wct);
    }

    @Override
    public void performBackPress() {
    }

    @Override
    public int getId() {
        return this.getTaskId();
    }

    @Override
    protected ActivityOptions prepareActivityOptions(ActivityOptions options) {
        options = super.prepareActivityOptions(options);
        options.setLaunchWindowingMode(6);
        return options;
    }

    private int getTaskId() {
        return this.mTaskInfo != null ? this.mTaskInfo.taskId : -1;
    }

    private void resetTaskInfo() {
        this.mTaskInfo = null;
        this.mTaskToken = null;
        this.mTaskLeash = null;
    }

    private void log(String msg) {
        Log.d(TAG, "[" + System.identityHashCode(this) + "] " + msg);
    }

    private class TaskOrganizerImpl
    extends TaskOrganizer {
        private TaskOrganizerImpl() {
        }

        @Override
        public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) {
            TaskOrganizerTaskEmbedder.this.mTaskInfo = taskInfo;
            TaskOrganizerTaskEmbedder.this.mTaskToken = taskInfo.token;
            TaskOrganizerTaskEmbedder.this.mTaskLeash = leash;
            TaskOrganizerTaskEmbedder.this.mTransaction.reparent(TaskOrganizerTaskEmbedder.this.mTaskLeash, TaskOrganizerTaskEmbedder.this.mSurfaceControl).show(TaskOrganizerTaskEmbedder.this.mTaskLeash).show(TaskOrganizerTaskEmbedder.this.mSurfaceControl).apply();
            if (TaskOrganizerTaskEmbedder.this.mPendingNotifyBoundsChanged) {
                TaskOrganizerTaskEmbedder.this.notifyBoundsChanged();
            }
            TaskOrganizerTaskEmbedder.this.mHost.post(() -> TaskOrganizerTaskEmbedder.this.mHost.onTaskBackgroundColorChanged(TaskOrganizerTaskEmbedder.this, taskInfo.taskDescription.getBackgroundColor()));
            if (TaskOrganizerTaskEmbedder.this.mListener != null) {
                TaskOrganizerTaskEmbedder.this.mListener.onTaskCreated(taskInfo.taskId, taskInfo.baseActivity);
            }
        }

        @Override
        public void onTaskInfoChanged(ActivityManager.RunningTaskInfo taskInfo) {
            ((TaskOrganizerTaskEmbedder)TaskOrganizerTaskEmbedder.this).mTaskInfo.taskDescription = taskInfo.taskDescription;
            TaskOrganizerTaskEmbedder.this.mHost.post(() -> TaskOrganizerTaskEmbedder.this.mHost.onTaskBackgroundColorChanged(TaskOrganizerTaskEmbedder.this, taskInfo.taskDescription.getBackgroundColor()));
        }

        @Override
        public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) {
            if (TaskOrganizerTaskEmbedder.this.mTaskToken != null && (taskInfo == null || TaskOrganizerTaskEmbedder.this.mTaskToken.asBinder().equals(taskInfo.token.asBinder()))) {
                if (TaskOrganizerTaskEmbedder.this.mListener != null) {
                    TaskOrganizerTaskEmbedder.this.mListener.onTaskRemovalStarted(taskInfo.taskId);
                }
                TaskOrganizerTaskEmbedder.this.resetTaskInfo();
            }
        }

        @Override
        public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) {
            if (TaskOrganizerTaskEmbedder.this.mListener != null) {
                TaskOrganizerTaskEmbedder.this.mListener.onBackPressedOnTaskRoot(taskInfo.taskId);
            }
        }
    }
}

