/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.DisplayAreaInfo;

public interface IDisplayAreaOrganizer
extends IInterface {
    public void onDisplayAreaAppeared(DisplayAreaInfo var1, SurfaceControl var2) throws RemoteException;

    public void onDisplayAreaVanished(DisplayAreaInfo var1) throws RemoteException;

    public void onDisplayAreaInfoChanged(DisplayAreaInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayAreaOrganizer {
        private static final String DESCRIPTOR = "android.window.IDisplayAreaOrganizer";
        static final int TRANSACTION_onDisplayAreaAppeared = 1;
        static final int TRANSACTION_onDisplayAreaVanished = 2;
        static final int TRANSACTION_onDisplayAreaInfoChanged = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDisplayAreaOrganizer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayAreaOrganizer) {
                return (IDisplayAreaOrganizer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDisplayAreaAppeared";
                }
                case 2: {
                    return "onDisplayAreaVanished";
                }
                case 3: {
                    return "onDisplayAreaInfoChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    DisplayAreaInfo _arg0 = 0 != data.readInt() ? DisplayAreaInfo.CREATOR.createFromParcel(data) : null;
                    SurfaceControl _arg1 = 0 != data.readInt() ? SurfaceControl.CREATOR.createFromParcel(data) : null;
                    this.onDisplayAreaAppeared(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    DisplayAreaInfo _arg0 = 0 != data.readInt() ? DisplayAreaInfo.CREATOR.createFromParcel(data) : null;
                    this.onDisplayAreaVanished(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    DisplayAreaInfo _arg0 = 0 != data.readInt() ? DisplayAreaInfo.CREATOR.createFromParcel(data) : null;
                    this.onDisplayAreaInfoChanged(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDisplayAreaOrganizer impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDisplayAreaOrganizer getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDisplayAreaOrganizer {
            private IBinder mRemote;
            public static IDisplayAreaOrganizer sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAreaAppeared(DisplayAreaInfo displayAreaInfo, SurfaceControl leash) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (displayAreaInfo != null) {
                        _data.writeInt(1);
                        displayAreaInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (leash != null) {
                        _data.writeInt(1);
                        leash.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisplayAreaAppeared(displayAreaInfo, leash);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAreaVanished(DisplayAreaInfo displayAreaInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (displayAreaInfo != null) {
                        _data.writeInt(1);
                        displayAreaInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisplayAreaVanished(displayAreaInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAreaInfoChanged(DisplayAreaInfo displayAreaInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (displayAreaInfo != null) {
                        _data.writeInt(1);
                        displayAreaInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisplayAreaInfoChanged(displayAreaInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayAreaOrganizer {
        @Override
        public void onDisplayAreaAppeared(DisplayAreaInfo displayAreaInfo, SurfaceControl leash) throws RemoteException {
        }

        @Override
        public void onDisplayAreaVanished(DisplayAreaInfo displayAreaInfo) throws RemoteException {
        }

        @Override
        public void onDisplayAreaInfoChanged(DisplayAreaInfo displayAreaInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

