/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RcsContactUceCapability
implements Parcelable {
    public static final int CAPABILITY_CHAT_STANDALONE = 1;
    public static final int CAPABILITY_CHAT_SESSION = 2;
    public static final int CAPABILITY_CHAT_SESSION_STORE_FORWARD = 4;
    public static final int CAPABILITY_FILE_TRANSFER = 8;
    public static final int CAPABILITY_FILE_TRANSFER_THUMBNAIL = 16;
    public static final int CAPABILITY_FILE_TRANSFER_STORE_FORWARD = 32;
    public static final int CAPABILITY_FILE_TRANSFER_HTTP = 64;
    public static final int CAPABILITY_FILE_TRANSFER_SMS = 128;
    public static final int CAPABILITY_IMAGE_SHARE = 256;
    public static final int CAPABILITY_VIDEO_SHARE_DURING_CS_CALL = 512;
    public static final int CAPABILITY_VIDEO_SHARE = 1024;
    public static final int CAPABILITY_SOCIAL_PRESENCE = 2048;
    public static final int CAPABILITY_DISCOVERY_VIA_PRESENCE = 4096;
    public static final int CAPABILITY_IP_VOICE_CALL = 8192;
    public static final int CAPABILITY_IP_VIDEO_CALL = 16384;
    public static final int CAPABILITY_GEOLOCATION_PUSH = 32768;
    public static final int CAPABILITY_GEOLOCATION_PUSH_SMS = 65536;
    public static final int CAPABILITY_GEOLOCATION_PULL = 131072;
    public static final int CAPABILITY_GEOLOCATION_PULL_FILE_TRANSFER = 262144;
    public static final int CAPABILITY_RCS_VOICE_CALL = 524288;
    public static final int CAPABILITY_RCS_VIDEO_CALL = 0x100000;
    public static final int CAPABILITY_RCS_VIDEO_ONLY_CALL = 0x200000;
    public static final int CAPABILITY_CALL_COMPOSER = 0x400000;
    public static final int CAPABILITY_POST_CALL = 0x800000;
    public static final int CAPABILITY_SHARED_MAP = 0x1000000;
    public static final int CAPABILITY_SHARED_SKETCH = 0x2000000;
    public static final int CAPABILITY_CHAT_BOT = 0x4000000;
    public static final int CAPABILITY_CHAT_BOT_ROLE = 0x8000000;
    public static final int CAPABILITY_PLUG_IN = 0x10000000;
    public static final int CAPABILITY_STANDALONE_CHAT_BOT = 0x20000000;
    public static final int CAPABILITY_MMTEL_CALL_COMPOSER = 0x40000000;
    private final Uri mContactUri;
    private long mCapabilities;
    private List<String> mExtensionTags = new ArrayList<String>();
    private Map<Long, Uri> mServiceMap = new HashMap<Long, Uri>();
    public static final Parcelable.Creator<RcsContactUceCapability> CREATOR = new Parcelable.Creator<RcsContactUceCapability>(){

        @Override
        public RcsContactUceCapability createFromParcel(Parcel in) {
            return new RcsContactUceCapability(in);
        }

        public RcsContactUceCapability[] newArray(int size) {
            return new RcsContactUceCapability[size];
        }
    };

    RcsContactUceCapability(Uri contact) {
        this.mContactUri = contact;
    }

    private RcsContactUceCapability(Parcel in) {
        this.mContactUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.mCapabilities = in.readLong();
        in.readStringList(this.mExtensionTags);
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            this.mServiceMap.put(in.readLong(), (Uri)in.readParcelable(Uri.class.getClassLoader()));
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mContactUri, 0);
        out.writeLong(this.mCapabilities);
        out.writeStringList(this.mExtensionTags);
        int mapSize = this.mServiceMap.keySet().size();
        out.writeInt(mapSize);
        for (long key : this.mServiceMap.keySet()) {
            out.writeLong(key);
            out.writeParcelable(this.mServiceMap.get(key), 0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean isCapable(long type) {
        return (this.mCapabilities & type) > 0L;
    }

    public boolean isCapable(String extensionTag) {
        return this.mExtensionTags.contains(extensionTag);
    }

    public List<String> getCapableExtensionTags() {
        return Collections.unmodifiableList(this.mExtensionTags);
    }

    public Uri getServiceUri(long type) {
        Uri result = this.mServiceMap.getOrDefault(type, null);
        if (result == null) {
            return this.isCapable(type) ? this.getContactUri() : null;
        }
        return result;
    }

    public Uri getContactUri() {
        return this.mContactUri;
    }

    public static class Builder {
        private final RcsContactUceCapability mCapabilities;

        public Builder(Uri contact) {
            this.mCapabilities = new RcsContactUceCapability(contact);
        }

        public Builder add(long type, Uri serviceUri) {
            this.mCapabilities.mCapabilities |= type;
            for (long shift = 0L; shift < 32L; ++shift) {
                long cap = type & (long)(1 << (int)shift);
                if (cap != 0L) {
                    this.mCapabilities.mServiceMap.put(cap, serviceUri);
                    type &= cap ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (type == 0L) break;
            }
            return this;
        }

        public Builder add(long type) {
            this.mCapabilities.mCapabilities |= type;
            return this;
        }

        public Builder add(String extension) {
            this.mCapabilities.mExtensionTags.add(extension);
            return this;
        }

        public RcsContactUceCapability build() {
            return this.mCapabilities;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CapabilityFlag {
    }
}

