/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.RegistrationManager;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.feature.MmTelFeature;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IIntegerConsumer;
import com.android.internal.telephony.ITelephony;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ImsMmTelManager
implements RegistrationManager {
    public static final int WIFI_MODE_WIFI_ONLY = 0;
    public static final int WIFI_MODE_CELLULAR_PREFERRED = 1;
    public static final int WIFI_MODE_WIFI_PREFERRED = 2;
    private final int mSubId;

    @SystemApi
    @Deprecated
    @SuppressLint(value={"ManagerLookup"})
    public static ImsMmTelManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        return new ImsMmTelManager(subId);
    }

    @VisibleForTesting
    public ImsMmTelManager(int subId) {
        this.mSubId = subId;
    }

    @Deprecated
    @SystemApi
    public void registerImsRegistrationCallback(Executor executor, RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        c.setExecutor(executor);
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Override
    public void registerImsRegistrationCallback(Executor executor, RegistrationManager.RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        c.setExecutor(executor);
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Deprecated
    @SystemApi
    public void unregisterImsRegistrationCallback(RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void unregisterImsRegistrationCallback(RegistrationManager.RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    @SystemApi
    public void getRegistrationState(final Executor executor, final Consumer<Integer> stateCallback) {
        if (stateCallback == null) {
            throw new IllegalArgumentException("Must include a non-null callback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.getImsMmTelRegistrationState(this.mSubId, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> stateCallback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void getRegistrationTransportType(final Executor executor, final Consumer<Integer> transportTypeCallback) {
        if (transportTypeCallback == null) {
            throw new IllegalArgumentException("Must include a non-null callback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.getImsMmTelRegistrationTransportType(this.mSubId, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> transportTypeCallback.accept(result));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void registerMmTelCapabilityCallback(Executor executor, CapabilityCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        c.setExecutor(executor);
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.registerMmTelCapabilityCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        catch (IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterMmTelCapabilityCallback(CapabilityCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.unregisterMmTelCapabilityCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isAdvancedCallingSettingEnabled() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isAdvancedCallingSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setAdvancedCallingSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setAdvancedCallingSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public boolean isCapable(int capability, int imsRegTech) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isCapable(this.mSubId, capability, imsRegTech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public boolean isAvailable(int capability, int imsRegTech) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isAvailable(this.mSubId, capability, imsRegTech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void isSupported(int capability, int transportType, final Executor executor, final Consumer<Boolean> callback) throws ImsException {
        if (callback == null) {
            throw new IllegalArgumentException("Must include a non-null Consumer.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            ImsMmTelManager.getITelephony().isMmTelCapabilitySupported(this.mSubId, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> callback.accept(result == 1));
                }
            }, capability, transportType);
        }
        catch (ServiceSpecificException sse) {
            throw new ImsException(sse.getMessage(), sse.errorCode);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public boolean isVtSettingEnabled() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isVtSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setVtSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVtSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isVoWiFiSettingEnabled() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isVoWiFiSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setVoWiFiSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isVoWiFiRoamingSettingEnabled() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isVoWiFiRoamingSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setVoWiFiRoamingSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiRoamingSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setVoWiFiNonPersistent(boolean isCapable, int mode) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiNonPersistent(this.mSubId, isCapable, mode);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int getVoWiFiModeSetting() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.getVoWiFiModeSetting(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setVoWiFiModeSetting(int mode) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiModeSetting(this.mSubId, mode);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public int getVoWiFiRoamingModeSetting() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.getVoWiFiRoamingModeSetting(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setVoWiFiRoamingModeSetting(int mode) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiRoamingModeSetting(this.mSubId, mode);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void setRttCapabilitySetting(boolean isEnabled) {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setRttCapabilitySetting(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isTtyOverVolteEnabled() {
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isTtyOverVolteEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void getFeatureState(final Executor executor, final Consumer<Integer> callback) throws ImsException {
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must include a non-null Consumer.");
        }
        ITelephony iTelephony = ImsMmTelManager.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.getImsMmTelFeatureState(this.mSubId, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> callback.accept(result));
                }
            });
        }
        catch (ServiceSpecificException sse) {
            throw new ImsException(sse.getMessage(), sse.errorCode);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        return binder;
    }

    public static class CapabilityCallback {
        private final CapabilityBinder mBinder = new CapabilityBinder(this);

        public void onCapabilitiesStatusChanged(MmTelFeature.MmTelCapabilities capabilities) {
        }

        public IImsCapabilityCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CapabilityBinder
        extends IImsCapabilityCallback.Stub {
            private final CapabilityCallback mLocalCallback;
            private Executor mExecutor;

            CapabilityBinder(CapabilityCallback c) {
                this.mLocalCallback = c;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesStatusChanged(int config) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onCapabilitiesStatusChanged(new MmTelFeature.MmTelCapabilities(config)));
                }
                finally {
                    CapabilityBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            @Override
            public void onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
            }

            @Override
            public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    @Deprecated
    @SystemApi
    public static class RegistrationCallback
    extends RegistrationManager.RegistrationCallback {
        @Override
        public void onRegistered(int imsTransportType) {
        }

        @Override
        public void onRegistering(int imsTransportType) {
        }

        @Override
        public void onUnregistered(ImsReasonInfo info) {
        }

        @Override
        public void onTechnologyChangeFailed(int imsTransportType, ImsReasonInfo info) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WiFiCallingMode {
    }
}

