/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.compat.Compatibility;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.BarringInfo;
import android.telephony.CallQuality;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.PhoneCapability;
import android.telephony.PhoneStateListener;
import android.telephony.PreciseDataConnectionState;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.util.Log;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ITelephonyRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class TelephonyRegistryManager {
    private static final String TAG = "TelephonyRegistryManager";
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;
    private final Map<SubscriptionManager.OnSubscriptionsChangedListener, IOnSubscriptionsChangedListener> mSubscriptionChangedListenerMap = new HashMap<SubscriptionManager.OnSubscriptionsChangedListener, IOnSubscriptionsChangedListener>();
    private final Map<SubscriptionManager.OnOpportunisticSubscriptionsChangedListener, IOnSubscriptionsChangedListener> mOpportunisticSubscriptionChangedListenerMap = new HashMap<SubscriptionManager.OnOpportunisticSubscriptionsChangedListener, IOnSubscriptionsChangedListener>();
    private static final long LISTEN_CODE_CHANGE = 147600208L;
    public static final int SIM_ACTIVATION_TYPE_VOICE = 0;
    public static final int SIM_ACTIVATION_TYPE_DATA = 1;

    public TelephonyRegistryManager(Context context) {
        this.mContext = context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    public void addOnSubscriptionsChangedListener(final SubscriptionManager.OnSubscriptionsChangedListener listener, final Executor executor) {
        IOnSubscriptionsChangedListener.Stub callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                Log.d(TelephonyRegistryManager.TAG, "onSubscriptionsChangedListener callback received.");
                executor.execute(() -> listener.onSubscriptionsChanged());
            }
        };
        this.mSubscriptionChangedListenerMap.put(listener, callback);
        try {
            sRegistry.addOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), callback);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        if (this.mSubscriptionChangedListenerMap.get(listener) == null) {
            return;
        }
        try {
            sRegistry.removeOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mSubscriptionChangedListenerMap.get(listener));
            this.mSubscriptionChangedListenerMap.remove(listener);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void addOnOpportunisticSubscriptionsChangedListener(final SubscriptionManager.OnOpportunisticSubscriptionsChangedListener listener, final Executor executor) {
        IOnSubscriptionsChangedListener.Stub callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                long identity = Binder.clearCallingIdentity();
                try {
                    Log.d(TelephonyRegistryManager.TAG, "onOpportunisticSubscriptionsChanged callback received.");
                    executor.execute(() -> listener.onOpportunisticSubscriptionsChanged());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        this.mOpportunisticSubscriptionChangedListenerMap.put(listener, callback);
        try {
            sRegistry.addOnOpportunisticSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), callback);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeOnOpportunisticSubscriptionsChangedListener(SubscriptionManager.OnOpportunisticSubscriptionsChangedListener listener) {
        try {
            sRegistry.removeOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mOpportunisticSubscriptionChangedListenerMap.get(listener));
            this.mOpportunisticSubscriptionChangedListenerMap.remove(listener);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void listenForSubscriber(int subId, String pkg, String featureId, PhoneStateListener listener, int events, boolean notifyNow) {
        try {
            if (Compatibility.isChangeEnabled(147600208L)) {
                listener.mSubId = events == 0 ? -1 : subId;
            } else if (listener.mSubId != null) {
                subId = listener.mSubId;
            }
            sRegistry.listenForSubscriber(subId, pkg, featureId, listener.callback, events, notifyNow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierNetworkChange(boolean active) {
        try {
            sRegistry.notifyCarrierNetworkChange(active);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCallStateChanged(int subId, int slotIndex, int state, String incomingNumber) {
        try {
            sRegistry.notifyCallState(slotIndex, subId, state, incomingNumber);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCallStateChangedForAllSubscriptions(int state, String incomingNumber) {
        try {
            sRegistry.notifyCallStateForAllSubs(state, incomingNumber);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifySubscriptionInfoChanged() {
        try {
            sRegistry.notifySubscriptionInfoChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyOpportunisticSubscriptionInfoChanged() {
        try {
            sRegistry.notifyOpportunisticSubscriptionInfoChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyServiceStateChanged(int subId, int slotIndex, ServiceState state) {
        try {
            sRegistry.notifyServiceStateForPhoneId(slotIndex, subId, state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifySignalStrengthChanged(int subId, int slotIndex, SignalStrength signalStrength) {
        try {
            sRegistry.notifySignalStrengthForPhoneId(slotIndex, subId, signalStrength);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyMessageWaitingChanged(int subId, int slotIndex, boolean msgWaitingInd) {
        try {
            sRegistry.notifyMessageWaitingChangedForPhoneId(slotIndex, subId, msgWaitingInd);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCallForwardingChanged(int subId, boolean callForwardInd) {
        try {
            sRegistry.notifyCallForwardingChangedForSubscriber(subId, callForwardInd);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDataActivityChanged(int subId, int dataActivityType) {
        try {
            sRegistry.notifyDataActivityForSubscriber(subId, dataActivityType);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDataConnectionForSubscriber(int slotIndex, int subId, int apnType, PreciseDataConnectionState preciseState) {
        try {
            sRegistry.notifyDataConnectionForSubscriber(slotIndex, subId, apnType, preciseState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCallQualityChanged(int subId, int slotIndex, CallQuality callQuality, int networkType) {
        try {
            sRegistry.notifyCallQualityChanged(callQuality, slotIndex, subId, networkType);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyEmergencyNumberList(int subId, int slotIndex) {
        try {
            sRegistry.notifyEmergencyNumberList(slotIndex, subId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyOutgoingEmergencyCall(int phoneId, int subId, EmergencyNumber emergencyNumber) {
        try {
            sRegistry.notifyOutgoingEmergencyCall(phoneId, subId, emergencyNumber);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyOutgoingEmergencySms(int phoneId, int subId, EmergencyNumber emergencyNumber) {
        try {
            sRegistry.notifyOutgoingEmergencySms(phoneId, subId, emergencyNumber);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyRadioPowerStateChanged(int subId, int slotIndex, int radioPowerState) {
        try {
            sRegistry.notifyRadioPowerStateChanged(slotIndex, subId, radioPowerState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyPhoneCapabilityChanged(PhoneCapability phoneCapability) {
        try {
            sRegistry.notifyPhoneCapabilityChanged(phoneCapability);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDataActivationStateChanged(int subId, int slotIndex, int activationState) {
        try {
            sRegistry.notifySimActivationStateChangedForPhoneId(slotIndex, subId, 1, activationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyVoiceActivationStateChanged(int subId, int slotIndex, int activationState) {
        try {
            sRegistry.notifySimActivationStateChangedForPhoneId(slotIndex, subId, 0, activationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyUserMobileDataStateChanged(int slotIndex, int subId, boolean state) {
        try {
            sRegistry.notifyUserMobileDataStateChangedForPhoneId(slotIndex, subId, state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDisplayInfoChanged(int slotIndex, int subscriptionId, TelephonyDisplayInfo telephonyDisplayInfo) {
        try {
            sRegistry.notifyDisplayInfoChanged(slotIndex, subscriptionId, telephonyDisplayInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyImsDisconnectCause(int subId, ImsReasonInfo imsReasonInfo) {
        try {
            sRegistry.notifyImsDisconnectCause(subId, imsReasonInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyPreciseDataConnectionFailed(int subId, int slotIndex, int apnType, String apn, int failCause) {
        try {
            sRegistry.notifyPreciseDataConnectionFailed(slotIndex, subId, apnType, apn, failCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifySrvccStateChanged(int subId, int state) {
        try {
            sRegistry.notifySrvccStateChanged(subId, state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyPreciseCallState(int subId, int slotIndex, int ringCallPreciseState, int foregroundCallPreciseState, int backgroundCallPreciseState) {
        try {
            sRegistry.notifyPreciseCallState(slotIndex, subId, ringCallPreciseState, foregroundCallPreciseState, backgroundCallPreciseState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDisconnectCause(int slotIndex, int subId, int cause, int preciseCause) {
        try {
            sRegistry.notifyDisconnectCause(slotIndex, subId, cause, preciseCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCellLocation(int subId, CellIdentity cellLocation) {
        try {
            sRegistry.notifyCellLocationForSubscriber(subId, cellLocation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCellInfoChanged(int subId, List<CellInfo> cellInfo) {
        try {
            sRegistry.notifyCellInfoForSubscriber(subId, cellInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyActiveDataSubIdChanged(int activeDataSubId) {
        try {
            sRegistry.notifyActiveDataSubIdChanged(activeDataSubId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyRegistrationFailed(int slotIndex, int subId, CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) {
        try {
            sRegistry.notifyRegistrationFailed(slotIndex, subId, cellIdentity, chosenPlmn, domain, causeCode, additionalCauseCode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyBarringInfoChanged(int slotIndex, int subId, BarringInfo barringInfo) {
        try {
            sRegistry.notifyBarringInfoChanged(slotIndex, subId, barringInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

