/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.RemoteException;
import android.telephony.TelephonyFrameworkInitializer;
import com.android.internal.telephony.ITelephony;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class NetworkScan {
    private static final String TAG = "NetworkScan";
    public static final int SUCCESS = 0;
    public static final int ERROR_MODEM_ERROR = 1;
    public static final int ERROR_INVALID_SCAN = 2;
    public static final int ERROR_MODEM_UNAVAILABLE = 3;
    public static final int ERROR_UNSUPPORTED = 4;
    public static final int ERROR_RADIO_INTERFACE_ERROR = 10000;
    public static final int ERROR_INVALID_SCANID = 10001;
    public static final int ERROR_INTERRUPTED = 10002;
    private final int mScanId;
    private final int mSubId;

    public void stopScan() {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            Rlog.e(TAG, "Failed to get the ITelephony instance.");
        }
        try {
            telephony.stopNetworkScan(this.mSubId, this.mScanId);
        }
        catch (IllegalArgumentException ex) {
            Rlog.d(TAG, "stopNetworkScan - no active scan for ScanID=" + this.mScanId);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "stopNetworkScan  RemoteException", ex);
        }
        catch (RuntimeException ex) {
            Rlog.e(TAG, "stopNetworkScan  RuntimeException", ex);
        }
    }

    @Deprecated
    public void stop() throws RemoteException {
        try {
            this.stopScan();
        }
        catch (RuntimeException ex) {
            throw new RemoteException("Failed to stop the network scan with id " + this.mScanId);
        }
    }

    public NetworkScan(int scanId, int subId) {
        this.mScanId = scanId;
        this.mSubId = subId;
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanErrorCode {
    }
}

