/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.IApInterface;
import android.net.wifi.nl80211.IClientInterface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInterfaceEventCallback
extends IInterface {
    public void OnClientInterfaceReady(IClientInterface var1) throws RemoteException;

    public void OnApInterfaceReady(IApInterface var1) throws RemoteException;

    public void OnClientTorndownEvent(IClientInterface var1) throws RemoteException;

    public void OnApTorndownEvent(IApInterface var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInterfaceEventCallback {
        private static final String DESCRIPTOR = "android.net.wifi.nl80211.IInterfaceEventCallback";
        static final int TRANSACTION_OnClientInterfaceReady = 1;
        static final int TRANSACTION_OnApInterfaceReady = 2;
        static final int TRANSACTION_OnClientTorndownEvent = 3;
        static final int TRANSACTION_OnApTorndownEvent = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInterfaceEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInterfaceEventCallback) {
                return (IInterfaceEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "OnClientInterfaceReady";
                }
                case 2: {
                    return "OnApInterfaceReady";
                }
                case 3: {
                    return "OnClientTorndownEvent";
                }
                case 4: {
                    return "OnApTorndownEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IClientInterface _arg0 = IClientInterface.Stub.asInterface(data.readStrongBinder());
                    this.OnClientInterfaceReady(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IApInterface _arg0 = IApInterface.Stub.asInterface(data.readStrongBinder());
                    this.OnApInterfaceReady(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IClientInterface _arg0 = IClientInterface.Stub.asInterface(data.readStrongBinder());
                    this.OnClientTorndownEvent(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IApInterface _arg0 = IApInterface.Stub.asInterface(data.readStrongBinder());
                    this.OnApTorndownEvent(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInterfaceEventCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInterfaceEventCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInterfaceEventCallback {
            private IBinder mRemote;
            public static IInterfaceEventCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnClientInterfaceReady(IClientInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(network_interface != null ? network_interface.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().OnClientInterfaceReady(network_interface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnApInterfaceReady(IApInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(network_interface != null ? network_interface.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().OnApInterfaceReady(network_interface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnClientTorndownEvent(IClientInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(network_interface != null ? network_interface.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().OnClientTorndownEvent(network_interface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnApTorndownEvent(IApInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(network_interface != null ? network_interface.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().OnApTorndownEvent(network_interface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInterfaceEventCallback {
        @Override
        public void OnClientInterfaceReady(IClientInterface network_interface) throws RemoteException {
        }

        @Override
        public void OnApInterfaceReady(IApInterface network_interface) throws RemoteException {
        }

        @Override
        public void OnClientTorndownEvent(IClientInterface network_interface) throws RemoteException {
        }

        @Override
        public void OnApTorndownEvent(IApInterface network_interface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

