/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.wifi.AnqpInformationElement;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ScanResult
implements Parcelable {
    public String SSID;
    @UnsupportedAppUsage
    public WifiSsid wifiSsid;
    public String BSSID;
    @UnsupportedAppUsage
    public long hessid;
    @UnsupportedAppUsage
    public int anqpDomainId;
    public String capabilities;
    @SystemApi
    public static final int PROTOCOL_NONE = 0;
    @SystemApi
    public static final int PROTOCOL_WPA = 1;
    @SystemApi
    public static final int PROTOCOL_RSN = 2;
    @SystemApi
    public static final int PROTOCOL_OSEN = 3;
    @SystemApi
    public static final int PROTOCOL_WAPI = 4;
    @SystemApi
    public static final int KEY_MGMT_NONE = 0;
    @SystemApi
    public static final int KEY_MGMT_PSK = 1;
    @SystemApi
    public static final int KEY_MGMT_EAP = 2;
    @SystemApi
    public static final int KEY_MGMT_FT_PSK = 3;
    @SystemApi
    public static final int KEY_MGMT_FT_EAP = 4;
    @SystemApi
    public static final int KEY_MGMT_PSK_SHA256 = 5;
    @SystemApi
    public static final int KEY_MGMT_EAP_SHA256 = 6;
    @SystemApi
    public static final int KEY_MGMT_OSEN = 7;
    @SystemApi
    public static final int KEY_MGMT_SAE = 8;
    @SystemApi
    public static final int KEY_MGMT_OWE = 9;
    @SystemApi
    public static final int KEY_MGMT_EAP_SUITE_B_192 = 10;
    @SystemApi
    public static final int KEY_MGMT_FT_SAE = 11;
    @SystemApi
    public static final int KEY_MGMT_OWE_TRANSITION = 12;
    @SystemApi
    public static final int KEY_MGMT_WAPI_PSK = 13;
    @SystemApi
    public static final int KEY_MGMT_WAPI_CERT = 14;
    public static final int KEY_MGMT_FILS_SHA256 = 15;
    public static final int KEY_MGMT_FILS_SHA384 = 16;
    @SystemApi
    public static final int CIPHER_NONE = 0;
    @SystemApi
    public static final int CIPHER_NO_GROUP_ADDRESSED = 1;
    @SystemApi
    public static final int CIPHER_TKIP = 2;
    @SystemApi
    public static final int CIPHER_CCMP = 3;
    @SystemApi
    public static final int CIPHER_GCMP_256 = 4;
    @SystemApi
    public static final int CIPHER_SMS4 = 5;
    public int level;
    public int frequency;
    public static final int CHANNEL_WIDTH_20MHZ = 0;
    public static final int CHANNEL_WIDTH_40MHZ = 1;
    public static final int CHANNEL_WIDTH_80MHZ = 2;
    public static final int CHANNEL_WIDTH_160MHZ = 3;
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4;
    public static final int WIFI_STANDARD_UNKNOWN = 0;
    public static final int WIFI_STANDARD_LEGACY = 1;
    public static final int WIFI_STANDARD_11N = 4;
    public static final int WIFI_STANDARD_11AC = 5;
    public static final int WIFI_STANDARD_11AX = 6;
    private int mWifiStandard;
    public int channelWidth;
    public int centerFreq0;
    public int centerFreq1;
    @UnsupportedAppUsage
    public boolean is80211McRTTResponder;
    public long timestamp;
    @UnsupportedAppUsage
    public long seen;
    public RadioChainInfo[] radioChainInfos;
    @SystemApi
    public boolean untrusted;
    @UnsupportedAppUsage
    public int numUsage;
    @UnsupportedAppUsage
    public int distanceCm;
    @UnsupportedAppUsage
    public int distanceSdCm;
    public static final long FLAG_PASSPOINT_NETWORK = 1L;
    public static final long FLAG_80211mc_RESPONDER = 2L;
    @UnsupportedAppUsage
    public long flags;
    public CharSequence venueName;
    public CharSequence operatorFriendlyName;
    public static final int UNSPECIFIED = -1;
    public static final int BAND_24_GHZ_FIRST_CH_NUM = 1;
    public static final int BAND_24_GHZ_LAST_CH_NUM = 14;
    public static final int BAND_24_GHZ_START_FREQ_MHZ = 2412;
    public static final int BAND_24_GHZ_END_FREQ_MHZ = 2484;
    public static final int BAND_5_GHZ_FIRST_CH_NUM = 32;
    public static final int BAND_5_GHZ_LAST_CH_NUM = 173;
    public static final int BAND_5_GHZ_START_FREQ_MHZ = 5160;
    public static final int BAND_5_GHZ_END_FREQ_MHZ = 5865;
    public static final int BAND_6_GHZ_FIRST_CH_NUM = 1;
    public static final int BAND_6_GHZ_LAST_CH_NUM = 233;
    public static final int BAND_6_GHZ_START_FREQ_MHZ = 5945;
    public static final int BAND_6_GHZ_END_FREQ_MHZ = 7105;
    @UnsupportedAppUsage
    public List<String> anqpLines;
    @UnsupportedAppUsage
    public InformationElement[] informationElements;
    public AnqpInformationElement[] anqpElements;
    public static final Parcelable.Creator<ScanResult> CREATOR = new Parcelable.Creator<ScanResult>(){

        @Override
        public ScanResult createFromParcel(Parcel in) {
            int i;
            WifiSsid wifiSsid = null;
            if (in.readInt() == 1) {
                wifiSsid = WifiSsid.CREATOR.createFromParcel(in);
            }
            ScanResult sr = new ScanResult(wifiSsid, in.readString(), in.readString(), in.readLong(), in.readInt(), in.readString(), in.readInt(), in.readInt(), in.readLong(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), false);
            sr.mWifiStandard = in.readInt();
            sr.seen = in.readLong();
            sr.untrusted = in.readInt() != 0;
            sr.numUsage = in.readInt();
            sr.venueName = in.readString();
            sr.operatorFriendlyName = in.readString();
            sr.flags = in.readLong();
            int n = in.readInt();
            if (n != 0) {
                sr.informationElements = new InformationElement[n];
                for (i = 0; i < n; ++i) {
                    sr.informationElements[i] = new InformationElement();
                    sr.informationElements[i].id = in.readInt();
                    sr.informationElements[i].idExt = in.readInt();
                    int len = in.readInt();
                    sr.informationElements[i].bytes = new byte[len];
                    in.readByteArray(sr.informationElements[i].bytes);
                }
            }
            if ((n = in.readInt()) != 0) {
                sr.anqpLines = new ArrayList<String>();
                for (i = 0; i < n; ++i) {
                    sr.anqpLines.add(in.readString());
                }
            }
            if ((n = in.readInt()) != 0) {
                sr.anqpElements = new AnqpInformationElement[n];
                for (i = 0; i < n; ++i) {
                    int vendorId = in.readInt();
                    int elementId = in.readInt();
                    int len = in.readInt();
                    byte[] payload = new byte[len];
                    in.readByteArray(payload);
                    sr.anqpElements[i] = new AnqpInformationElement(vendorId, elementId, payload);
                }
            }
            if ((n = in.readInt()) != 0) {
                sr.radioChainInfos = new RadioChainInfo[n];
                for (i = 0; i < n; ++i) {
                    sr.radioChainInfos[i] = new RadioChainInfo();
                    sr.radioChainInfos[i].id = in.readInt();
                    sr.radioChainInfos[i].level = in.readInt();
                }
            }
            return sr;
        }

        public ScanResult[] newArray(int size) {
            return new ScanResult[size];
        }
    };

    public int getWifiStandard() {
        return this.mWifiStandard;
    }

    public void setWifiStandard(int standard) {
        this.mWifiStandard = standard;
    }

    private static String wifiStandardToString(int standard) {
        switch (standard) {
            case 1: {
                return "legacy";
            }
            case 4: {
                return "11n";
            }
            case 5: {
                return "11ac";
            }
            case 6: {
                return "11ax";
            }
            case 0: {
                return "unknown";
            }
        }
        return null;
    }

    public void setFlag(long flag) {
        this.flags |= flag;
    }

    public void clearFlag(long flag) {
        this.flags &= flag ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean is80211mcResponder() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isPasspointNetwork() {
        return (this.flags & 1L) != 0L;
    }

    public static boolean is24GHz(int freqMhz) {
        return freqMhz >= 2412 && freqMhz <= 2484;
    }

    public static boolean is5GHz(int freqMhz) {
        return freqMhz >= 5160 && freqMhz <= 5865;
    }

    public static boolean is6GHz(int freqMhz) {
        return freqMhz >= 5945 && freqMhz <= 7105;
    }

    public static int convertChannelToFrequencyMhz(int channel, int band) {
        if (band == 1) {
            if (channel == 14) {
                return 2484;
            }
            if (channel >= 1 && channel <= 14) {
                return (channel - 1) * 5 + 2412;
            }
            return -1;
        }
        if (band == 2) {
            if (channel >= 32 && channel <= 173) {
                return (channel - 32) * 5 + 5160;
            }
            return -1;
        }
        if (band == 8) {
            if (channel >= 1 && channel <= 233) {
                return (channel - 1) * 5 + 5945;
            }
            return -1;
        }
        return -1;
    }

    public static int convertFrequencyMhzToChannel(int freqMhz) {
        if (freqMhz == 2484) {
            return 14;
        }
        if (ScanResult.is24GHz(freqMhz)) {
            return (freqMhz - 2412) / 5 + 1;
        }
        if (ScanResult.is5GHz(freqMhz)) {
            return (freqMhz - 5160) / 5 + 32;
        }
        if (ScanResult.is6GHz(freqMhz)) {
            return (freqMhz - 5945) / 5 + 1;
        }
        return -1;
    }

    public boolean is24GHz() {
        return ScanResult.is24GHz(this.frequency);
    }

    public boolean is5GHz() {
        return ScanResult.is5GHz(this.frequency);
    }

    public boolean is6GHz() {
        return ScanResult.is6GHz(this.frequency);
    }

    public List<InformationElement> getInformationElements() {
        return Collections.unmodifiableList(Arrays.asList(this.informationElements));
    }

    public ScanResult(WifiSsid wifiSsid, String BSSID, long hessid, int anqpDomainId, byte[] osuProviders, String caps, int level, int frequency, long tsf) {
        this.wifiSsid = wifiSsid;
        this.SSID = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
        this.BSSID = BSSID;
        this.hessid = hessid;
        this.anqpDomainId = anqpDomainId;
        if (osuProviders != null) {
            this.anqpElements = new AnqpInformationElement[1];
            this.anqpElements[0] = new AnqpInformationElement(5271450, 8, osuProviders);
        }
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = -1;
        this.distanceSdCm = -1;
        this.channelWidth = -1;
        this.centerFreq0 = -1;
        this.centerFreq1 = -1;
        this.flags = 0L;
        this.radioChainInfos = null;
        this.mWifiStandard = 0;
    }

    public ScanResult(WifiSsid wifiSsid, String BSSID, String caps, int level, int frequency, long tsf, int distCm, int distSdCm) {
        this.wifiSsid = wifiSsid;
        this.SSID = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
        this.BSSID = BSSID;
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = distCm;
        this.distanceSdCm = distSdCm;
        this.channelWidth = -1;
        this.centerFreq0 = -1;
        this.centerFreq1 = -1;
        this.flags = 0L;
        this.radioChainInfos = null;
        this.mWifiStandard = 0;
    }

    public ScanResult(String Ssid, String BSSID, long hessid, int anqpDomainId, String caps, int level, int frequency, long tsf, int distCm, int distSdCm, int channelWidth, int centerFreq0, int centerFreq1, boolean is80211McRTTResponder) {
        this.SSID = Ssid;
        this.BSSID = BSSID;
        this.hessid = hessid;
        this.anqpDomainId = anqpDomainId;
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = distCm;
        this.distanceSdCm = distSdCm;
        this.channelWidth = channelWidth;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.flags = is80211McRTTResponder ? 2L : 0L;
        this.radioChainInfos = null;
        this.mWifiStandard = 0;
    }

    public ScanResult(WifiSsid wifiSsid, String Ssid, String BSSID, long hessid, int anqpDomainId, String caps, int level, int frequency, long tsf, int distCm, int distSdCm, int channelWidth, int centerFreq0, int centerFreq1, boolean is80211McRTTResponder) {
        this(Ssid, BSSID, hessid, anqpDomainId, caps, level, frequency, tsf, distCm, distSdCm, channelWidth, centerFreq0, centerFreq1, is80211McRTTResponder);
        this.wifiSsid = wifiSsid;
    }

    public ScanResult(ScanResult source) {
        if (source != null) {
            this.wifiSsid = source.wifiSsid;
            this.SSID = source.SSID;
            this.BSSID = source.BSSID;
            this.hessid = source.hessid;
            this.anqpDomainId = source.anqpDomainId;
            this.informationElements = source.informationElements;
            this.anqpElements = source.anqpElements;
            this.capabilities = source.capabilities;
            this.level = source.level;
            this.frequency = source.frequency;
            this.channelWidth = source.channelWidth;
            this.centerFreq0 = source.centerFreq0;
            this.centerFreq1 = source.centerFreq1;
            this.timestamp = source.timestamp;
            this.distanceCm = source.distanceCm;
            this.distanceSdCm = source.distanceSdCm;
            this.seen = source.seen;
            this.untrusted = source.untrusted;
            this.numUsage = source.numUsage;
            this.venueName = source.venueName;
            this.operatorFriendlyName = source.operatorFriendlyName;
            this.flags = source.flags;
            this.radioChainInfos = source.radioChainInfos;
            this.mWifiStandard = source.mWifiStandard;
        }
    }

    public ScanResult() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.wifiSsid == null ? "<unknown ssid>" : this.wifiSsid).append(", BSSID: ").append(this.BSSID == null ? none : this.BSSID).append(", capabilities: ").append(this.capabilities == null ? none : this.capabilities).append(", level: ").append(this.level).append(", frequency: ").append(this.frequency).append(", timestamp: ").append(this.timestamp);
        sb.append(", distance: ").append(this.distanceCm != -1 ? Integer.valueOf(this.distanceCm) : "?").append("(cm)");
        sb.append(", distanceSd: ").append(this.distanceSdCm != -1 ? Integer.valueOf(this.distanceSdCm) : "?").append("(cm)");
        sb.append(", passpoint: ");
        sb.append((this.flags & 1L) != 0L ? "yes" : "no");
        sb.append(", ChannelBandwidth: ").append(this.channelWidth);
        sb.append(", centerFreq0: ").append(this.centerFreq0);
        sb.append(", centerFreq1: ").append(this.centerFreq1);
        sb.append(", standard: ").append(ScanResult.wifiStandardToString(this.mWifiStandard));
        sb.append(", 80211mcResponder: ");
        sb.append((this.flags & 2L) != 0L ? "is supported" : "is not supported");
        sb.append(", Radio Chain Infos: ").append(Arrays.toString(this.radioChainInfos));
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        if (this.wifiSsid != null) {
            dest.writeInt(1);
            this.wifiSsid.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.SSID);
        dest.writeString(this.BSSID);
        dest.writeLong(this.hessid);
        dest.writeInt(this.anqpDomainId);
        dest.writeString(this.capabilities);
        dest.writeInt(this.level);
        dest.writeInt(this.frequency);
        dest.writeLong(this.timestamp);
        dest.writeInt(this.distanceCm);
        dest.writeInt(this.distanceSdCm);
        dest.writeInt(this.channelWidth);
        dest.writeInt(this.centerFreq0);
        dest.writeInt(this.centerFreq1);
        dest.writeInt(this.mWifiStandard);
        dest.writeLong(this.seen);
        dest.writeInt(this.untrusted ? 1 : 0);
        dest.writeInt(this.numUsage);
        dest.writeString(this.venueName != null ? this.venueName.toString() : "");
        dest.writeString(this.operatorFriendlyName != null ? this.operatorFriendlyName.toString() : "");
        dest.writeLong(this.flags);
        if (this.informationElements != null) {
            dest.writeInt(this.informationElements.length);
            for (i = 0; i < this.informationElements.length; ++i) {
                dest.writeInt(this.informationElements[i].id);
                dest.writeInt(this.informationElements[i].idExt);
                dest.writeInt(this.informationElements[i].bytes.length);
                dest.writeByteArray(this.informationElements[i].bytes);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.anqpLines != null) {
            dest.writeInt(this.anqpLines.size());
            for (i = 0; i < this.anqpLines.size(); ++i) {
                dest.writeString(this.anqpLines.get(i));
            }
        } else {
            dest.writeInt(0);
        }
        if (this.anqpElements != null) {
            dest.writeInt(this.anqpElements.length);
            for (AnqpInformationElement element : this.anqpElements) {
                dest.writeInt(element.getVendorId());
                dest.writeInt(element.getElementId());
                dest.writeInt(element.getPayload().length);
                dest.writeByteArray(element.getPayload());
            }
        } else {
            dest.writeInt(0);
        }
        if (this.radioChainInfos != null) {
            dest.writeInt(this.radioChainInfos.length);
            for (int i2 = 0; i2 < this.radioChainInfos.length; ++i2) {
                dest.writeInt(this.radioChainInfos[i2].id);
                dest.writeInt(this.radioChainInfos[i2].level);
            }
        } else {
            dest.writeInt(0);
        }
    }

    public static class InformationElement {
        @UnsupportedAppUsage
        public static final int EID_SSID = 0;
        @UnsupportedAppUsage
        public static final int EID_SUPPORTED_RATES = 1;
        @UnsupportedAppUsage
        public static final int EID_TIM = 5;
        @UnsupportedAppUsage
        public static final int EID_BSS_LOAD = 11;
        @UnsupportedAppUsage
        public static final int EID_ERP = 42;
        public static final int EID_HT_CAPABILITIES = 45;
        @UnsupportedAppUsage
        public static final int EID_RSN = 48;
        @UnsupportedAppUsage
        public static final int EID_EXTENDED_SUPPORTED_RATES = 50;
        @UnsupportedAppUsage
        public static final int EID_HT_OPERATION = 61;
        @UnsupportedAppUsage
        public static final int EID_INTERWORKING = 107;
        @UnsupportedAppUsage
        public static final int EID_ROAMING_CONSORTIUM = 111;
        @UnsupportedAppUsage
        public static final int EID_EXTENDED_CAPS = 127;
        public static final int EID_VHT_CAPABILITIES = 191;
        @UnsupportedAppUsage
        public static final int EID_VHT_OPERATION = 192;
        @UnsupportedAppUsage
        public static final int EID_VSA = 221;
        public static final int EID_EXTENSION_PRESENT = 255;
        public static final int EID_EXT_HE_CAPABILITIES = 35;
        public static final int EID_EXT_HE_OPERATION = 36;
        @UnsupportedAppUsage
        public int id;
        public int idExt;
        @UnsupportedAppUsage
        public byte[] bytes;

        public InformationElement() {
        }

        public InformationElement(InformationElement rhs) {
            this.id = rhs.id;
            this.idExt = rhs.idExt;
            this.bytes = (byte[])rhs.bytes.clone();
        }

        public int getId() {
            return this.id;
        }

        public int getIdExt() {
            return this.idExt;
        }

        public ByteBuffer getBytes() {
            return ByteBuffer.wrap(this.bytes).asReadOnlyBuffer();
        }
    }

    public static class RadioChainInfo {
        public int id;
        public int level;

        public String toString() {
            return "RadioChainInfo: id=" + this.id + ", level=" + this.level;
        }

        public boolean equals(Object otherObj) {
            if (this == otherObj) {
                return true;
            }
            if (!(otherObj instanceof RadioChainInfo)) {
                return false;
            }
            RadioChainInfo other = (RadioChainInfo)otherObj;
            return this.id == other.id && this.level == other.level;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.level);
        }
    }
}

