/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.LinkAddress;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

@SystemApi.Container(value={@SystemApi, @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)})
public class TetheredClient
implements Parcelable {
    private final MacAddress mMacAddress;
    private final List<AddressInfo> mAddresses;
    private final int mTetheringType;
    public static final Parcelable.Creator<TetheredClient> CREATOR = new Parcelable.Creator<TetheredClient>(){

        @Override
        public TetheredClient createFromParcel(Parcel in) {
            return new TetheredClient(in);
        }

        public TetheredClient[] newArray(int size) {
            return new TetheredClient[size];
        }
    };

    public TetheredClient(MacAddress macAddress, Collection<AddressInfo> addresses, int tetheringType) {
        this.mMacAddress = macAddress;
        this.mAddresses = new ArrayList<AddressInfo>(addresses);
        this.mTetheringType = tetheringType;
    }

    private TetheredClient(Parcel in) {
        this((MacAddress)in.readParcelable(null), in.createTypedArrayList(AddressInfo.CREATOR), in.readInt());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mMacAddress, flags);
        dest.writeTypedList(this.mAddresses);
        dest.writeInt(this.mTetheringType);
    }

    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    public List<AddressInfo> getAddresses() {
        return new ArrayList<AddressInfo>(this.mAddresses);
    }

    public int getTetheringType() {
        return this.mTetheringType;
    }

    public TetheredClient addAddresses(TetheredClient other) {
        LinkedHashSet<AddressInfo> newAddresses = new LinkedHashSet<AddressInfo>(this.mAddresses.size() + other.mAddresses.size());
        newAddresses.addAll(this.mAddresses);
        newAddresses.addAll(other.mAddresses);
        return new TetheredClient(this.mMacAddress, newAddresses, this.mTetheringType);
    }

    public int hashCode() {
        return Objects.hash(this.mMacAddress, this.mAddresses, this.mTetheringType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TetheredClient)) {
            return false;
        }
        TetheredClient other = (TetheredClient)obj;
        return this.mMacAddress.equals(other.mMacAddress) && this.mAddresses.equals(other.mAddresses) && this.mTetheringType == other.mTetheringType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "TetheredClient {hwAddr " + this.mMacAddress + ", addresses " + this.mAddresses + ", tetheringType " + this.mTetheringType + "}";
    }

    public static class AddressInfo
    implements Parcelable {
        private final LinkAddress mAddress;
        private final String mHostname;
        public static final Parcelable.Creator<AddressInfo> CREATOR = new Parcelable.Creator<AddressInfo>(){

            @Override
            public AddressInfo createFromParcel(Parcel in) {
                return new AddressInfo(in);
            }

            public AddressInfo[] newArray(int size) {
                return new AddressInfo[size];
            }
        };

        public AddressInfo(LinkAddress address, String hostname) {
            this.mAddress = address;
            this.mHostname = hostname;
        }

        private AddressInfo(Parcel in) {
            this((LinkAddress)in.readParcelable(null), in.readString());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mAddress, flags);
            dest.writeString(this.mHostname);
        }

        public LinkAddress getAddress() {
            return this.mAddress;
        }

        public String getHostname() {
            return this.mHostname;
        }

        public long getExpirationTime() {
            return this.mAddress.getExpirationTime();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.mAddress, this.mHostname);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddressInfo)) {
                return false;
            }
            AddressInfo other = (AddressInfo)obj;
            return other.mAddress.equals(this.mAddress) && Objects.equals(this.mHostname, other.mHostname);
        }

        public String toString() {
            return "AddressInfo {" + this.mAddress + (this.mHostname != null ? ", hostname " + this.mHostname : "") + "}";
        }
    }
}

