/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IIntResultListener;
import android.net.ITetheringEventCallback;
import android.net.TetheringRequestParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;

public interface ITetheringConnector
extends IInterface {
    public void tether(String var1, String var2, IIntResultListener var3) throws RemoteException;

    public void untether(String var1, String var2, IIntResultListener var3) throws RemoteException;

    public void setUsbTethering(boolean var1, String var2, IIntResultListener var3) throws RemoteException;

    public void startTethering(TetheringRequestParcel var1, String var2, IIntResultListener var3) throws RemoteException;

    public void stopTethering(int var1, String var2, IIntResultListener var3) throws RemoteException;

    public void requestLatestTetheringEntitlementResult(int var1, ResultReceiver var2, boolean var3, String var4) throws RemoteException;

    public void registerTetheringEventCallback(ITetheringEventCallback var1, String var2) throws RemoteException;

    public void unregisterTetheringEventCallback(ITetheringEventCallback var1, String var2) throws RemoteException;

    public void isTetheringSupported(String var1, IIntResultListener var2) throws RemoteException;

    public void stopAllTethering(String var1, IIntResultListener var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITetheringConnector {
        private static final String DESCRIPTOR = "android.net.ITetheringConnector";
        static final int TRANSACTION_tether = 1;
        static final int TRANSACTION_untether = 2;
        static final int TRANSACTION_setUsbTethering = 3;
        static final int TRANSACTION_startTethering = 4;
        static final int TRANSACTION_stopTethering = 5;
        static final int TRANSACTION_requestLatestTetheringEntitlementResult = 6;
        static final int TRANSACTION_registerTetheringEventCallback = 7;
        static final int TRANSACTION_unregisterTetheringEventCallback = 8;
        static final int TRANSACTION_isTetheringSupported = 9;
        static final int TRANSACTION_stopAllTethering = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITetheringConnector asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITetheringConnector) {
                return (ITetheringConnector)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "tether";
                }
                case 2: {
                    return "untether";
                }
                case 3: {
                    return "setUsbTethering";
                }
                case 4: {
                    return "startTethering";
                }
                case 5: {
                    return "stopTethering";
                }
                case 6: {
                    return "requestLatestTetheringEntitlementResult";
                }
                case 7: {
                    return "registerTetheringEventCallback";
                }
                case 8: {
                    return "unregisterTetheringEventCallback";
                }
                case 9: {
                    return "isTetheringSupported";
                }
                case 10: {
                    return "stopAllTethering";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.tether(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.untether(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.setUsbTethering(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    TetheringRequestParcel _arg0 = 0 != data.readInt() ? TetheringRequestParcel.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.startTethering(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.stopTethering(_arg0, _arg1, _arg2);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ResultReceiver _arg1 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    String _arg3 = data.readString();
                    this.requestLatestTetheringEntitlementResult(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ITetheringEventCallback _arg0 = ITetheringEventCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.registerTetheringEventCallback(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    ITetheringEventCallback _arg0 = ITetheringEventCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.unregisterTetheringEventCallback(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IIntResultListener _arg1 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.isTetheringSupported(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IIntResultListener _arg1 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.stopAllTethering(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITetheringConnector impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITetheringConnector getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITetheringConnector {
            private IBinder mRemote;
            public static ITetheringConnector sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tether(String iface, String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().tether(iface, callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void untether(String iface, String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().untether(iface, callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUsbTethering(boolean enable, String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUsbTethering(enable, callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTethering(TetheringRequestParcel request, String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startTethering(request, callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTethering(int type, String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopTethering(type, callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestLatestTetheringEntitlementResult(int type, ResultReceiver receiver, boolean showEntitlementUi, String callerPkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    if (receiver != null) {
                        _data.writeInt(1);
                        receiver.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(showEntitlementUi ? 1 : 0);
                    _data.writeString(callerPkg);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestLatestTetheringEntitlementResult(type, receiver, showEntitlementUi, callerPkg);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(callerPkg);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerTetheringEventCallback(callback, callerPkg);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(callerPkg);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterTetheringEventCallback(callback, callerPkg);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isTetheringSupported(String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().isTetheringSupported(callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAllTethering(String callerPkg, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callerPkg);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopAllTethering(callerPkg, receiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITetheringConnector {
        @Override
        public void tether(String iface, String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void untether(String iface, String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void setUsbTethering(boolean enable, String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void startTethering(TetheringRequestParcel request, String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void stopTethering(int type, String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void requestLatestTetheringEntitlementResult(int type, ResultReceiver receiver, boolean showEntitlementUi, String callerPkg) throws RemoteException {
        }

        @Override
        public void registerTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
        }

        @Override
        public void unregisterTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
        }

        @Override
        public void isTetheringSupported(String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void stopAllTethering(String callerPkg, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

