/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.media.MediaMetadata;
import android.media.MediaMetadataEditor;
import android.media.Rating;
import android.media.session.MediaSession;
import android.media.session.MediaSessionLegacyHelper;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;

@Deprecated
public class RemoteControlClient {
    private static final String TAG = "RemoteControlClient";
    private static final boolean DEBUG = false;
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int PLAYSTATE_FAST_FORWARDING = 4;
    public static final int PLAYSTATE_REWINDING = 5;
    public static final int PLAYSTATE_SKIPPING_FORWARDS = 6;
    public static final int PLAYSTATE_SKIPPING_BACKWARDS = 7;
    public static final int PLAYSTATE_BUFFERING = 8;
    public static final int PLAYSTATE_ERROR = 9;
    public static final int PLAYSTATE_NONE = 0;
    public static final int PLAYBACK_TYPE_LOCAL = 0;
    public static final int PLAYBACK_TYPE_REMOTE = 1;
    private static final int PLAYBACK_TYPE_MIN = 0;
    private static final int PLAYBACK_TYPE_MAX = 1;
    public static final int PLAYBACK_VOLUME_FIXED = 0;
    public static final int PLAYBACK_VOLUME_VARIABLE = 1;
    public static final int PLAYBACKINFO_INVALID_VALUE = Integer.MIN_VALUE;
    public static final long PLAYBACK_POSITION_INVALID = -1L;
    public static final long PLAYBACK_POSITION_ALWAYS_UNKNOWN = -9216204211029966080L;
    public static final float PLAYBACK_SPEED_1X = 1.0f;
    public static final int PLAYBACKINFO_PLAYBACK_TYPE = 1;
    public static final int PLAYBACKINFO_VOLUME = 2;
    public static final int PLAYBACKINFO_VOLUME_MAX = 3;
    public static final int PLAYBACKINFO_VOLUME_HANDLING = 4;
    public static final int PLAYBACKINFO_USES_STREAM = 5;
    public static final int FLAG_KEY_MEDIA_PREVIOUS = 1;
    public static final int FLAG_KEY_MEDIA_REWIND = 2;
    public static final int FLAG_KEY_MEDIA_PLAY = 4;
    public static final int FLAG_KEY_MEDIA_PLAY_PAUSE = 8;
    public static final int FLAG_KEY_MEDIA_PAUSE = 16;
    public static final int FLAG_KEY_MEDIA_STOP = 32;
    public static final int FLAG_KEY_MEDIA_FAST_FORWARD = 64;
    public static final int FLAG_KEY_MEDIA_NEXT = 128;
    public static final int FLAG_KEY_MEDIA_POSITION_UPDATE = 256;
    public static final int FLAG_KEY_MEDIA_RATING = 512;
    public static final int FLAGS_KEY_MEDIA_NONE = 0;
    public static final int FLAG_INFORMATION_REQUEST_METADATA = 1;
    public static final int FLAG_INFORMATION_REQUEST_KEY_MEDIA = 2;
    public static final int FLAG_INFORMATION_REQUEST_PLAYSTATE = 4;
    public static final int FLAG_INFORMATION_REQUEST_ALBUM_ART = 8;
    private MediaSession mSession;
    @UnsupportedAppUsage
    public static int MEDIA_POSITION_READABLE = 1;
    @UnsupportedAppUsage
    public static int MEDIA_POSITION_WRITABLE = 2;
    public static final int DEFAULT_PLAYBACK_VOLUME_HANDLING = 1;
    public static final int DEFAULT_PLAYBACK_VOLUME = 15;
    private final Object mCacheLock = new Object();
    private int mPlaybackState = 0;
    private long mPlaybackStateChangeTimeMs = 0L;
    private long mPlaybackPositionMs = -1L;
    private float mPlaybackSpeed = 1.0f;
    private Bitmap mOriginalArtwork;
    private int mTransportControlFlags = 0;
    private Bundle mMetadata = new Bundle();
    private OnPlaybackPositionUpdateListener mPositionUpdateListener;
    private OnGetPlaybackPositionListener mPositionProvider;
    private OnMetadataUpdateListener mMetadataUpdateListener;
    private int mCurrentClientGenId = -1;
    private final PendingIntent mRcMediaIntent;
    private boolean mNeedsPositionSync = false;
    private PlaybackState mSessionPlaybackState = null;
    private MediaMetadata mMediaMetadata;
    public static final int RCSE_ID_UNREGISTERED = -1;
    private MediaSession.Callback mTransportListener = new MediaSession.Callback(){

        @Override
        public void onSeekTo(long pos) {
            RemoteControlClient.this.onSeekTo(RemoteControlClient.this.mCurrentClientGenId, pos);
        }

        @Override
        public void onSetRating(Rating rating) {
            if ((RemoteControlClient.this.mTransportControlFlags & 0x200) != 0) {
                RemoteControlClient.this.onUpdateMetadata(RemoteControlClient.this.mCurrentClientGenId, 0x10000001, rating);
            }
        }
    };
    private static final long POSITION_REFRESH_PERIOD_PLAYING_MS = 15000L;
    private static final long POSITION_REFRESH_PERIOD_MIN_MS = 2000L;
    private static final long POSITION_DRIFT_MAX_MS = 500L;

    public RemoteControlClient(PendingIntent mediaButtonIntent) {
        this.mRcMediaIntent = mediaButtonIntent;
    }

    public RemoteControlClient(PendingIntent mediaButtonIntent, Looper looper) {
        this.mRcMediaIntent = mediaButtonIntent;
    }

    public void registerWithSession(MediaSessionLegacyHelper helper) {
        helper.addRccListener(this.mRcMediaIntent, this.mTransportListener);
        this.mSession = helper.getSession(this.mRcMediaIntent);
        this.setTransportControlFlags(this.mTransportControlFlags);
    }

    public void unregisterWithSession(MediaSessionLegacyHelper helper) {
        helper.removeRccListener(this.mRcMediaIntent);
        this.mSession = null;
    }

    public MediaSession getMediaSession() {
        return this.mSession;
    }

    public MetadataEditor editMetadata(boolean startEmpty) {
        MetadataEditor editor = new MetadataEditor();
        if (startEmpty) {
            editor.mEditorMetadata = new Bundle();
            editor.mEditorArtwork = null;
            editor.mMetadataChanged = true;
            editor.mArtworkChanged = true;
            editor.mEditableKeys = 0L;
        } else {
            editor.mEditorMetadata = new Bundle(this.mMetadata);
            editor.mEditorArtwork = this.mOriginalArtwork;
            editor.mMetadataChanged = false;
            editor.mArtworkChanged = false;
        }
        editor.mMetadataBuilder = startEmpty || this.mMediaMetadata == null ? new MediaMetadata.Builder() : new MediaMetadata.Builder(this.mMediaMetadata);
        return editor;
    }

    public void setPlaybackState(int state) {
        this.setPlaybackStateInt(state, -9216204211029966080L, 1.0f, false);
    }

    public void setPlaybackState(int state, long timeInMs, float playbackSpeed) {
        this.setPlaybackStateInt(state, timeInMs, playbackSpeed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPlaybackStateInt(int state, long timeInMs, float playbackSpeed, boolean hasPosition) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mPlaybackState != state || this.mPlaybackPositionMs != timeInMs || this.mPlaybackSpeed != playbackSpeed) {
                this.mPlaybackState = state;
                this.mPlaybackPositionMs = hasPosition ? (timeInMs < 0L ? -1L : timeInMs) : -9216204211029966080L;
                this.mPlaybackSpeed = playbackSpeed;
                this.mPlaybackStateChangeTimeMs = SystemClock.elapsedRealtime();
                if (this.mSession != null) {
                    int pbState = RemoteControlClient.getStateFromRccState(state);
                    long position = hasPosition ? this.mPlaybackPositionMs : -1L;
                    PlaybackState.Builder bob = new PlaybackState.Builder(this.mSessionPlaybackState);
                    bob.setState(pbState, position, playbackSpeed, SystemClock.elapsedRealtime());
                    bob.setErrorMessage(null);
                    this.mSessionPlaybackState = bob.build();
                    this.mSession.setPlaybackState(this.mSessionPlaybackState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportControlFlags(int transportControlFlags) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mTransportControlFlags = transportControlFlags;
            if (this.mSession != null) {
                PlaybackState.Builder bob = new PlaybackState.Builder(this.mSessionPlaybackState);
                bob.setActions(RemoteControlClient.getActionsFromRccControlFlags(transportControlFlags));
                this.mSessionPlaybackState = bob.build();
                this.mSession.setPlaybackState(this.mSessionPlaybackState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadataUpdateListener(OnMetadataUpdateListener l) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mMetadataUpdateListener = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener l) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mPositionUpdateListener = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnGetPlaybackPositionListener(OnGetPlaybackPositionListener l) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mPositionProvider = l;
        }
    }

    public PendingIntent getRcMediaIntent() {
        return this.mRcMediaIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSeekTo(int generationId, long timeMs) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mCurrentClientGenId == generationId && this.mPositionUpdateListener != null) {
                this.mPositionUpdateListener.onPlaybackPositionUpdate(timeMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateMetadata(int generationId, int key, Object value) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mCurrentClientGenId == generationId && this.mMetadataUpdateListener != null) {
                this.mMetadataUpdateListener.onMetadataUpdate(key, value);
            }
        }
    }

    static boolean playbackPositionShouldMove(int playstate) {
        switch (playstate) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    private static long getCheckPeriodFromSpeed(float speed) {
        if (Math.abs(speed) <= 1.0f) {
            return 15000L;
        }
        return Math.max((long)(15000.0f / Math.abs(speed)), 2000L);
    }

    private static int getStateFromRccState(int rccState) {
        switch (rccState) {
            case 8: {
                return 6;
            }
            case 9: {
                return 7;
            }
            case 4: {
                return 4;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 7: {
                return 9;
            }
            case 6: {
                return 10;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    static int getRccStateFromState(int state) {
        switch (state) {
            case 6: {
                return 8;
            }
            case 7: {
                return 9;
            }
            case 4: {
                return 4;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 9: {
                return 7;
            }
            case 10: {
                return 6;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    private static long getActionsFromRccControlFlags(int rccFlags) {
        long actions = 0L;
        for (long flag = 1L; flag <= (long)rccFlags; flag <<= 1) {
            if ((flag & (long)rccFlags) == 0L) continue;
            actions |= RemoteControlClient.getActionForRccFlag((int)flag);
        }
        return actions;
    }

    static int getRccControlFlagsFromActions(long actions) {
        int rccFlags = 0;
        for (long action = 1L; action <= actions && action < Integer.MAX_VALUE; action <<= 1) {
            if ((action & actions) == 0L) continue;
            rccFlags |= RemoteControlClient.getRccFlagForAction(action);
        }
        return rccFlags;
    }

    private static long getActionForRccFlag(int flag) {
        switch (flag) {
            case 1: {
                return 16L;
            }
            case 2: {
                return 8L;
            }
            case 4: {
                return 4L;
            }
            case 8: {
                return 512L;
            }
            case 16: {
                return 2L;
            }
            case 32: {
                return 1L;
            }
            case 64: {
                return 64L;
            }
            case 128: {
                return 32L;
            }
            case 256: {
                return 256L;
            }
            case 512: {
                return 128L;
            }
        }
        return 0L;
    }

    private static int getRccFlagForAction(long action) {
        int testAction = action < Integer.MAX_VALUE ? (int)action : 0;
        switch (testAction) {
            case 16: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 512: {
                return 8;
            }
            case 2: {
                return 16;
            }
            case 1: {
                return 32;
            }
            case 64: {
                return 64;
            }
            case 32: {
                return 128;
            }
            case 256: {
                return 256;
            }
            case 128: {
                return 512;
            }
        }
        return 0;
    }

    public static interface OnGetPlaybackPositionListener {
        public long onGetPlaybackPosition();
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onPlaybackPositionUpdate(long var1);
    }

    public static interface OnMetadataUpdateListener {
        public void onMetadataUpdate(int var1, Object var2);
    }

    @Deprecated
    public class MetadataEditor
    extends MediaMetadataEditor {
        public static final int BITMAP_KEY_ARTWORK = 100;
        public static final int METADATA_KEY_ARTWORK = 100;

        private MetadataEditor() {
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        @Override
        public synchronized MetadataEditor putString(int key, String value) throws IllegalArgumentException {
            String metadataKey;
            super.putString(key, value);
            if (this.mMetadataBuilder != null && (metadataKey = MediaMetadata.getKeyFromMetadataEditorKey(key)) != null) {
                this.mMetadataBuilder.putText(metadataKey, value);
            }
            return this;
        }

        @Override
        public synchronized MetadataEditor putLong(int key, long value) throws IllegalArgumentException {
            String metadataKey;
            super.putLong(key, value);
            if (this.mMetadataBuilder != null && (metadataKey = MediaMetadata.getKeyFromMetadataEditorKey(key)) != null) {
                this.mMetadataBuilder.putLong(metadataKey, value);
            }
            return this;
        }

        @Override
        public synchronized MetadataEditor putBitmap(int key, Bitmap bitmap) throws IllegalArgumentException {
            String metadataKey;
            super.putBitmap(key, bitmap);
            if (this.mMetadataBuilder != null && (metadataKey = MediaMetadata.getKeyFromMetadataEditorKey(key)) != null) {
                this.mMetadataBuilder.putBitmap(metadataKey, bitmap);
            }
            return this;
        }

        @Override
        public synchronized MetadataEditor putObject(int key, Object object) throws IllegalArgumentException {
            String metadataKey;
            super.putObject(key, object);
            if (this.mMetadataBuilder != null && (key == 0x10000001 || key == 101) && (metadataKey = MediaMetadata.getKeyFromMetadataEditorKey(key)) != null) {
                this.mMetadataBuilder.putRating(metadataKey, (Rating)object);
            }
            return this;
        }

        @Override
        public synchronized void clear() {
            super.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void apply() {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't apply a previously applied MetadataEditor");
                return;
            }
            Object object = RemoteControlClient.this.mCacheLock;
            synchronized (object) {
                RemoteControlClient.this.mMetadata = new Bundle(this.mEditorMetadata);
                RemoteControlClient.this.mMetadata.putLong(String.valueOf(0x1FFFFFFF), this.mEditableKeys);
                if (RemoteControlClient.this.mOriginalArtwork != null && !RemoteControlClient.this.mOriginalArtwork.equals(this.mEditorArtwork)) {
                    RemoteControlClient.this.mOriginalArtwork.recycle();
                }
                RemoteControlClient.this.mOriginalArtwork = this.mEditorArtwork;
                this.mEditorArtwork = null;
                if (RemoteControlClient.this.mSession != null && this.mMetadataBuilder != null) {
                    RemoteControlClient.this.mMediaMetadata = this.mMetadataBuilder.build();
                    RemoteControlClient.this.mSession.setMetadata(RemoteControlClient.this.mMediaMetadata);
                }
                this.mApplied = true;
            }
        }
    }
}

