/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_5;

import android.internal.hidl.safe_union.V1_0.Monostate;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class BarringInfo {
    public int serviceType = 0;
    public int barringType = 0;
    public BarringTypeSpecificInfo barringTypeSpecificInfo = new BarringTypeSpecificInfo();

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != BarringInfo.class) {
            return false;
        }
        BarringInfo other = (BarringInfo)otherObject;
        if (this.serviceType != other.serviceType) {
            return false;
        }
        if (this.barringType != other.barringType) {
            return false;
        }
        return HidlSupport.deepEquals(this.barringTypeSpecificInfo, other.barringTypeSpecificInfo);
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.serviceType), HidlSupport.deepHashCode(this.barringType), HidlSupport.deepHashCode(this.barringTypeSpecificInfo));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".serviceType = ");
        builder.append(ServiceType.toString(this.serviceType));
        builder.append(", .barringType = ");
        builder.append(BarringType.toString(this.barringType));
        builder.append(", .barringTypeSpecificInfo = ");
        builder.append(this.barringTypeSpecificInfo);
        builder.append("}");
        return builder.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<BarringInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<BarringInfo> _hidl_vec = new ArrayList<BarringInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            BarringInfo _hidl_vec_element = new BarringInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.serviceType = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.barringType = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.barringTypeSpecificInfo.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 8L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<BarringInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.serviceType);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.barringType);
        this.barringTypeSpecificInfo.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 8L);
    }

    public static class BarringTypeSpecificInfo {
        private byte hidl_d = 0;
        private Object hidl_o = new Monostate();

        public void noinit(Monostate noinit) {
            this.hidl_d = 0;
            this.hidl_o = noinit;
        }

        public Monostate noinit() {
            if (this.hidl_d != 0) {
                String className = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className + ".");
            }
            if (this.hidl_o != null && !Monostate.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (Monostate)this.hidl_o;
        }

        public void conditional(Conditional conditional) {
            this.hidl_d = 1;
            this.hidl_o = conditional;
        }

        public Conditional conditional() {
            if (this.hidl_d != 1) {
                String className = this.hidl_o != null ? this.hidl_o.getClass().getName() : "null";
                throw new IllegalStateException("Read access to inactive union components is disallowed. Discriminator value is " + this.hidl_d + " (corresponding to " + hidl_discriminator.getName(this.hidl_d) + "), and hidl_o is of type " + className + ".");
            }
            if (this.hidl_o != null && !Conditional.class.isInstance(this.hidl_o)) {
                throw new Error("Union is in a corrupted state.");
            }
            return (Conditional)this.hidl_o;
        }

        public byte getDiscriminator() {
            return this.hidl_d;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null) {
                return false;
            }
            if (otherObject.getClass() != BarringTypeSpecificInfo.class) {
                return false;
            }
            BarringTypeSpecificInfo other = (BarringTypeSpecificInfo)otherObject;
            if (this.hidl_d != other.hidl_d) {
                return false;
            }
            return HidlSupport.deepEquals(this.hidl_o, other.hidl_o);
        }

        public int hashCode() {
            return Objects.hash(HidlSupport.deepHashCode(this.hidl_o), Objects.hashCode(this.hidl_d));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            switch (this.hidl_d) {
                case 0: {
                    builder.append(".noinit = ");
                    builder.append(this.noinit());
                    break;
                }
                case 1: {
                    builder.append(".conditional = ");
                    builder.append(this.conditional());
                    break;
                }
                default: {
                    throw new Error("Unknown union discriminator (value: " + this.hidl_d + ").");
                }
            }
            builder.append("}");
            return builder.toString();
        }

        public void readFromParcel(HwParcel parcel) {
            HwBlob blob = parcel.readBuffer(16L);
            this.readEmbeddedFromParcel(parcel, blob, 0L);
        }

        public static ArrayList<BarringTypeSpecificInfo> readVectorFromParcel(HwParcel parcel) {
            ArrayList<BarringTypeSpecificInfo> _hidl_vec = new ArrayList<BarringTypeSpecificInfo>();
            HwBlob _hidl_blob = parcel.readBuffer(16L);
            int _hidl_vec_size = _hidl_blob.getInt32(8L);
            HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), 0L, true);
            _hidl_vec.clear();
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                BarringTypeSpecificInfo _hidl_vec_element = new BarringTypeSpecificInfo();
                _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
                _hidl_vec.add(_hidl_vec_element);
            }
            return _hidl_vec;
        }

        public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
            this.hidl_d = _hidl_blob.getInt8(_hidl_offset + 0L);
            switch (this.hidl_d) {
                case 0: {
                    this.hidl_o = new Monostate();
                    ((Monostate)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 4L);
                    break;
                }
                case 1: {
                    this.hidl_o = new Conditional();
                    ((Conditional)this.hidl_o).readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 4L);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown union discriminator (value: " + this.hidl_d + ").");
                }
            }
        }

        public void writeToParcel(HwParcel parcel) {
            HwBlob _hidl_blob = new HwBlob(16);
            this.writeEmbeddedToBlob(_hidl_blob, 0L);
            parcel.writeBuffer(_hidl_blob);
        }

        public static void writeVectorToParcel(HwParcel parcel, ArrayList<BarringTypeSpecificInfo> _hidl_vec) {
            HwBlob _hidl_blob = new HwBlob(16);
            int _hidl_vec_size = _hidl_vec.size();
            _hidl_blob.putInt32(8L, _hidl_vec_size);
            _hidl_blob.putBool(12L, false);
            HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
            }
            _hidl_blob.putBlob(0L, childBlob);
            parcel.writeBuffer(_hidl_blob);
        }

        public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
            _hidl_blob.putInt8(_hidl_offset + 0L, this.hidl_d);
            switch (this.hidl_d) {
                case 0: {
                    this.noinit().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 4L);
                    break;
                }
                case 1: {
                    this.conditional().writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 4L);
                    break;
                }
                default: {
                    throw new Error("Unknown union discriminator (value: " + this.hidl_d + ").");
                }
            }
        }

        public static class hidl_discriminator {
            public static final byte noinit = 0;
            public static final byte conditional = 1;

            public static String getName(byte value) {
                switch (value) {
                    case 0: {
                        return "noinit";
                    }
                    case 1: {
                        return "conditional";
                    }
                }
                return "Unknown";
            }

            private hidl_discriminator() {
            }
        }

        public static class Conditional {
            public int factor = 0;
            public int timeSeconds = 0;
            public boolean isBarred = false;

            public boolean equals(Object otherObject) {
                if (this == otherObject) {
                    return true;
                }
                if (otherObject == null) {
                    return false;
                }
                if (otherObject.getClass() != Conditional.class) {
                    return false;
                }
                Conditional other = (Conditional)otherObject;
                if (this.factor != other.factor) {
                    return false;
                }
                if (this.timeSeconds != other.timeSeconds) {
                    return false;
                }
                return this.isBarred == other.isBarred;
            }

            public int hashCode() {
                return Objects.hash(HidlSupport.deepHashCode(this.factor), HidlSupport.deepHashCode(this.timeSeconds), HidlSupport.deepHashCode(this.isBarred));
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                builder.append(".factor = ");
                builder.append(this.factor);
                builder.append(", .timeSeconds = ");
                builder.append(this.timeSeconds);
                builder.append(", .isBarred = ");
                builder.append(this.isBarred);
                builder.append("}");
                return builder.toString();
            }

            public void readFromParcel(HwParcel parcel) {
                HwBlob blob = parcel.readBuffer(12L);
                this.readEmbeddedFromParcel(parcel, blob, 0L);
            }

            public static ArrayList<Conditional> readVectorFromParcel(HwParcel parcel) {
                ArrayList<Conditional> _hidl_vec = new ArrayList<Conditional>();
                HwBlob _hidl_blob = parcel.readBuffer(16L);
                int _hidl_vec_size = _hidl_blob.getInt32(8L);
                HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 12, _hidl_blob.handle(), 0L, true);
                _hidl_vec.clear();
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    Conditional _hidl_vec_element = new Conditional();
                    _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 12);
                    _hidl_vec.add(_hidl_vec_element);
                }
                return _hidl_vec;
            }

            public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
                this.factor = _hidl_blob.getInt32(_hidl_offset + 0L);
                this.timeSeconds = _hidl_blob.getInt32(_hidl_offset + 4L);
                this.isBarred = _hidl_blob.getBool(_hidl_offset + 8L);
            }

            public void writeToParcel(HwParcel parcel) {
                HwBlob _hidl_blob = new HwBlob(12);
                this.writeEmbeddedToBlob(_hidl_blob, 0L);
                parcel.writeBuffer(_hidl_blob);
            }

            public static void writeVectorToParcel(HwParcel parcel, ArrayList<Conditional> _hidl_vec) {
                HwBlob _hidl_blob = new HwBlob(16);
                int _hidl_vec_size = _hidl_vec.size();
                _hidl_blob.putInt32(8L, _hidl_vec_size);
                _hidl_blob.putBool(12L, false);
                HwBlob childBlob = new HwBlob(_hidl_vec_size * 12);
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 12);
                }
                _hidl_blob.putBlob(0L, childBlob);
                parcel.writeBuffer(_hidl_blob);
            }

            public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
                _hidl_blob.putInt32(_hidl_offset + 0L, this.factor);
                _hidl_blob.putInt32(_hidl_offset + 4L, this.timeSeconds);
                _hidl_blob.putBool(_hidl_offset + 8L, this.isBarred);
            }
        }
    }

    public static class BarringType {
        public static final int NONE = 0;
        public static final int CONDITIONAL = 1;
        public static final int UNCONDITIONAL = 2;

        public static String toString(int o) {
            if (o == 0) {
                return "NONE";
            }
            if (o == 1) {
                return "CONDITIONAL";
            }
            if (o == 2) {
                return "UNCONDITIONAL";
            }
            return "0x" + Integer.toHexString(o);
        }

        public static String dumpBitfield(int o) {
            ArrayList<String> list = new ArrayList<String>();
            int flipped = 0;
            list.add("NONE");
            if ((o & 1) == 1) {
                list.add("CONDITIONAL");
                flipped |= 1;
            }
            if ((o & 2) == 2) {
                list.add("UNCONDITIONAL");
                flipped |= 2;
            }
            if (o != flipped) {
                list.add("0x" + Integer.toHexString(o & ~flipped));
            }
            return String.join((CharSequence)" | ", list);
        }
    }

    public static class ServiceType {
        public static final int CS_SERVICE = 0;
        public static final int PS_SERVICE = 1;
        public static final int CS_VOICE = 2;
        public static final int MO_SIGNALLING = 3;
        public static final int MO_DATA = 4;
        public static final int CS_FALLBACK = 5;
        public static final int MMTEL_VOICE = 6;
        public static final int MMTEL_VIDEO = 7;
        public static final int EMERGENCY = 8;
        public static final int SMS = 9;
        public static final int OPERATOR_1 = 1001;
        public static final int OPERATOR_2 = 1002;
        public static final int OPERATOR_3 = 1003;
        public static final int OPERATOR_4 = 1004;
        public static final int OPERATOR_5 = 1005;
        public static final int OPERATOR_6 = 1006;
        public static final int OPERATOR_7 = 1007;
        public static final int OPERATOR_8 = 1008;
        public static final int OPERATOR_9 = 1009;
        public static final int OPERATOR_10 = 1010;
        public static final int OPERATOR_11 = 1011;
        public static final int OPERATOR_12 = 1012;
        public static final int OPERATOR_13 = 1013;
        public static final int OPERATOR_14 = 1014;
        public static final int OPERATOR_15 = 1015;
        public static final int OPERATOR_16 = 1016;
        public static final int OPERATOR_17 = 1017;
        public static final int OPERATOR_18 = 1018;
        public static final int OPERATOR_19 = 1019;
        public static final int OPERATOR_20 = 1020;
        public static final int OPERATOR_21 = 1021;
        public static final int OPERATOR_22 = 1022;
        public static final int OPERATOR_23 = 1023;
        public static final int OPERATOR_24 = 1024;
        public static final int OPERATOR_25 = 1025;
        public static final int OPERATOR_26 = 1026;
        public static final int OPERATOR_27 = 1027;
        public static final int OPERATOR_28 = 1028;
        public static final int OPERATOR_29 = 1029;
        public static final int OPERATOR_30 = 1030;
        public static final int OPERATOR_31 = 1031;
        public static final int OPERATOR_32 = 1032;

        public static String toString(int o) {
            if (o == 0) {
                return "CS_SERVICE";
            }
            if (o == 1) {
                return "PS_SERVICE";
            }
            if (o == 2) {
                return "CS_VOICE";
            }
            if (o == 3) {
                return "MO_SIGNALLING";
            }
            if (o == 4) {
                return "MO_DATA";
            }
            if (o == 5) {
                return "CS_FALLBACK";
            }
            if (o == 6) {
                return "MMTEL_VOICE";
            }
            if (o == 7) {
                return "MMTEL_VIDEO";
            }
            if (o == 8) {
                return "EMERGENCY";
            }
            if (o == 9) {
                return "SMS";
            }
            if (o == 1001) {
                return "OPERATOR_1";
            }
            if (o == 1002) {
                return "OPERATOR_2";
            }
            if (o == 1003) {
                return "OPERATOR_3";
            }
            if (o == 1004) {
                return "OPERATOR_4";
            }
            if (o == 1005) {
                return "OPERATOR_5";
            }
            if (o == 1006) {
                return "OPERATOR_6";
            }
            if (o == 1007) {
                return "OPERATOR_7";
            }
            if (o == 1008) {
                return "OPERATOR_8";
            }
            if (o == 1009) {
                return "OPERATOR_9";
            }
            if (o == 1010) {
                return "OPERATOR_10";
            }
            if (o == 1011) {
                return "OPERATOR_11";
            }
            if (o == 1012) {
                return "OPERATOR_12";
            }
            if (o == 1013) {
                return "OPERATOR_13";
            }
            if (o == 1014) {
                return "OPERATOR_14";
            }
            if (o == 1015) {
                return "OPERATOR_15";
            }
            if (o == 1016) {
                return "OPERATOR_16";
            }
            if (o == 1017) {
                return "OPERATOR_17";
            }
            if (o == 1018) {
                return "OPERATOR_18";
            }
            if (o == 1019) {
                return "OPERATOR_19";
            }
            if (o == 1020) {
                return "OPERATOR_20";
            }
            if (o == 1021) {
                return "OPERATOR_21";
            }
            if (o == 1022) {
                return "OPERATOR_22";
            }
            if (o == 1023) {
                return "OPERATOR_23";
            }
            if (o == 1024) {
                return "OPERATOR_24";
            }
            if (o == 1025) {
                return "OPERATOR_25";
            }
            if (o == 1026) {
                return "OPERATOR_26";
            }
            if (o == 1027) {
                return "OPERATOR_27";
            }
            if (o == 1028) {
                return "OPERATOR_28";
            }
            if (o == 1029) {
                return "OPERATOR_29";
            }
            if (o == 1030) {
                return "OPERATOR_30";
            }
            if (o == 1031) {
                return "OPERATOR_31";
            }
            if (o == 1032) {
                return "OPERATOR_32";
            }
            return "0x" + Integer.toHexString(o);
        }

        public static String dumpBitfield(int o) {
            ArrayList<String> list = new ArrayList<String>();
            int flipped = 0;
            list.add("CS_SERVICE");
            if ((o & 1) == 1) {
                list.add("PS_SERVICE");
                flipped |= 1;
            }
            if ((o & 2) == 2) {
                list.add("CS_VOICE");
                flipped |= 2;
            }
            if ((o & 3) == 3) {
                list.add("MO_SIGNALLING");
                flipped |= 3;
            }
            if ((o & 4) == 4) {
                list.add("MO_DATA");
                flipped |= 4;
            }
            if ((o & 5) == 5) {
                list.add("CS_FALLBACK");
                flipped |= 5;
            }
            if ((o & 6) == 6) {
                list.add("MMTEL_VOICE");
                flipped |= 6;
            }
            if ((o & 7) == 7) {
                list.add("MMTEL_VIDEO");
                flipped |= 7;
            }
            if ((o & 8) == 8) {
                list.add("EMERGENCY");
                flipped |= 8;
            }
            if ((o & 9) == 9) {
                list.add("SMS");
                flipped |= 9;
            }
            if ((o & 0x3E9) == 1001) {
                list.add("OPERATOR_1");
                flipped |= 0x3E9;
            }
            if ((o & 0x3EA) == 1002) {
                list.add("OPERATOR_2");
                flipped |= 0x3EA;
            }
            if ((o & 0x3EB) == 1003) {
                list.add("OPERATOR_3");
                flipped |= 0x3EB;
            }
            if ((o & 0x3EC) == 1004) {
                list.add("OPERATOR_4");
                flipped |= 0x3EC;
            }
            if ((o & 0x3ED) == 1005) {
                list.add("OPERATOR_5");
                flipped |= 0x3ED;
            }
            if ((o & 0x3EE) == 1006) {
                list.add("OPERATOR_6");
                flipped |= 0x3EE;
            }
            if ((o & 0x3EF) == 1007) {
                list.add("OPERATOR_7");
                flipped |= 0x3EF;
            }
            if ((o & 0x3F0) == 1008) {
                list.add("OPERATOR_8");
                flipped |= 0x3F0;
            }
            if ((o & 0x3F1) == 1009) {
                list.add("OPERATOR_9");
                flipped |= 0x3F1;
            }
            if ((o & 0x3F2) == 1010) {
                list.add("OPERATOR_10");
                flipped |= 0x3F2;
            }
            if ((o & 0x3F3) == 1011) {
                list.add("OPERATOR_11");
                flipped |= 0x3F3;
            }
            if ((o & 0x3F4) == 1012) {
                list.add("OPERATOR_12");
                flipped |= 0x3F4;
            }
            if ((o & 0x3F5) == 1013) {
                list.add("OPERATOR_13");
                flipped |= 0x3F5;
            }
            if ((o & 0x3F6) == 1014) {
                list.add("OPERATOR_14");
                flipped |= 0x3F6;
            }
            if ((o & 0x3F7) == 1015) {
                list.add("OPERATOR_15");
                flipped |= 0x3F7;
            }
            if ((o & 0x3F8) == 1016) {
                list.add("OPERATOR_16");
                flipped |= 0x3F8;
            }
            if ((o & 0x3F9) == 1017) {
                list.add("OPERATOR_17");
                flipped |= 0x3F9;
            }
            if ((o & 0x3FA) == 1018) {
                list.add("OPERATOR_18");
                flipped |= 0x3FA;
            }
            if ((o & 0x3FB) == 1019) {
                list.add("OPERATOR_19");
                flipped |= 0x3FB;
            }
            if ((o & 0x3FC) == 1020) {
                list.add("OPERATOR_20");
                flipped |= 0x3FC;
            }
            if ((o & 0x3FD) == 1021) {
                list.add("OPERATOR_21");
                flipped |= 0x3FD;
            }
            if ((o & 0x3FE) == 1022) {
                list.add("OPERATOR_22");
                flipped |= 0x3FE;
            }
            if ((o & 0x3FF) == 1023) {
                list.add("OPERATOR_23");
                flipped |= 0x3FF;
            }
            if ((o & 0x400) == 1024) {
                list.add("OPERATOR_24");
                flipped |= 0x400;
            }
            if ((o & 0x401) == 1025) {
                list.add("OPERATOR_25");
                flipped |= 0x401;
            }
            if ((o & 0x402) == 1026) {
                list.add("OPERATOR_26");
                flipped |= 0x402;
            }
            if ((o & 0x403) == 1027) {
                list.add("OPERATOR_27");
                flipped |= 0x403;
            }
            if ((o & 0x404) == 1028) {
                list.add("OPERATOR_28");
                flipped |= 0x404;
            }
            if ((o & 0x405) == 1029) {
                list.add("OPERATOR_29");
                flipped |= 0x405;
            }
            if ((o & 0x406) == 1030) {
                list.add("OPERATOR_30");
                flipped |= 0x406;
            }
            if ((o & 0x407) == 1031) {
                list.add("OPERATOR_31");
                flipped |= 0x407;
            }
            if ((o & 0x408) == 1032) {
                list.add("OPERATOR_32");
                flipped |= 0x408;
            }
            if (o != flipped) {
                list.add("0x" + Integer.toHexString(o & ~flipped));
            }
            return String.join((CharSequence)" | ", list);
        }
    }
}

