/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.biometrics.IAuthService;
import android.hardware.biometrics.IBiometricEnabledOnKeyguardCallback;
import android.os.RemoteException;
import android.util.Slog;

public class BiometricManager {
    private static final String TAG = "BiometricManager";
    public static final int BIOMETRIC_SUCCESS = 0;
    public static final int BIOMETRIC_ERROR_HW_UNAVAILABLE = 1;
    public static final int BIOMETRIC_ERROR_NONE_ENROLLED = 11;
    public static final int BIOMETRIC_ERROR_NO_HARDWARE = 12;
    public static final int BIOMETRIC_ERROR_SECURITY_UPDATE_REQUIRED = 15;
    private final Context mContext;
    private final IAuthService mService;

    public BiometricManager(Context context, IAuthService service) {
        this.mContext = context;
        this.mService = service;
    }

    @Deprecated
    @BiometricError
    public int canAuthenticate() {
        return this.canAuthenticate(255);
    }

    @BiometricError
    public int canAuthenticate(@Authenticators.Types int authenticators) {
        return this.canAuthenticate(this.mContext.getUserId(), authenticators);
    }

    @BiometricError
    public int canAuthenticate(int userId, @Authenticators.Types int authenticators) {
        if (this.mService != null) {
            try {
                String opPackageName = this.mContext.getOpPackageName();
                return this.mService.canAuthenticate(opPackageName, userId, authenticators);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "hasEnrolledBiometrics(): Service not connected");
        return 1;
    }

    public boolean hasEnrolledBiometrics(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledBiometrics(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in hasEnrolledBiometrics(): " + e);
                return false;
            }
        }
        return false;
    }

    public void registerEnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback callback) {
        if (this.mService != null) {
            try {
                this.mService.registerEnabledOnKeyguardCallback(callback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "registerEnabledOnKeyguardCallback(): Service not connected");
        }
    }

    public void setActiveUser(int userId) {
        if (this.mService != null) {
            try {
                this.mService.setActiveUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "setActiveUser(): Service not connected");
        }
    }

    public void resetLockout(byte[] token) {
        if (this.mService != null) {
            try {
                this.mService.resetLockout(token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "resetLockout(): Service not connected");
        }
    }

    public long[] getAuthenticatorIds() {
        if (this.mService != null) {
            try {
                return this.mService.getAuthenticatorIds();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "getAuthenticatorIds(): Service not connected");
        return new long[0];
    }

    public static interface Authenticators {
        @SystemApi
        public static final int EMPTY_SET = 0;
        public static final int BIOMETRIC_MAX_STRENGTH = 1;
        public static final int BIOMETRIC_STRONG = 15;
        public static final int BIOMETRIC_WEAK = 255;
        @SystemApi
        public static final int BIOMETRIC_CONVENIENCE = 4095;
        public static final int BIOMETRIC_MIN_STRENGTH = Short.MAX_VALUE;
        public static final int DEVICE_CREDENTIAL = 32768;

        public static @interface Types {
        }
    }

    static @interface BiometricError {
    }
}

