/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ResourcesImpl;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.RenderNode;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Half;
import android.util.Log;
import android.view.ThreadedRenderer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import libcore.util.NativeAllocationRegistry;

public class Bitmap
implements Parcelable {
    private static final String TAG = "Bitmap";
    public static final int DENSITY_NONE = 0;
    private static final long NATIVE_ALLOCATION_SIZE = 32L;
    @UnsupportedAppUsage
    private final long mNativePtr;
    private boolean mRequestPremultiplied;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769491L)
    private byte[] mNinePatchChunk;
    @UnsupportedAppUsage
    private NinePatch.InsetStruct mNinePatchInsets;
    @UnsupportedAppUsage
    private int mWidth;
    @UnsupportedAppUsage
    private int mHeight;
    private boolean mRecycled;
    private ColorSpace mColorSpace;
    public int mDensity = Bitmap.getDefaultDensity();
    private static volatile int sDefaultDensity = -1;
    public static volatile int sPreloadTracingNumInstantiatedBitmaps;
    public static volatile long sPreloadTracingTotalBitmapsSize;
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    public static final Parcelable.Creator<Bitmap> CREATOR;

    @UnsupportedAppUsage
    public static void setDefaultDensity(int density) {
        sDefaultDensity = density;
    }

    @UnsupportedAppUsage
    static int getDefaultDensity() {
        if (sDefaultDensity >= 0) {
            return sDefaultDensity;
        }
        sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    Bitmap(long nativeBitmap, int width, int height, int density, boolean requestPremultiplied, byte[] ninePatchChunk, NinePatch.InsetStruct ninePatchInsets) {
        this(nativeBitmap, width, height, density, requestPremultiplied, ninePatchChunk, ninePatchInsets, true);
    }

    Bitmap(long nativeBitmap, int width, int height, int density, boolean requestPremultiplied, byte[] ninePatchChunk, NinePatch.InsetStruct ninePatchInsets, boolean fromMalloc) {
        if (nativeBitmap == 0L) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mNinePatchChunk = ninePatchChunk;
        this.mNinePatchInsets = ninePatchInsets;
        if (density >= 0) {
            this.mDensity = density;
        }
        this.mNativePtr = nativeBitmap;
        int allocationByteCount = this.getAllocationByteCount();
        NativeAllocationRegistry registry = fromMalloc ? NativeAllocationRegistry.createMalloced(Bitmap.class.getClassLoader(), Bitmap.nativeGetNativeFinalizer(), allocationByteCount) : NativeAllocationRegistry.createNonmalloced(Bitmap.class.getClassLoader(), Bitmap.nativeGetNativeFinalizer(), allocationByteCount);
        registry.registerNativeAllocation(this, nativeBitmap);
        if (ResourcesImpl.TRACE_FOR_DETAILED_PRELOAD) {
            ++sPreloadTracingNumInstantiatedBitmaps;
            long nativeSize = 32L + (long)allocationByteCount;
            sPreloadTracingTotalBitmapsSize += nativeSize;
        }
    }

    public long getNativeInstance() {
        return this.mNativePtr;
    }

    @UnsupportedAppUsage
    void reinit(int width, int height, boolean requestPremultiplied) {
        this.mWidth = width;
        this.mHeight = height;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mColorSpace = null;
    }

    public int getDensity() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getDensity() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mDensity;
    }

    public void setDensity(int density) {
        this.mDensity = density;
    }

    public void reconfigure(int width, int height, Config config) {
        this.checkRecycled("Can't call reconfigure() on a recycled bitmap");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("only mutable bitmaps may be reconfigured");
        }
        Bitmap.nativeReconfigure(this.mNativePtr, width, height, config.nativeInt, this.mRequestPremultiplied);
        this.mWidth = width;
        this.mHeight = height;
        this.mColorSpace = null;
    }

    public void setWidth(int width) {
        this.reconfigure(width, this.getHeight(), this.getConfig());
    }

    public void setHeight(int height) {
        this.reconfigure(this.getWidth(), height, this.getConfig());
    }

    public void setConfig(Config config) {
        this.reconfigure(this.getWidth(), this.getHeight(), config);
    }

    @UnsupportedAppUsage
    public void setNinePatchChunk(byte[] chunk) {
        this.mNinePatchChunk = chunk;
    }

    public void recycle() {
        if (!this.mRecycled) {
            Bitmap.nativeRecycle(this.mNativePtr);
            this.mNinePatchChunk = null;
            this.mRecycled = true;
        }
    }

    public boolean isRecycled() {
        return this.mRecycled;
    }

    public int getGenerationId() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getGenerationId() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeGenerationId(this.mNativePtr);
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private void checkHardware(String errorMessage) {
        if (this.getConfig() == Config.HARDWARE) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static void checkXYSign(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
    }

    private static void checkWidthHeight(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
    }

    public void copyPixelsToBuffer(Buffer dst) {
        int shift;
        this.checkHardware("unable to copyPixelsToBuffer, pixel access is not supported on Config#HARDWARE bitmaps");
        int elements = dst.remaining();
        if (dst instanceof ByteBuffer) {
            shift = 0;
        } else if (dst instanceof ShortBuffer) {
            shift = 1;
        } else if (dst instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferSize = (long)elements << shift;
        long pixelSize = this.getByteCount();
        if (bufferSize < pixelSize) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativePtr, dst);
        int position = dst.position();
        position = (int)((long)position + (pixelSize >> shift));
        dst.position(position);
    }

    public void copyPixelsFromBuffer(Buffer src) {
        int shift;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        this.checkHardware("unable to copyPixelsFromBuffer, Config#HARDWARE bitmaps are immutable");
        int elements = src.remaining();
        if (src instanceof ByteBuffer) {
            shift = 0;
        } else if (src instanceof ShortBuffer) {
            shift = 1;
        } else if (src instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferBytes = (long)elements << shift;
        long bitmapBytes = this.getByteCount();
        if (bufferBytes < bitmapBytes) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativePtr, src);
        int position = src.position();
        position = (int)((long)position + (bitmapBytes >> shift));
        src.position(position);
    }

    private void noteHardwareBitmapSlowCall() {
        if (this.getConfig() == Config.HARDWARE) {
            StrictMode.noteSlowCall("Warning: attempt to read pixels from hardware bitmap, which is very slow operation");
        }
    }

    public Bitmap copy(Config config, boolean isMutable) {
        this.checkRecycled("Can't copy a recycled bitmap");
        if (config == Config.HARDWARE && isMutable) {
            throw new IllegalArgumentException("Hardware bitmaps are always immutable");
        }
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopy(this.mNativePtr, config.nativeInt, isMutable);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    @UnsupportedAppUsage
    public Bitmap createAshmemBitmap() {
        this.checkRecycled("Can't copy a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopyAshmem(this.mNativePtr);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    @UnsupportedAppUsage
    public Bitmap createAshmemBitmap(Config config) {
        this.checkRecycled("Can't copy a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopyAshmemConfig(this.mNativePtr, config.nativeInt);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    public static Bitmap wrapHardwareBuffer(HardwareBuffer hardwareBuffer, ColorSpace colorSpace) {
        if ((hardwareBuffer.getUsage() & 0x100L) == 0L) {
            throw new IllegalArgumentException("usage flags must contain USAGE_GPU_SAMPLED_IMAGE.");
        }
        int format = hardwareBuffer.getFormat();
        if (colorSpace == null) {
            colorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
        }
        return Bitmap.nativeWrapHardwareBufferBitmap(hardwareBuffer, colorSpace.getNativeInstance());
    }

    public static Bitmap wrapHardwareBuffer(GraphicBuffer graphicBuffer, ColorSpace colorSpace) {
        try (HardwareBuffer hb = HardwareBuffer.createFromGraphicBuffer(graphicBuffer);){
            Bitmap bitmap = Bitmap.wrapHardwareBuffer(hb, colorSpace);
            return bitmap;
        }
    }

    public static Bitmap createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        Matrix m = new Matrix();
        int width = src.getWidth();
        int height = src.getHeight();
        if (width != dstWidth || height != dstHeight) {
            float sx = (float)dstWidth / (float)width;
            float sy = (float)dstHeight / (float)height;
            m.setScale(sx, sy);
        }
        return Bitmap.createBitmap(src, 0, 0, width, height, m, filter);
    }

    public static Bitmap createBitmap(Bitmap src) {
        return Bitmap.createBitmap(src, 0, 0, src.getWidth(), src.getHeight());
    }

    public static Bitmap createBitmap(Bitmap source, int x, int y, int width, int height) {
        return Bitmap.createBitmap(source, x, y, width, height, null, false);
    }

    public static Bitmap createBitmap(Bitmap source, int x, int y, int width, int height, Matrix m, boolean filter) {
        Paint paint;
        Bitmap bitmap;
        boolean isHardware;
        Bitmap.checkXYSign(x, y);
        Bitmap.checkWidthHeight(width, height);
        if (x + width > source.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > source.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (source.isRecycled()) {
            throw new IllegalArgumentException("cannot use a recycled source in createBitmap");
        }
        if (!source.isMutable() && x == 0 && y == 0 && width == source.getWidth() && height == source.getHeight() && (m == null || m.isIdentity())) {
            return source;
        }
        boolean bl = isHardware = source.getConfig() == Config.HARDWARE;
        if (isHardware) {
            source.noteHardwareBitmapSlowCall();
            source = Bitmap.nativeCopyPreserveInternalConfig(source.mNativePtr);
        }
        int neww = width;
        int newh = height;
        Rect srcR = new Rect(x, y, x + width, y + height);
        RectF dstR = new RectF(0.0f, 0.0f, width, height);
        RectF deviceR = new RectF();
        Config newConfig = Config.ARGB_8888;
        Config config = source.getConfig();
        if (config != null) {
            switch (config) {
                case RGB_565: {
                    newConfig = Config.RGB_565;
                    break;
                }
                case ALPHA_8: {
                    newConfig = Config.ALPHA_8;
                    break;
                }
                case RGBA_F16: {
                    newConfig = Config.RGBA_F16;
                    break;
                }
                default: {
                    newConfig = Config.ARGB_8888;
                }
            }
        }
        ColorSpace cs = source.getColorSpace();
        if (m == null || m.isIdentity()) {
            bitmap = Bitmap.createBitmap(null, neww, newh, newConfig, source.hasAlpha(), cs);
            paint = null;
        } else {
            boolean transformed = !m.rectStaysRect();
            m.mapRect(deviceR, dstR);
            neww = Math.round(deviceR.width());
            newh = Math.round(deviceR.height());
            Config transformedConfig = newConfig;
            if (transformed && transformedConfig != Config.ARGB_8888 && transformedConfig != Config.RGBA_F16) {
                transformedConfig = Config.ARGB_8888;
                if (cs == null) {
                    cs = ColorSpace.get(ColorSpace.Named.SRGB);
                }
            }
            bitmap = Bitmap.createBitmap(null, neww, newh, transformedConfig, transformed || source.hasAlpha(), cs);
            paint = new Paint();
            paint.setFilterBitmap(filter);
            if (transformed) {
                paint.setAntiAlias(true);
            }
        }
        bitmap.mDensity = source.mDensity;
        bitmap.setHasAlpha(source.hasAlpha());
        bitmap.setPremultiplied(source.mRequestPremultiplied);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(-deviceR.left, -deviceR.top);
        canvas.concat(m);
        canvas.drawBitmap(source, srcR, dstR, paint);
        canvas.setBitmap(null);
        if (isHardware) {
            return bitmap.copy(Config.HARDWARE, false);
        }
        return bitmap;
    }

    public static Bitmap createBitmap(int width, int height, Config config) {
        return Bitmap.createBitmap(width, height, config, true);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int width, int height, Config config) {
        return Bitmap.createBitmap(display, width, height, config, true);
    }

    public static Bitmap createBitmap(int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha);
    }

    public static Bitmap createBitmap(int width, int height, Config config, boolean hasAlpha, ColorSpace colorSpace) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha, colorSpace);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(display, width, height, config, hasAlpha, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public static Bitmap createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha, ColorSpace colorSpace) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (config == Config.HARDWARE) {
            throw new IllegalArgumentException("can't create mutable bitmap with Config.HARDWARE");
        }
        if (colorSpace == null && config != Config.ALPHA_8) {
            throw new IllegalArgumentException("can't create bitmap without a color space");
        }
        Bitmap bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true, colorSpace == null ? 0L : colorSpace.getNativeInstance());
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        bm.setHasAlpha(hasAlpha);
        if (!(config != Config.ARGB_8888 && config != Config.RGBA_F16 || hasAlpha)) {
            Bitmap.nativeErase(bm.mNativePtr, -16777216);
        }
        return bm;
    }

    public static Bitmap createBitmap(int[] colors, int offset, int stride, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, offset, stride, width, height, config);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int[] colors, int offset, int stride, int width, int height, Config config) {
        Bitmap.checkWidthHeight(width, height);
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        ColorSpace sRGB = ColorSpace.get(ColorSpace.Named.SRGB);
        Bitmap bm = Bitmap.nativeCreate(colors, offset, stride, width, height, config.nativeInt, false, sRGB.getNativeInstance());
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        return bm;
    }

    public static Bitmap createBitmap(int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, 0, width, width, height, config);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(display, colors, 0, width, width, height, config);
    }

    public static Bitmap createBitmap(Picture source) {
        return Bitmap.createBitmap(source, source.getWidth(), source.getHeight(), Config.HARDWARE);
    }

    public static Bitmap createBitmap(Picture source, int width, int height, Config config) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width & height must be > 0");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        source.endRecording();
        if (source.requiresHardwareAcceleration() && config != Config.HARDWARE) {
            StrictMode.noteSlowCall("GPU readback");
        }
        if (config == Config.HARDWARE || source.requiresHardwareAcceleration()) {
            RenderNode node = RenderNode.create("BitmapTemporary", null);
            node.setLeftTopRightBottom(0, 0, width, height);
            node.setClipToBounds(false);
            node.setForceDarkAllowed(false);
            RecordingCanvas canvas = node.beginRecording(width, height);
            if (source.getWidth() != width || source.getHeight() != height) {
                canvas.scale((float)width / (float)source.getWidth(), (float)height / (float)source.getHeight());
            }
            canvas.drawPicture(source);
            node.endRecording();
            Bitmap bitmap = ThreadedRenderer.createHardwareBitmap(node, width, height);
            if (config != Config.HARDWARE) {
                bitmap = bitmap.copy(config, false);
            }
            return bitmap;
        }
        Bitmap bitmap = Bitmap.createBitmap(width, height, config);
        Canvas canvas = new Canvas(bitmap);
        if (source.getWidth() != width || source.getHeight() != height) {
            canvas.scale((float)width / (float)source.getWidth(), (float)height / (float)source.getHeight());
        }
        canvas.drawPicture(source);
        canvas.setBitmap(null);
        bitmap.setImmutable();
        return bitmap;
    }

    public byte[] getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    public void getOpticalInsets(Rect outInsets) {
        if (this.mNinePatchInsets == null) {
            outInsets.setEmpty();
        } else {
            outInsets.set(this.mNinePatchInsets.opticalRect);
        }
    }

    public NinePatch.InsetStruct getNinePatchInsets() {
        return this.mNinePatchInsets;
    }

    public boolean compress(CompressFormat format, int quality, OutputStream stream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (stream == null) {
            throw new NullPointerException();
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        StrictMode.noteSlowCall("Compression of a bitmap is slow");
        Trace.traceBegin(8192L, "Bitmap.compress");
        boolean result = Bitmap.nativeCompress(this.mNativePtr, format.nativeInt, quality, stream, new byte[4096]);
        Trace.traceEnd(8192L);
        return result;
    }

    public boolean isMutable() {
        return !Bitmap.nativeIsImmutable(this.mNativePtr);
    }

    public void setImmutable() {
        if (this.isMutable()) {
            Bitmap.nativeSetImmutable(this.mNativePtr);
        }
    }

    public boolean isPremultiplied() {
        if (this.mRecycled) {
            Log.w(TAG, "Called isPremultiplied() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeIsPremultiplied(this.mNativePtr);
    }

    public void setPremultiplied(boolean premultiplied) {
        this.checkRecycled("setPremultiplied called on a recycled bitmap");
        this.mRequestPremultiplied = premultiplied;
        Bitmap.nativeSetPremultiplied(this.mNativePtr, premultiplied);
    }

    public int getWidth() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getWidth() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getHeight() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mHeight;
    }

    public int getScaledWidth(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, canvas.mDensity);
    }

    public int getScaledHeight(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, canvas.mDensity);
    }

    public int getScaledWidth(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, metrics.densityDpi);
    }

    public int getScaledHeight(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, metrics.densityDpi);
    }

    public int getScaledWidth(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, targetDensity);
    }

    public int getScaledHeight(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, targetDensity);
    }

    @UnsupportedAppUsage
    public static int scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || tdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    public int getRowBytes() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getRowBytes() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeRowBytes(this.mNativePtr);
    }

    public int getByteCount() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getByteCount() on a recycle()'d bitmap! This is undefined behavior!");
            return 0;
        }
        return this.getRowBytes() * this.getHeight();
    }

    public int getAllocationByteCount() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getAllocationByteCount() on a recycle()'d bitmap! This is undefined behavior!");
            return 0;
        }
        return Bitmap.nativeGetAllocationByteCount(this.mNativePtr);
    }

    public Config getConfig() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getConfig() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativePtr));
    }

    public boolean hasAlpha() {
        if (this.mRecycled) {
            Log.w(TAG, "Called hasAlpha() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasAlpha(this.mNativePtr);
    }

    public void setHasAlpha(boolean hasAlpha) {
        this.checkRecycled("setHasAlpha called on a recycled bitmap");
        Bitmap.nativeSetHasAlpha(this.mNativePtr, hasAlpha, this.mRequestPremultiplied);
    }

    public boolean hasMipMap() {
        if (this.mRecycled) {
            Log.w(TAG, "Called hasMipMap() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasMipMap(this.mNativePtr);
    }

    public void setHasMipMap(boolean hasMipMap) {
        this.checkRecycled("setHasMipMap called on a recycled bitmap");
        Bitmap.nativeSetHasMipMap(this.mNativePtr, hasMipMap);
    }

    public ColorSpace getColorSpace() {
        this.checkRecycled("getColorSpace called on a recycled bitmap");
        if (this.mColorSpace == null) {
            this.mColorSpace = Bitmap.nativeComputeColorSpace(this.mNativePtr);
        }
        return this.mColorSpace;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.checkRecycled("setColorSpace called on a recycled bitmap");
        if (colorSpace == null) {
            throw new IllegalArgumentException("The colorSpace cannot be set to null");
        }
        if (this.getConfig() == Config.ALPHA_8) {
            throw new IllegalArgumentException("Cannot set a ColorSpace on ALPHA_8");
        }
        ColorSpace oldColorSpace = this.getColorSpace();
        Bitmap.nativeSetColorSpace(this.mNativePtr, colorSpace.getNativeInstance());
        this.mColorSpace = null;
        ColorSpace newColorSpace = this.getColorSpace();
        try {
            if (oldColorSpace.getComponentCount() != newColorSpace.getComponentCount()) {
                throw new IllegalArgumentException("The new ColorSpace must have the same component count as the current ColorSpace");
            }
            for (int i = 0; i < oldColorSpace.getComponentCount(); ++i) {
                if (oldColorSpace.getMinValue(i) < newColorSpace.getMinValue(i)) {
                    throw new IllegalArgumentException("The new ColorSpace cannot increase the minimum value for any of the components compared to the current ColorSpace. To perform this type of conversion create a new Bitmap in the desired ColorSpace and draw this Bitmap into it.");
                }
                if (!(oldColorSpace.getMaxValue(i) > newColorSpace.getMaxValue(i))) continue;
                throw new IllegalArgumentException("The new ColorSpace cannot decrease the maximum value for any of the components compared to the current ColorSpace/ To perform this type of conversion create a new Bitmap in the desired ColorSpace and draw this Bitmap into it.");
            }
        }
        catch (IllegalArgumentException e) {
            this.mColorSpace = oldColorSpace;
            Bitmap.nativeSetColorSpace(this.mNativePtr, this.mColorSpace.getNativeInstance());
            throw e;
        }
    }

    public void eraseColor(int c) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativePtr, c);
    }

    public void eraseColor(long color2) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        ColorSpace cs = Color.colorSpace(color2);
        Bitmap.nativeErase(this.mNativePtr, cs.getNativeInstance(), color2);
    }

    public int getPixel(int x, int y) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkHardware("unable to getPixel(), pixel access is not supported on Config#HARDWARE bitmaps");
        this.checkPixelAccess(x, y);
        return Bitmap.nativeGetPixel(this.mNativePtr, x, y);
    }

    private static float clamp(float value, ColorSpace cs, int index) {
        return Math.max(Math.min(value, cs.getMaxValue(index)), cs.getMinValue(index));
    }

    public Color getColor(int x, int y) {
        this.checkRecycled("Can't call getColor() on a recycled bitmap");
        this.checkHardware("unable to getColor(), pixel access is not supported on Config#HARDWARE bitmaps");
        this.checkPixelAccess(x, y);
        ColorSpace cs = this.getColorSpace();
        if (cs.equals(ColorSpace.get(ColorSpace.Named.SRGB))) {
            return Color.valueOf(Bitmap.nativeGetPixel(this.mNativePtr, x, y));
        }
        long rgba = Bitmap.nativeGetColor(this.mNativePtr, x, y);
        float r = Half.toFloat((short)(rgba >> 0 & 0xFFFFL));
        float g = Half.toFloat((short)(rgba >> 16 & 0xFFFFL));
        float b = Half.toFloat((short)(rgba >> 32 & 0xFFFFL));
        float a = Half.toFloat((short)(rgba >> 48 & 0xFFFFL));
        return Color.valueOf(Bitmap.clamp(r, cs, 0), Bitmap.clamp(g, cs, 1), Bitmap.clamp(b, cs, 2), a, cs);
    }

    public void getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        this.checkHardware("unable to getPixels(), pixel access is not supported on Config#HARDWARE bitmaps");
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeGetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    private void checkPixelAccess(int x, int y) {
        Bitmap.checkXYSign(x, y);
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    private void checkPixelsAccess(int x, int y, int width, int height, int offset, int stride, int[] pixels) {
        Bitmap.checkXYSign(x, y);
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (x + width > this.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > this.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = pixels.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void setPixel(int x, int y, int color2) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(x, y);
        Bitmap.nativeSetPixel(this.mNativePtr, x, y, color2);
    }

    public void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeSetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel p, int flags) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        if (!Bitmap.nativeWriteToParcel(this.mNativePtr, this.mDensity, p)) {
            throw new RuntimeException("native writeToParcel failed");
        }
    }

    public Bitmap extractAlpha() {
        return this.extractAlpha(null, null);
    }

    public Bitmap extractAlpha(Paint paint, int[] offsetXY) {
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        long nativePaint = paint != null ? paint.getNativeInstance() : 0L;
        this.noteHardwareBitmapSlowCall();
        Bitmap bm = Bitmap.nativeExtractAlpha(this.mNativePtr, nativePaint, offsetXY);
        if (bm == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bm.mDensity = this.mDensity;
        return bm;
    }

    public boolean sameAs(Bitmap other) {
        this.checkRecycled("Can't call sameAs on a recycled bitmap!");
        this.noteHardwareBitmapSlowCall();
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        other.noteHardwareBitmapSlowCall();
        if (other.isRecycled()) {
            throw new IllegalArgumentException("Can't compare to a recycled bitmap!");
        }
        return Bitmap.nativeSameAs(this.mNativePtr, other.mNativePtr);
    }

    public void prepareToDraw() {
        this.checkRecycled("Can't prepareToDraw on a recycled bitmap!");
        Bitmap.nativePrepareToDraw(this.mNativePtr);
    }

    @UnsupportedAppUsage
    public GraphicBuffer createGraphicBufferHandle() {
        return GraphicBuffer.createFromHardwareBuffer(this.getHardwareBuffer());
    }

    public HardwareBuffer getHardwareBuffer() {
        return Bitmap.nativeGetHardwareBuffer(this.mNativePtr);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, long l) {
        return Bitmap_Delegate.nativeCreate(nArray, n, n2, n3, n4, n5, bl, l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopy(long l, int n, boolean bl) {
        return Bitmap_Delegate.nativeCopy(l, n, bl);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopyAshmem(long l) {
        return Bitmap_Delegate.nativeCopyAshmem(l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopyAshmemConfig(long l, int n) {
        return Bitmap_Delegate.nativeCopyAshmemConfig(l, n);
    }

    @LayoutlibDelegate
    private static long nativeGetNativeFinalizer() {
        return Bitmap_Delegate.nativeGetNativeFinalizer();
    }

    @LayoutlibDelegate
    private static void nativeRecycle(long l) {
        Bitmap_Delegate.nativeRecycle(l);
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    private static void nativeReconfigure(long l, int n, int n2, int n3, boolean bl) {
        Bitmap_Delegate.nativeReconfigure(l, n, n2, n3, bl);
    }

    @LayoutlibDelegate
    private static boolean nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        return Bitmap_Delegate.nativeCompress(l, n, n2, outputStream, byArray);
    }

    @LayoutlibDelegate
    private static void nativeErase(long l, int n) {
        Bitmap_Delegate.nativeErase(l, n);
    }

    @LayoutlibDelegate
    private static void nativeErase(long l, long l2, long l3) {
        Bitmap_Delegate.nativeErase(l, l2, l3);
    }

    @LayoutlibDelegate
    private static int nativeRowBytes(long l) {
        return Bitmap_Delegate.nativeRowBytes(l);
    }

    @LayoutlibDelegate
    private static int nativeConfig(long l) {
        return Bitmap_Delegate.nativeConfig(l);
    }

    @LayoutlibDelegate
    private static int nativeGetPixel(long l, int n, int n2) {
        return Bitmap_Delegate.nativeGetPixel(l, n, n2);
    }

    @LayoutlibDelegate
    private static long nativeGetColor(long l, int n, int n2) {
        return Bitmap_Delegate.nativeGetColor(l, n, n2);
    }

    @LayoutlibDelegate
    private static void nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Bitmap_Delegate.nativeGetPixels(l, nArray, n, n2, n3, n4, n5, n6);
    }

    @LayoutlibDelegate
    private static void nativeSetPixel(long l, int n, int n2, int n3) {
        Bitmap_Delegate.nativeSetPixel(l, n, n2, n3);
    }

    @LayoutlibDelegate
    private static void nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Bitmap_Delegate.nativeSetPixels(l, nArray, n, n2, n3, n4, n5, n6);
    }

    @LayoutlibDelegate
    private static void nativeCopyPixelsToBuffer(long l, Buffer buffer) {
        Bitmap_Delegate.nativeCopyPixelsToBuffer(l, buffer);
    }

    @LayoutlibDelegate
    private static void nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
        Bitmap_Delegate.nativeCopyPixelsFromBuffer(l, buffer);
    }

    @LayoutlibDelegate
    private static int nativeGenerationId(long l) {
        return Bitmap_Delegate.nativeGenerationId(l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCreateFromParcel(Parcel parcel) {
        return Bitmap_Delegate.nativeCreateFromParcel(parcel);
    }

    @LayoutlibDelegate
    private static boolean nativeWriteToParcel(long l, int n, Parcel parcel) {
        return Bitmap_Delegate.nativeWriteToParcel(l, n, parcel);
    }

    @LayoutlibDelegate
    private static Bitmap nativeExtractAlpha(long l, long l2, int[] nArray) {
        return Bitmap_Delegate.nativeExtractAlpha(l, l2, nArray);
    }

    @LayoutlibDelegate
    private static boolean nativeHasAlpha(long l) {
        return Bitmap_Delegate.nativeHasAlpha(l);
    }

    @LayoutlibDelegate
    private static boolean nativeIsPremultiplied(long l) {
        return Bitmap_Delegate.nativeIsPremultiplied(l);
    }

    @LayoutlibDelegate
    private static void nativeSetPremultiplied(long l, boolean bl) {
        Bitmap_Delegate.nativeSetPremultiplied(l, bl);
    }

    @LayoutlibDelegate
    private static void nativeSetHasAlpha(long l, boolean bl, boolean bl2) {
        Bitmap_Delegate.nativeSetHasAlpha(l, bl, bl2);
    }

    @LayoutlibDelegate
    private static boolean nativeHasMipMap(long l) {
        return Bitmap_Delegate.nativeHasMipMap(l);
    }

    @LayoutlibDelegate
    private static void nativeSetHasMipMap(long l, boolean bl) {
        Bitmap_Delegate.nativeSetHasMipMap(l, bl);
    }

    @LayoutlibDelegate
    private static boolean nativeSameAs(long l, long l2) {
        return Bitmap_Delegate.nativeSameAs(l, l2);
    }

    @LayoutlibDelegate
    private static void nativePrepareToDraw(long l) {
        Bitmap_Delegate.nativePrepareToDraw(l);
    }

    @LayoutlibDelegate
    private static int nativeGetAllocationByteCount(long l) {
        return Bitmap_Delegate.nativeGetAllocationByteCount(l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopyPreserveInternalConfig(long l) {
        return Bitmap_Delegate.nativeCopyPreserveInternalConfig(l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeWrapHardwareBufferBitmap(HardwareBuffer hardwareBuffer, long l) {
        return Bitmap_Delegate.nativeWrapHardwareBufferBitmap(hardwareBuffer, l);
    }

    @LayoutlibDelegate
    private static HardwareBuffer nativeGetHardwareBuffer(long l) {
        return Bitmap_Delegate.nativeGetHardwareBuffer(l);
    }

    @LayoutlibDelegate
    private static ColorSpace nativeComputeColorSpace(long l) {
        return Bitmap_Delegate.nativeComputeColorSpace(l);
    }

    @LayoutlibDelegate
    private static void nativeSetColorSpace(long l, long l2) {
        Bitmap_Delegate.nativeSetColorSpace(l, l2);
    }

    @LayoutlibDelegate
    private static boolean nativeIsSRGB(long l) {
        return Bitmap_Delegate.nativeIsSRGB(l);
    }

    @LayoutlibDelegate
    private static boolean nativeIsSRGBLinear(long l) {
        return Bitmap_Delegate.nativeIsSRGBLinear(l);
    }

    @LayoutlibDelegate
    private static void nativeSetImmutable(long l) {
        Bitmap_Delegate.nativeSetImmutable(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nativeIsImmutable(long l) {
        return Bitmap_Delegate.nativeIsImmutable(l);
    }

    static {
        CREATOR = new Parcelable.Creator<Bitmap>(){

            @Override
            public Bitmap createFromParcel(Parcel p) {
                Bitmap bm = Bitmap.nativeCreateFromParcel(p);
                if (bm == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bm;
            }

            public Bitmap[] newArray(int size) {
                return new Bitmap[size];
            }
        };
    }

    public static enum CompressFormat {
        JPEG(0),
        PNG(1),
        WEBP(2),
        WEBP_LOSSY(3),
        WEBP_LOSSLESS(4);

        final int nativeInt;

        private CompressFormat(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Config {
        ALPHA_8(1),
        RGB_565(3),
        ARGB_4444(4),
        ARGB_8888(5),
        RGBA_F16(6),
        HARDWARE(7);

        @UnsupportedAppUsage
        final int nativeInt;
        private static Config[] sConfigs;

        private Config(int ni) {
            this.nativeInt = ni;
        }

        @UnsupportedAppUsage
        static Config nativeToConfig(int ni) {
            return sConfigs[ni];
        }

        static {
            sConfigs = new Config[]{null, ALPHA_8, null, RGB_565, ARGB_4444, ARGB_8888, RGBA_F16, HARDWARE};
        }
    }
}

