/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.content.pm.PackageParser;
import android.content.pm.VerifierInfo;
import android.content.pm.parsing.ParsingPackageUtils;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.ApkAssets;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ApkLiteParseUtils {
    private static final String TAG = "PackageParsing";
    private static final int DEFAULT_MIN_SDK_VERSION = 1;
    private static final int DEFAULT_TARGET_SDK_VERSION = 0;
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;

    public static ParseResult<PackageParser.PackageLite> parsePackageLite(ParseInput input, File packageFile, int flags) {
        if (packageFile.isDirectory()) {
            return ApkLiteParseUtils.parseClusterPackageLite(input, packageFile, flags);
        }
        return ApkLiteParseUtils.parseMonolithicPackageLite(input, packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageParser.PackageLite> parseMonolithicPackageLite(ParseInput input, File packageFile, int flags) {
        Trace.traceBegin(262144L, "parseApkLite");
        try {
            ParseResult<PackageParser.ApkLite> result = ApkLiteParseUtils.parseApkLite(input, packageFile, flags);
            if (result.isError()) {
                ParseResult<PackageParser.PackageLite> parseResult = input.error(result);
                return parseResult;
            }
            PackageParser.ApkLite baseApk = result.getResult();
            String packagePath = packageFile.getAbsolutePath();
            ParseResult<PackageParser.PackageLite> parseResult = input.success(new PackageParser.PackageLite(packagePath, baseApk, null, null, null, null, null, null));
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageParser.PackageLite> parseClusterPackageLite(ParseInput input, File packageDir, int flags) {
        File[] files = packageDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            return input.error(-100, "No packages found in split");
        }
        if (files.length == 1 && files[0].isDirectory()) {
            return ApkLiteParseUtils.parseClusterPackageLite(input, files[0], flags);
        }
        String packageName = null;
        int versionCode = 0;
        ArrayMap<String, PackageParser.ApkLite> apks = new ArrayMap<String, PackageParser.ApkLite>();
        Trace.traceBegin(262144L, "parseApkLite");
        try {
            for (File file : files) {
                if (!PackageParser.isApkFile(file)) continue;
                ParseResult<PackageParser.ApkLite> result = ApkLiteParseUtils.parseApkLite(input, file, flags);
                if (result.isError()) {
                    ParseResult<PackageParser.PackageLite> parseResult = input.error(result);
                    return parseResult;
                }
                PackageParser.ApkLite lite = result.getResult();
                if (packageName == null) {
                    packageName = lite.packageName;
                    versionCode = lite.versionCode;
                } else {
                    if (!packageName.equals(lite.packageName)) {
                        ParseResult<PackageParser.PackageLite> parseResult = input.error(-101, "Inconsistent package " + lite.packageName + " in " + file + "; expected " + packageName);
                        return parseResult;
                    }
                    if (versionCode != lite.versionCode) {
                        ParseResult<PackageParser.PackageLite> parseResult = input.error(-101, "Inconsistent version " + lite.versionCode + " in " + file + "; expected " + versionCode);
                        return parseResult;
                    }
                }
                if (apks.put(lite.splitName, lite) == null) continue;
                ParseResult<PackageParser.PackageLite> parseResult = input.error(-101, "Split name " + lite.splitName + " defined more than once; most recent was " + file);
                return parseResult;
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
        PackageParser.ApkLite baseApk = (PackageParser.ApkLite)apks.remove(null);
        if (baseApk == null) {
            return input.error(-101, "Missing base APK in " + packageDir);
        }
        int size = apks.size();
        String[] splitNames = null;
        boolean[] isFeatureSplits = null;
        String[] usesSplitNames = null;
        String[] configForSplits = null;
        String[] splitCodePaths = null;
        int[] splitRevisionCodes = null;
        if (size > 0) {
            splitNames = new String[size];
            isFeatureSplits = new boolean[size];
            usesSplitNames = new String[size];
            configForSplits = new String[size];
            splitCodePaths = new String[size];
            splitRevisionCodes = new int[size];
            splitNames = apks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, PackageParser.sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                PackageParser.ApkLite apk = (PackageParser.ApkLite)apks.get(splitNames[i]);
                usesSplitNames[i] = apk.usesSplitName;
                isFeatureSplits[i] = apk.isFeatureSplit;
                configForSplits[i] = apk.configForSplit;
                splitCodePaths[i] = apk.codePath;
                splitRevisionCodes[i] = apk.revisionCode;
            }
        }
        String codePath = packageDir.getAbsolutePath();
        return input.success(new PackageParser.PackageLite(codePath, baseApk, splitNames, isFeatureSplits, usesSplitNames, configForSplits, splitCodePaths, splitRevisionCodes));
    }

    public static ParseResult<PackageParser.ApkLite> parseApkLite(ParseInput input, File apkFile, int flags) {
        return ApkLiteParseUtils.parseApkLiteInner(input, apkFile, null, null, flags);
    }

    public static ParseResult<PackageParser.ApkLite> parseApkLite(ParseInput input, FileDescriptor fd, String debugPathName, int flags) {
        return ApkLiteParseUtils.parseApkLiteInner(input, null, fd, debugPathName, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static ParseResult<PackageParser.ApkLite> parseApkLiteInner(ParseInput input, File apkFile, FileDescriptor fd, String debugPathName, int flags) {
        block27: {
            apkPath = fd != null ? debugPathName : apkFile.getAbsolutePath();
            parser = null;
            apkAssets = null;
            try {
                apkAssets = fd != null ? ApkAssets.loadFromFd(fd, debugPathName, 0, null) : ApkAssets.loadFromPath(apkPath);
            }
            catch (IOException e) {
                var9_11 = input.error(-100, "Failed to parse " + apkPath, e);
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable var10_15) {
                        // empty catch block
                    }
                }
                return var9_11;
            }
            parser = apkAssets.openXml("AndroidManifest.xml");
            if ((flags & 32) == 0) ** GOTO lbl46
            skipVerify = (flags & 16) != 0;
            Trace.traceBegin(262144L, "collectCertificates");
            result = ParsingPackageUtils.getSigningDetails(input, apkFile.getAbsolutePath(), skipVerify, false, PackageParser.SigningDetails.UNKNOWN, 0);
            if (!result.isError()) break block27;
            var11_18 = input.error(result);
            Trace.traceEnd(262144L);
            IoUtils.closeQuietly(parser);
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable var12_20) {
                    // empty catch block
                }
            }
            return var11_18;
        }
        try {
            signingDetails = result.getResult();
            {
                catch (Throwable var13_21) {
                    throw var13_21;
                }
            }
            finally {
                Trace.traceEnd(262144L);
            }
lbl46:
            // 1 sources

            signingDetails = PackageParser.SigningDetails.UNKNOWN;
            attrs = parser;
            var10_16 = ApkLiteParseUtils.parseApkLite(input, apkPath, parser, attrs, signingDetails);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                Slog.w("PackageParsing", "Failed to parse " + apkPath, e);
                var9_14 = input.error(-102, "Failed to parse " + apkPath, (Exception)e);
            }
            catch (Throwable var14_22) {
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable var15_23) {
                        // empty catch block
                    }
                }
                throw var14_22;
            }
            IoUtils.closeQuietly(parser);
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable var10_17) {
                    // empty catch block
                }
            }
            return var9_14;
        }
        IoUtils.closeQuietly(parser);
        if (apkAssets != null) {
            try {
                apkAssets.close();
            }
            catch (Throwable var11_19) {
                // empty catch block
            }
        }
        return var10_16;
    }

    private static ParseResult<PackageParser.ApkLite> parseApkLite(ParseInput input, String codePath, XmlPullParser parser, AttributeSet attrs, PackageParser.SigningDetails signingDetails) throws IOException, XmlPullParserException {
        int type;
        ParseResult<Pair<String, String>> result = ApkLiteParseUtils.parsePackageSplitNames(input, parser, attrs);
        if (result.isError()) {
            return input.error(result);
        }
        Pair<String, String> packageSplit = result.getResult();
        int installLocation = -1;
        int versionCode = 0;
        int versionCodeMajor = 0;
        int targetSdkVersion = 0;
        int minSdkVersion = 1;
        int revisionCode = 0;
        boolean coreApp = false;
        boolean debuggable = false;
        boolean profilableByShell = false;
        boolean multiArch = false;
        boolean use32bitAbi = false;
        boolean extractNativeLibs = true;
        boolean isolatedSplits = false;
        boolean isFeatureSplit = false;
        boolean isSplitRequired = false;
        boolean useEmbeddedDex = false;
        String configForSplit = null;
        String usesSplitName = null;
        String targetPackage = null;
        boolean overlayIsStatic = false;
        int overlayPriority = 0;
        String requiredSystemPropertyName = null;
        String requiredSystemPropertyValue = null;
        block36: for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            String attr2;
            switch (attr2 = attrs.getAttributeName(i)) {
                case "installLocation": {
                    installLocation = attrs.getAttributeIntValue(i, -1);
                    continue block36;
                }
                case "versionCode": {
                    versionCode = attrs.getAttributeIntValue(i, 0);
                    continue block36;
                }
                case "versionCodeMajor": {
                    versionCodeMajor = attrs.getAttributeIntValue(i, 0);
                    continue block36;
                }
                case "revisionCode": {
                    revisionCode = attrs.getAttributeIntValue(i, 0);
                    continue block36;
                }
                case "coreApp": {
                    coreApp = attrs.getAttributeBooleanValue(i, false);
                    continue block36;
                }
                case "isolatedSplits": {
                    isolatedSplits = attrs.getAttributeBooleanValue(i, false);
                    continue block36;
                }
                case "configForSplit": {
                    configForSplit = attrs.getAttributeValue(i);
                    continue block36;
                }
                case "isFeatureSplit": {
                    isFeatureSplit = attrs.getAttributeBooleanValue(i, false);
                    continue block36;
                }
                case "isSplitRequired": {
                    isSplitRequired = attrs.getAttributeBooleanValue(i, false);
                }
            }
        }
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            String attr3;
            if (type == 3 || type == 4 || parser.getDepth() != searchDepth) continue;
            if ("package-verifier".equals(parser.getName())) {
                VerifierInfo verifier = ApkLiteParseUtils.parseVerifier(attrs);
                if (verifier == null) continue;
                verifiers.add(verifier);
                continue;
            }
            if ("application".equals(parser.getName())) {
                block38: for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                    switch (attr3 = attrs.getAttributeName(i)) {
                        case "debuggable": {
                            debuggable = attrs.getAttributeBooleanValue(i, false);
                            if (!debuggable) continue block38;
                            profilableByShell = true;
                            continue block38;
                        }
                        case "multiArch": {
                            multiArch = attrs.getAttributeBooleanValue(i, false);
                            continue block38;
                        }
                        case "use32bitAbi": {
                            use32bitAbi = attrs.getAttributeBooleanValue(i, false);
                            continue block38;
                        }
                        case "extractNativeLibs": {
                            extractNativeLibs = attrs.getAttributeBooleanValue(i, true);
                            continue block38;
                        }
                        case "useEmbeddedDex": {
                            useEmbeddedDex = attrs.getAttributeBooleanValue(i, false);
                        }
                    }
                }
                continue;
            }
            if ("overlay".equals(parser.getName())) {
                for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                    attr3 = attrs.getAttributeName(i);
                    if ("requiredSystemPropertyName".equals(attr3)) {
                        requiredSystemPropertyName = attrs.getAttributeValue(i);
                        continue;
                    }
                    if ("requiredSystemPropertyValue".equals(attr3)) {
                        requiredSystemPropertyValue = attrs.getAttributeValue(i);
                        continue;
                    }
                    if ("targetPackage".equals(attr3)) {
                        targetPackage = attrs.getAttributeValue(i);
                        continue;
                    }
                    if ("isStatic".equals(attr3)) {
                        overlayIsStatic = attrs.getAttributeBooleanValue(i, false);
                        continue;
                    }
                    if (!"priority".equals(attr3)) continue;
                    overlayPriority = attrs.getAttributeIntValue(i, 0);
                }
                continue;
            }
            if ("uses-split".equals(parser.getName())) {
                if (usesSplitName != null) {
                    Slog.w(TAG, "Only one <uses-split> permitted. Ignoring others.");
                    continue;
                }
                usesSplitName = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (usesSplitName != null) continue;
                return input.error(-108, "<uses-split> tag requires 'android:name' attribute");
            }
            if ("uses-sdk".equals(parser.getName())) {
                for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                    attr3 = attrs.getAttributeName(i);
                    if ("targetSdkVersion".equals(attr3)) {
                        targetSdkVersion = attrs.getAttributeIntValue(i, 0);
                    }
                    if (!"minSdkVersion".equals(attr3)) continue;
                    minSdkVersion = attrs.getAttributeIntValue(i, 1);
                }
                continue;
            }
            if (!"profileable".equals(parser.getName())) continue;
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                attr3 = attrs.getAttributeName(i);
                if (!"shell".equals(attr3)) continue;
                profilableByShell = attrs.getAttributeBooleanValue(i, profilableByShell);
            }
        }
        if (!PackageParser.checkRequiredSystemProperties(requiredSystemPropertyName, requiredSystemPropertyValue)) {
            Slog.i(TAG, "Skipping target and overlay pair " + targetPackage + " and " + codePath + ": overlay ignored due to required system property: " + requiredSystemPropertyName + " with value: " + requiredSystemPropertyValue);
            targetPackage = null;
            overlayIsStatic = false;
            overlayPriority = 0;
        }
        return input.success(new PackageParser.ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, isFeatureSplit, configForSplit, usesSplitName, isSplitRequired, versionCode, versionCodeMajor, revisionCode, installLocation, verifiers, signingDetails, coreApp, debuggable, profilableByShell, multiArch, use32bitAbi, useEmbeddedDex, extractNativeLibs, isolatedSplits, targetPackage, overlayIsStatic, overlayPriority, minSdkVersion, targetSdkVersion));
    }

    public static ParseResult<Pair<String, String>> parsePackageSplitNames(ParseInput input, XmlPullParser parser, AttributeSet attrs) throws IOException, XmlPullParserException {
        String error;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            return input.error(-108, "No start tag found");
        }
        if (!parser.getName().equals("manifest")) {
            return input.error(-108, "No <manifest> tag");
        }
        String packageName = attrs.getAttributeValue(null, "package");
        if (!"android".equals(packageName) && (error = PackageParser.validateName(packageName, true, true)) != null) {
            return input.error(-106, "Invalid manifest package: " + error);
        }
        String splitName = attrs.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                String error2 = PackageParser.validateName(splitName, false, false);
                if (error2 != null) {
                    return input.error(-106, "Invalid manifest split: " + error2);
                }
            }
        }
        return input.success(Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName));
    }

    public static VerifierInfo parseVerifier(AttributeSet attrs) {
        String packageName = null;
        String encodedPublicKey = null;
        int attrCount = attrs.getAttributeCount();
        block4: for (int i = 0; i < attrCount; ++i) {
            int attrResId = attrs.getAttributeNameResource(i);
            switch (attrResId) {
                case 0x1010003: {
                    packageName = attrs.getAttributeValue(i);
                    continue block4;
                }
                case 16843686: {
                    encodedPublicKey = attrs.getAttributeValue(i);
                }
            }
        }
        if (packageName == null || packageName.length() == 0) {
            Slog.i(TAG, "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i(TAG, "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }
}

