/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ParcelableException;
import java.util.Objects;

public class ContentProviderResult
implements Parcelable {
    public final Uri uri;
    public final Integer count;
    public final Bundle extras;
    public final Throwable exception;
    public static final Parcelable.Creator<ContentProviderResult> CREATOR = new Parcelable.Creator<ContentProviderResult>(){

        @Override
        public ContentProviderResult createFromParcel(Parcel source) {
            return new ContentProviderResult(source);
        }

        public ContentProviderResult[] newArray(int size) {
            return new ContentProviderResult[size];
        }
    };

    public ContentProviderResult(Uri uri) {
        this(Objects.requireNonNull(uri), null, null, null);
    }

    public ContentProviderResult(int count) {
        this(null, count, null, null);
    }

    public ContentProviderResult(Bundle extras) {
        this(null, null, Objects.requireNonNull(extras), null);
    }

    public ContentProviderResult(Throwable exception) {
        this(null, null, null, exception);
    }

    public ContentProviderResult(Uri uri, Integer count, Bundle extras, Throwable exception) {
        this.uri = uri;
        this.count = count;
        this.extras = extras;
        this.exception = exception;
    }

    public ContentProviderResult(Parcel source) {
        this.uri = source.readInt() != 0 ? Uri.CREATOR.createFromParcel(source) : null;
        this.count = source.readInt() != 0 ? Integer.valueOf(source.readInt()) : null;
        this.extras = source.readInt() != 0 ? source.readBundle() : null;
        this.exception = source.readInt() != 0 ? ParcelableException.readFromParcel(source) : null;
    }

    public ContentProviderResult(ContentProviderResult cpr, int userId) {
        this.uri = ContentProvider.maybeAddUserId(cpr.uri, userId);
        this.count = cpr.count;
        this.extras = cpr.extras;
        this.exception = cpr.exception;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.uri != null) {
            dest.writeInt(1);
            this.uri.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.count != null) {
            dest.writeInt(1);
            dest.writeInt(this.count);
        } else {
            dest.writeInt(0);
        }
        if (this.extras != null) {
            dest.writeInt(1);
            dest.writeBundle(this.extras);
        } else {
            dest.writeInt(0);
        }
        if (this.exception != null) {
            dest.writeInt(1);
            ParcelableException.writeToParcel(dest, this.exception);
        } else {
            dest.writeInt(0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContentProviderResult(");
        if (this.uri != null) {
            sb.append("uri=" + this.uri + " ");
        }
        if (this.count != null) {
            sb.append("count=" + this.count + " ");
        }
        if (this.extras != null) {
            sb.append("extras=" + this.extras + " ");
        }
        if (this.exception != null) {
            sb.append("exception=" + this.exception + " ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }
}

