/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentProviderOperation;
import android.content.ContentProviderProxy;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorDescriptor;
import android.database.Cursor;
import android.database.CursorToBulkCursorAdaptor;
import android.database.DatabaseUtils;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import java.util.ArrayList;

public abstract class ContentProviderNative
extends Binder
implements IContentProvider {
    public ContentProviderNative() {
        this.attachInterface(this, "android.content.IContentProvider");
    }

    @UnsupportedAppUsage
    public static IContentProvider asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IContentProvider in = (IContentProvider)obj.queryLocalInterface("android.content.IContentProvider");
        if (in != null) {
            return in;
        }
        return new ContentProviderProxy(obj);
    }

    public abstract String getProviderName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            switch (code) {
                case 1: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String callingFeatureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    int num = data.readInt();
                    String[] projection = null;
                    if (num > 0) {
                        projection = new String[num];
                        for (int i = 0; i < num; ++i) {
                            projection[i] = data.readString();
                        }
                    }
                    Bundle queryArgs = data.readBundle();
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    ICancellationSignal cancellationSignal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    Cursor cursor = this.query(callingPkg, callingFeatureId, url, projection, queryArgs, cancellationSignal);
                    if (cursor != null) {
                        CursorToBulkCursorAdaptor adaptor = null;
                        try {
                            adaptor = new CursorToBulkCursorAdaptor(cursor, observer, this.getProviderName());
                            cursor = null;
                            BulkCursorDescriptor d = adaptor.getBulkCursorDescriptor();
                            adaptor = null;
                            reply.writeNoException();
                            reply.writeInt(1);
                            d.writeToParcel(reply, 1);
                        }
                        finally {
                            if (adaptor != null) {
                                adaptor.close();
                            }
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                    } else {
                        reply.writeNoException();
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.content.IContentProvider");
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String type = this.getType(url);
                    reply.writeNoException();
                    reply.writeString(type);
                    return true;
                }
                case 29: {
                    data.enforceInterface("android.content.IContentProvider");
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    RemoteCallback callback = RemoteCallback.CREATOR.createFromParcel(data);
                    this.getTypeAsync(url, callback);
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    ContentValues values = ContentValues.CREATOR.createFromParcel(data);
                    Bundle extras = data.readBundle();
                    Uri out = this.insert(callingPkg, featureId, url, values, extras);
                    reply.writeNoException();
                    Uri.writeToParcel(reply, out);
                    return true;
                }
                case 13: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    ContentValues[] values = data.createTypedArray(ContentValues.CREATOR);
                    int count = this.bulkInsert(callingPkg, featureId, url, values);
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 20: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    String authority = data.readString();
                    int numOperations = data.readInt();
                    ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>(numOperations);
                    for (int i = 0; i < numOperations; ++i) {
                        operations.add(i, ContentProviderOperation.CREATOR.createFromParcel(data));
                    }
                    Parcelable[] results = this.applyBatch(callingPkg, featureId, authority, operations);
                    reply.writeNoException();
                    reply.writeTypedArray(results, 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    Bundle extras = data.readBundle();
                    int count = this.delete(callingPkg, featureId, url, extras);
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    ContentValues values = ContentValues.CREATOR.createFromParcel(data);
                    Bundle extras = data.readBundle();
                    int count = this.update(callingPkg, featureId, url, values, extras);
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 14: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mode = data.readString();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    IBinder callerToken = data.readStrongBinder();
                    ParcelFileDescriptor fd = this.openFile(callingPkg, featureId, url, mode, signal, callerToken);
                    reply.writeNoException();
                    if (fd != null) {
                        reply.writeInt(1);
                        fd.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mode = data.readString();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    AssetFileDescriptor fd = this.openAssetFile(callingPkg, featureId, url, mode, signal);
                    reply.writeNoException();
                    if (fd != null) {
                        reply.writeInt(1);
                        fd.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    String authority = data.readString();
                    String method = data.readString();
                    String stringArg = data.readString();
                    Bundle extras = data.readBundle();
                    Bundle responseBundle = this.call(callingPkg, featureId, authority, method, stringArg, extras);
                    reply.writeNoException();
                    reply.writeBundle(responseBundle);
                    return true;
                }
                case 22: {
                    data.enforceInterface("android.content.IContentProvider");
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mimeTypeFilter = data.readString();
                    String[] types = this.getStreamTypes(url, mimeTypeFilter);
                    reply.writeNoException();
                    reply.writeStringArray(types);
                    return true;
                }
                case 23: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mimeType = data.readString();
                    Bundle opts = data.readBundle();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    AssetFileDescriptor fd = this.openTypedAssetFile(callingPkg, featureId, url, mimeType, opts, signal);
                    reply.writeNoException();
                    if (fd != null) {
                        reply.writeInt(1);
                        fd.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface("android.content.IContentProvider");
                    ICancellationSignal cancellationSignal = this.createCancellationSignal();
                    reply.writeNoException();
                    reply.writeStrongBinder(cancellationSignal.asBinder());
                    return true;
                }
                case 25: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    Uri out = this.canonicalize(callingPkg, featureId, url);
                    reply.writeNoException();
                    Uri.writeToParcel(reply, out);
                    return true;
                }
                case 30: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri uri = Uri.CREATOR.createFromParcel(data);
                    RemoteCallback callback = RemoteCallback.CREATOR.createFromParcel(data);
                    this.canonicalizeAsync(callingPkg, featureId, uri, callback);
                    return true;
                }
                case 26: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    Uri out = this.uncanonicalize(callingPkg, featureId, url);
                    reply.writeNoException();
                    Uri.writeToParcel(reply, out);
                    return true;
                }
                case 27: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    Bundle extras = data.readBundle();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    boolean out = this.refresh(callingPkg, featureId, url, extras, signal);
                    reply.writeNoException();
                    reply.writeInt(out ? 0 : -1);
                    return true;
                }
                case 28: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String featureId = data.readString();
                    Uri uri = Uri.CREATOR.createFromParcel(data);
                    int uid = data.readInt();
                    int modeFlags = data.readInt();
                    int out = this.checkUriPermission(callingPkg, featureId, uri, uid, modeFlags);
                    reply.writeNoException();
                    reply.writeInt(out);
                    return true;
                }
            }
        }
        catch (Exception e) {
            DatabaseUtils.writeExceptionToParcel(reply, e);
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    @Override
    public IBinder asBinder() {
        return this;
    }
}

