/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ShortcutInfo;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.VirtualDisplay;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.IWindow;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.window.TaskEmbedder;
import android.window.TaskOrganizerTaskEmbedder;
import android.window.VirtualDisplayTaskEmbedder;
import dalvik.system.CloseGuard;

public class ActivityView
extends ViewGroup
implements TaskEmbedder.Host {
    private static final String TAG = "ActivityView";
    private TaskEmbedder mTaskEmbedder;
    private final SurfaceView mSurfaceView;
    private final SurfaceCallback mSurfaceCallback;
    private final CloseGuard mGuard = CloseGuard.get();
    private boolean mOpened;
    private final SurfaceControl.Transaction mTmpTransaction = new SurfaceControl.Transaction();
    private final Point mWindowPosition = new Point();
    private final int[] mTmpArray = new int[2];
    private final Rect mTmpRect = new Rect();
    private final Matrix mScreenSurfaceMatrix = new Matrix();
    private final Region mTapExcludeRegion = new Region();

    public ActivityView(Context context) {
        this(context, null);
    }

    public ActivityView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, false);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle, boolean singleTaskInstance) {
        this(context, attrs, defStyle, singleTaskInstance, false);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle, boolean singleTaskInstance, boolean usePublicVirtualDisplay) {
        this(context, attrs, defStyle, singleTaskInstance, usePublicVirtualDisplay, false);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle, boolean singleTaskInstance, boolean usePublicVirtualDisplay, boolean disableSurfaceViewBackgroundLayer) {
        this(context, attrs, defStyle, singleTaskInstance, usePublicVirtualDisplay, disableSurfaceViewBackgroundLayer, false);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle, boolean singleTaskInstance, boolean usePublicVirtualDisplay, boolean disableSurfaceViewBackgroundLayer, boolean useTrustedDisplay) {
        super(context, attrs, defStyle);
        this.mTaskEmbedder = this.useTaskOrganizer() ? new TaskOrganizerTaskEmbedder(context, this) : new VirtualDisplayTaskEmbedder(context, this, singleTaskInstance, usePublicVirtualDisplay, useTrustedDisplay);
        this.mSurfaceView = new SurfaceView(context, null, 0, 0, disableSurfaceViewBackgroundLayer);
        this.mSurfaceView.setAlpha(super.getAlpha());
        this.mSurfaceView.setUseAlpha();
        this.mSurfaceCallback = new SurfaceCallback();
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        this.addView(this.mSurfaceView);
        this.mOpened = true;
        this.mGuard.open("release");
    }

    public void setCallback(StateCallback callback) {
        if (callback == null) {
            this.mTaskEmbedder.setListener(null);
            return;
        }
        this.mTaskEmbedder.setListener(new StateCallbackAdapter(callback));
    }

    public void setCornerRadius(float cornerRadius) {
        this.mSurfaceView.setCornerRadius(cornerRadius);
    }

    public float getCornerRadius() {
        return this.mSurfaceView.getCornerRadius();
    }

    public void setSurfaceClippingEnabled(boolean clippingEnabled) {
        this.mSurfaceView.setEnableSurfaceClipping(clippingEnabled);
    }

    public void setSurfaceClipBounds(Rect clipBounds) {
        this.mSurfaceView.setClipBounds(clipBounds);
    }

    public boolean getSurfaceClipBounds(Rect outRect) {
        return this.mSurfaceView.getClipBounds(outRect);
    }

    public void startShortcutActivity(ShortcutInfo shortcut, ActivityOptions options, Rect sourceBounds) {
        this.mTaskEmbedder.startShortcutActivity(shortcut, options, sourceBounds);
    }

    public void startActivity(Intent intent) {
        this.mTaskEmbedder.startActivity(intent);
    }

    public void startActivity(Intent intent, UserHandle user) {
        this.mTaskEmbedder.startActivity(intent, user);
    }

    public void startActivity(PendingIntent pendingIntent) {
        this.mTaskEmbedder.startActivity(pendingIntent);
    }

    public void startActivity(PendingIntent pendingIntent, Intent fillInIntent, ActivityOptions options) {
        this.mTaskEmbedder.startActivity(pendingIntent, fillInIntent, options);
    }

    public void release() {
        this.performRelease();
    }

    public void onLocationChanged() {
        this.mTaskEmbedder.notifyBoundsChanged();
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mSurfaceView.layout(0, 0, r - l, b - t);
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setAlpha(alpha);
        }
    }

    @Override
    public float getAlpha() {
        return this.mSurfaceView.getAlpha();
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return this.mTaskEmbedder.gatherTransparentRegion(region) || super.gatherTransparentRegion(region);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mSurfaceView.setVisibility(visibility);
    }

    public int getVirtualDisplayId() {
        return this.mTaskEmbedder.getDisplayId();
    }

    public VirtualDisplay getVirtualDisplay() {
        return this.mTaskEmbedder.getVirtualDisplay();
    }

    public void performBackPress() {
        this.mTaskEmbedder.performBackPress();
    }

    private boolean initTaskEmbedder(SurfaceControl parent) {
        if (!this.mTaskEmbedder.initialize(parent)) {
            Log.e(TAG, "Failed to initialize ActivityView");
            return false;
        }
        return true;
    }

    private void performRelease() {
        if (!this.mOpened) {
            return;
        }
        this.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        if (this.mTaskEmbedder.isInitialized()) {
            this.mTaskEmbedder.release();
        }
        this.mTaskEmbedder.setListener(null);
        this.mGuard.close();
        this.mOpened = false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
                this.performRelease();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setForwardedInsets(Insets insets) {
        this.mTaskEmbedder.setForwardedInsets(insets);
    }

    @Override
    public void onTaskBackgroundColorChanged(TaskEmbedder ts, int bgColor) {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setResizeBackgroundColor(bgColor);
        }
    }

    @Override
    public Region getTapExcludeRegion() {
        if (this.isAttachedToWindow() && this.canReceivePointerEvents()) {
            Point windowPos = this.getPositionInWindow();
            this.mTapExcludeRegion.set(windowPos.x, windowPos.y, windowPos.x + this.getWidth(), windowPos.y + this.getHeight());
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.subtractObscuredTouchableRegion(this.mTapExcludeRegion, this);
            }
        } else {
            this.mTapExcludeRegion.setEmpty();
        }
        return this.mTapExcludeRegion;
    }

    @Override
    public Matrix getScreenToTaskMatrix() {
        this.getLocationOnScreen(this.mTmpArray);
        this.mScreenSurfaceMatrix.set(this.getMatrix());
        this.mScreenSurfaceMatrix.postTranslate(this.mTmpArray[0], this.mTmpArray[1]);
        return this.mScreenSurfaceMatrix;
    }

    @Override
    public Point getPositionInWindow() {
        this.getLocationInWindow(this.mTmpArray);
        this.mWindowPosition.set(this.mTmpArray[0], this.mTmpArray[1]);
        return this.mWindowPosition;
    }

    @Override
    public Rect getScreenBounds() {
        this.getBoundsOnScreen(this.mTmpRect);
        return this.mTmpRect;
    }

    @Override
    public IWindow getWindow() {
        return super.getWindow();
    }

    @Override
    public boolean canReceivePointerEvents() {
        return super.canReceivePointerEvents();
    }

    protected boolean useTaskOrganizer() {
        return false;
    }

    private class StateCallbackAdapter
    implements TaskEmbedder.Listener {
        private final StateCallback mCallback;

        private StateCallbackAdapter(StateCallback cb) {
            this.mCallback = cb;
        }

        @Override
        public void onInitialized() {
            this.mCallback.onActivityViewReady(ActivityView.this);
        }

        @Override
        public void onReleased() {
            this.mCallback.onActivityViewDestroyed(ActivityView.this);
        }

        @Override
        public void onTaskCreated(int taskId, ComponentName name) {
            this.mCallback.onTaskCreated(taskId, name);
        }

        @Override
        public void onTaskVisibilityChanged(int taskId, boolean visible) {
            this.mCallback.onTaskVisibilityChanged(taskId, visible);
        }

        @Override
        public void onTaskMovedToFront(int taskId) {
            this.mCallback.onTaskMovedToFront(taskId);
        }

        @Override
        public void onTaskRemovalStarted(int taskId) {
            this.mCallback.onTaskRemovalStarted(taskId);
        }

        @Override
        public void onBackPressedOnTaskRoot(int taskId) {
            this.mCallback.onBackPressedOnTaskRoot(taskId);
        }
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private final DisplayInfo mTempDisplayInfo = new DisplayInfo();
        private final DisplayMetrics mTempMetrics = new DisplayMetrics();

        private SurfaceCallback() {
        }

        @Override
        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            if (!ActivityView.this.mTaskEmbedder.isInitialized()) {
                ActivityView.this.initTaskEmbedder(ActivityView.this.mSurfaceView.getSurfaceControl());
            } else {
                ActivityView.this.mTmpTransaction.reparent(ActivityView.this.mTaskEmbedder.getSurfaceControl(), ActivityView.this.mSurfaceView.getSurfaceControl()).apply();
            }
            ActivityView.this.mTaskEmbedder.resizeTask(ActivityView.this.getWidth(), ActivityView.this.getHeight());
            ActivityView.this.mTaskEmbedder.start();
        }

        @Override
        public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
            Display display = ActivityView.this.getVirtualDisplay().getDisplay();
            if (!display.getDisplayInfo(this.mTempDisplayInfo)) {
                return;
            }
            this.mTempDisplayInfo.getAppMetrics(this.mTempMetrics);
            if (width != this.mTempMetrics.widthPixels || height != this.mTempMetrics.heightPixels) {
                ActivityView.this.mTaskEmbedder.resizeTask(width, height);
                ActivityView.this.mTaskEmbedder.notifyBoundsChanged();
            }
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            ActivityView.this.mTaskEmbedder.stop();
        }
    }

    public static abstract class StateCallback {
        public abstract void onActivityViewReady(ActivityView var1);

        public abstract void onActivityViewDestroyed(ActivityView var1);

        public void onTaskCreated(int taskId, ComponentName componentName) {
        }

        public void onTaskVisibilityChanged(int taskId, boolean visible) {
        }

        public void onTaskMovedToFront(int taskId) {
        }

        public void onTaskRemovalStarted(int taskId) {
        }

        public void onBackPressedOnTaskRoot(int taskId) {
        }
    }
}

