/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.mobilesdk;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.google.api.client.util.Sets;
import com.google.api.services.mobilesdk_pa.v1.MobilesdkPa;
import com.google.api.services.mobilesdk_pa.v1.model.AcceptTosRequest;
import com.google.api.services.mobilesdk_pa.v1.model.AddAndroidCertificateRequest;
import com.google.api.services.mobilesdk_pa.v1.model.AndroidCertificate;
import com.google.api.services.mobilesdk_pa.v1.model.AndroidCreationData;
import com.google.api.services.mobilesdk_pa.v1.model.ClientDataSharingSetting;
import com.google.api.services.mobilesdk_pa.v1.model.Config;
import com.google.api.services.mobilesdk_pa.v1.model.ConsoleProject;
import com.google.api.services.mobilesdk_pa.v1.model.CreateFirebaseClientRequest;
import com.google.api.services.mobilesdk_pa.v1.model.CreateFirebaseClientResponse;
import com.google.api.services.mobilesdk_pa.v1.model.CreateFirebaseProjectRequest;
import com.google.api.services.mobilesdk_pa.v1.model.CreateFirebaseProjectResponse;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseProject;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseProjectCreationData;
import com.google.api.services.mobilesdk_pa.v1.model.GetAndroidConfigRequest;
import com.google.api.services.mobilesdk_pa.v1.model.GetFirebaseProjectResponse;
import com.google.api.services.mobilesdk_pa.v1.model.GetProjectDataSharingSettingRequest;
import com.google.api.services.mobilesdk_pa.v1.model.GetProjectDataSharingSettingResponse;
import com.google.api.services.mobilesdk_pa.v1.model.GetTosStatusResponse;
import com.google.api.services.mobilesdk_pa.v1.model.ListFirebaseProjectsResponse;
import com.google.api.services.mobilesdk_pa.v1.model.MigrateToFirebaseProjectRequest;
import com.google.api.services.mobilesdk_pa.v1.model.MigrateToFirebaseProjectResponse;
import com.google.api.services.mobilesdk_pa.v1.model.RequestHeader;
import com.google.api.services.mobilesdk_pa.v1.model.SetClientDataSharingSettingRequest;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobileSdkWrapperImpl
implements MobileSdkWrapper {
    public static final String CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1 = "ANDROID_STUDIO_V1";
    public static final String TOS_ACCEPTED_STATUS_CODE = "ACCEPTED";
    public static final Comparator<OnlineProject> ONLINE_PROJECT_COMPARATOR = (p1, p2) -> String.CASE_INSENSITIVE_ORDER.compare(p1.getDisplayName(), p2.getDisplayName());
    private final MobilesdkPa myApiStub;

    MobileSdkWrapperImpl(@NotNull MobilesdkPa apiStub) {
        this.myApiStub = apiStub;
    }

    private static Logger getLog() {
        return Logger.getInstance(MobileSdkWrapperImpl.class);
    }

    @Override
    public void acceptTermsOfService(String languageString) throws MobileSdkCommException {
        try {
            this.myApiStub.tos().accept(new AcceptTosRequest().setTosLanguageTag(languageString)).execute();
        }
        catch (IOException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.unknownTosStatus", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    @Nullable
    public URL getPendingTosUrl() throws MobileSdkCommException {
        GetTosStatusResponse getTosStatusResponse;
        try {
            getTosStatusResponse = (GetTosStatusResponse)this.myApiStub.v1().getTos().execute();
        }
        catch (IOException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.unknownTosStatus", (Throwable)exception, new Object[0]);
        }
        if (TOS_ACCEPTED_STATUS_CODE.equals(getTosStatusResponse.getOverallStatus())) {
            return null;
        }
        try {
            return new URL(getTosStatusResponse.getTermsUrl());
        }
        catch (MalformedURLException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.unparseableTosUrl", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    @NotNull
    public List<OnlineProject> getExistingProjects() throws MobileSdkCommException {
        ListFirebaseProjectsResponse listProjectsResponse;
        ArrayList existingProjects = Lists.newArrayList();
        try {
            listProjectsResponse = (ListFirebaseProjectsResponse)this.myApiStub.projects().list().setRequestHeaderClientVersion(CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1).execute();
        }
        catch (IOException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.unableToListProjects", (Throwable)exception, new Object[0]);
        }
        if (listProjectsResponse.getProject() != null) {
            for (FirebaseProject project : listProjectsResponse.getProject()) {
                MobileSdkWrapperImpl.getLog().debug("Inspecting Firebase project: " + project.getDisplayName());
                existingProjects.add(OnlineProject.fromFirebaseProject(project));
            }
        }
        Collections.sort(existingProjects, ONLINE_PROJECT_COMPARATOR);
        ArrayList nonFirebaseProjects = Lists.newArrayList();
        if (listProjectsResponse.getConsoleProject() != null) {
            for (ConsoleProject project : listProjectsResponse.getConsoleProject()) {
                MobileSdkWrapperImpl.getLog().debug("Inspecting Google project: " + project.getProjectNumber());
                nonFirebaseProjects.add(OnlineProject.fromConsoleProject(project));
            }
        }
        Collections.sort(nonFirebaseProjects, ONLINE_PROJECT_COMPARATOR);
        existingProjects.addAll(nonFirebaseProjects);
        this.updateExistingProjectDataSharing(existingProjects);
        return existingProjects;
    }

    private void updateExistingProjectDataSharing(@NotNull Collection<OnlineProject> projectsToUpdate) throws MobileSdkCommException {
        if (projectsToUpdate.isEmpty()) {
            return;
        }
        final CountDownLatch callbackCountDownLatch = new CountDownLatch(projectsToUpdate.size());
        BatchRequest batchRequest = this.myApiStub.batch();
        for (final OnlineProject project : projectsToUpdate) {
            try {
                JsonBatchCallback<GetProjectDataSharingSettingResponse> batchCallback = new JsonBatchCallback<GetProjectDataSharingSettingResponse>(){
                    final OnlineProject myProject;
                    {
                        this.myProject = project;
                    }

                    public void onSuccess(GetProjectDataSharingSettingResponse getProjectDataSharingSettingResponse, HttpHeaders httpHeaders) throws IOException {
                        OnlineProject.DataSharingOption dataSharingSetting = OnlineProject.DataSharingOption.valueOf(getProjectDataSharingSettingResponse.getProjectDataSharingSetting().getDataSharingSetting());
                        this.myProject.setProjectDataSharingOption(dataSharingSetting);
                        callbackCountDownLatch.countDown();
                    }

                    public void onFailure(GoogleJsonError googleJsonError, HttpHeaders httpHeaders) throws IOException {
                        MobileSdkWrapperImpl.getLog().warn("Exception retrieving data sharing setting for: " + this.myProject.getProjectNumber());
                        if (googleJsonError.getCode() == 404) {
                            this.myProject.setProjectDataSharingOption(OnlineProject.DataSharingOption.UNKNOWN_SETTING);
                        } else {
                            MobileSdkWrapperImpl.getLog().info("Http 404 error while retrieving the data sharing option for a project: " + this.myProject.getProjectNumber());
                        }
                        callbackCountDownLatch.countDown();
                    }
                };
                this.myApiStub.projects().getProjectDataSharingSetting(project.getProjectNumber(), new GetProjectDataSharingSettingRequest()).queue(batchRequest, (JsonBatchCallback)batchCallback);
            }
            catch (IOException exception) {
                throw new MobileSdkCommException("mobileSdkService.internalError.unableToRetrieveSharingSetting", (Throwable)exception, project.getDisplayName());
            }
        }
        try {
            batchRequest.execute();
            callbackCountDownLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.unableToRetrieveAnySharingSettings", (Throwable)exception, new Object[0]);
        }
    }

    private OnlineProject updateDataSharingField(OnlineProject onlineProject) throws MobileSdkCommException {
        try {
            GetProjectDataSharingSettingResponse dataSharingReponse = (GetProjectDataSharingSettingResponse)this.myApiStub.projects().getProjectDataSharingSetting(onlineProject.getProjectNumber(), new GetProjectDataSharingSettingRequest().setRequestHeader(new RequestHeader().setClientVersion(CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1))).execute();
            onlineProject.setProjectDataSharingOption(OnlineProject.DataSharingOption.valueOf(dataSharingReponse.getProjectDataSharingSetting().getDataSharingSetting()));
        }
        catch (GoogleJsonResponseException exception) {
            if (exception.getStatusCode() == 404) {
                MobileSdkWrapperImpl.getLog().info("Http 404 error while retrieving the data sharing option for a project: " + onlineProject.getProjectNumber());
                onlineProject.setProjectDataSharingOption(OnlineProject.DataSharingOption.UNKNOWN_SETTING);
            } else {
                MobileSdkWrapperImpl.logUnableToRetrieveProjectDataSharingSetting(onlineProject, (Exception)((Object)exception));
            }
        }
        catch (IOException exception) {
            MobileSdkWrapperImpl.logUnableToRetrieveProjectDataSharingSetting(onlineProject, exception);
        }
        return onlineProject;
    }

    private static void logUnableToRetrieveProjectDataSharingSetting(OnlineProject onlineProject, Exception exception) {
        String displayName = Strings.isNullOrEmpty((String)onlineProject.getDisplayName()) ? onlineProject.getProjectNumber() : onlineProject.getDisplayName();
        MobileSdkWrapperImpl.getLog().info(FirebaseBundle.message("mobileSdkService.internalError.unableToRetrieveSharingSetting", displayName), (Throwable)exception);
    }

    @Override
    @NotNull
    public OnlineProject createNewProject(@NotNull String displayName, @NotNull String regionCode, int timeZoneId) throws MobileSdkCommException {
        CreateFirebaseProjectResponse response;
        CreateFirebaseProjectRequest createFBProjectRequest = new CreateFirebaseProjectRequest().setRequestHeader(new RequestHeader().setClientVersion(CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1));
        FirebaseProjectCreationData projectCreationData = new FirebaseProjectCreationData().setDisplayName(displayName).setRegionCode(regionCode).setTimeZoneId(Integer.valueOf(timeZoneId)).setDataSharingEnabled(Boolean.valueOf(true));
        createFBProjectRequest.setProjectData(projectCreationData);
        try {
            response = (CreateFirebaseProjectResponse)this.myApiStub.projects().create(createFBProjectRequest).execute();
        }
        catch (IOException exception) {
            MobileSdkWrapperImpl.getLog().info("Failed to create a new project. Parameters were displayName: " + displayName + ", regionCode: " + regionCode + ", timeZoneId: " + timeZoneId);
            throw new MobileSdkCommException("mobileSdkService.internalError.unableToCreateProject", (Throwable)exception, new Object[0]);
        }
        return this.updateDataSharingField(OnlineProject.fromFirebaseProject(response.getProject()));
    }

    @Override
    @NotNull
    public OnlineProject upgradeExistingProject(@NotNull OnlineProject project, @NotNull String regionCode, int timeZoneId, boolean dataSharingEnabled) throws MobileSdkCommException, InsufficientPermissionsException {
        FirebaseProjectCreationData projectData = new FirebaseProjectCreationData().setDisplayName(project.getDisplayName()).setRegionCode(regionCode).setTimeZoneId(Integer.valueOf(timeZoneId)).setDataSharingEnabled(Boolean.valueOf(dataSharingEnabled));
        MobileSdkWrapperImpl.getLog().debug("Upgrading with this data:" + projectData);
        try {
            MigrateToFirebaseProjectResponse response = (MigrateToFirebaseProjectResponse)this.myApiStub.projects().migrateToFirebaseProject(new MigrateToFirebaseProjectRequest().setProjectData(projectData).setProjectNumber(project.getProjectNumber()).setRequestHeader(new RequestHeader().setClientVersion(CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1))).execute();
            return this.updateDataSharingField(OnlineProject.fromFirebaseProject(response.getProject()));
        }
        catch (GoogleJsonResponseException exception) {
            switch (exception.getStatusCode()) {
                case 403: {
                    throw new InsufficientPermissionsException(exception);
                }
            }
            throw new MobileSdkCommException("mobileSdkService.internalError.couldNotUpgradeProject", (Throwable)exception, new Object[0]);
        }
        catch (IOException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.couldNotUpgradeProject", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    @NotNull
    public OnlineProject updateExistingProject(@NotNull String projectNumber, boolean disableClientDataSharing, @NotNull Collection<AndroidClient> clients) throws MobileSdkCommException {
        try {
            Collection<String> warningMessages = this.createAndroidClients(projectNumber, disableClientDataSharing, clients);
            OnlineProject project = OnlineProject.fromFirebaseProject(((GetFirebaseProjectResponse)this.myApiStub.projects().get(projectNumber).setRequestHeaderClientVersion(CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1).execute()).getFirebaseProject());
            project.addWarningMessages(warningMessages);
            return this.updateDataSharingField(project);
        }
        catch (Exception exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.unableToUpdateClients", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    @NotNull
    public String getFirebaseConfigurationData(@NotNull String projectNumber) throws MobileSdkCommException {
        GetAndroidConfigRequest request = new GetAndroidConfigRequest().setRequestHeader(new RequestHeader().setClientVersion(CLIENT_VERSION_ANDROID_STUDIO_FIREBASE_V1));
        try {
            Config response = (Config)this.myApiStub.projects().getAndroidConfig(projectNumber, request).execute();
            MobileSdkWrapperImpl.getLog().debug("Downloaded Android Config for Firebase");
            String decodedContent = new String(response.decodeContent());
            if (Strings.isNullOrEmpty((String)decodedContent)) {
                throw new MobileSdkCommException("mobileSdkService.internalError.emptyDownloadedConfig", new Object[0]);
            }
            return decodedContent;
        }
        catch (IOException exception) {
            throw new MobileSdkCommException("mobileSdkService.internalError.cantDownloadConfig", (Throwable)exception, new Object[0]);
        }
    }

    private Collection<String> createAndroidClients(@NotNull String projectNumber, boolean disableClientDataSharing, @NotNull Collection<AndroidClient> clientsToCreate) throws IOException {
        ArrayList warningMessages = Lists.newArrayList();
        OnlineProject onlineProject = this.getProject(projectNumber);
        HashMap<String, HashSet<String>> createClientsSha1Map = MobileSdkWrapperImpl.extractPackageSha1Map(clientsToCreate, warningMessages);
        if (createClientsSha1Map.isEmpty()) {
            return warningMessages;
        }
        for (Map.Entry<String, HashSet<String>> mapEntry : createClientsSha1Map.entrySet()) {
            String packageName = mapEntry.getKey();
            Set sha1sToCreate = mapEntry.getValue();
            FirebaseClientSummary existingClient = onlineProject.getFirebaseClientSummary(packageName);
            String clientId = null;
            if (existingClient == null) {
                CreateFirebaseClientRequest request = new CreateFirebaseClientRequest().setAndroidData(new AndroidCreationData().setAndroidCertificateHash((List)Lists.newArrayList((Iterable)sha1sToCreate)).setPackageName(packageName));
                try {
                    MobileSdkWrapperImpl.getLog().info("Creating FirebaseClient: " + packageName + " with SHA1(s): " + Arrays.toString(sha1sToCreate.toArray()));
                    CreateFirebaseClientResponse response = (CreateFirebaseClientResponse)this.myApiStub.projects().clients().create(projectNumber, request).execute();
                    if (response.getClient() != null) {
                        MobileSdkWrapperImpl.getLog().debug("Created FirebaseClient with package: " + packageName + " and SHA1: " + Arrays.toString(sha1sToCreate.toArray()));
                        clientId = response.getClient().getClientId();
                    }
                }
                catch (GoogleJsonResponseException exception) {
                    MobileSdkWrapperImpl.logOrThrowFirebaseClientException(warningMessages, packageName, sha1sToCreate, exception);
                }
            } else {
                clientId = existingClient.getClientId();
                for (String sha1ToCreate : sha1sToCreate) {
                    AddAndroidCertificateRequest request = new AddAndroidCertificateRequest().setAndroidCertificate(new AndroidCertificate().setAndroidCertificateHash(sha1ToCreate));
                    try {
                        MobileSdkWrapperImpl.getLog().info("Updating FirebaseClient: " + packageName + " with SHA1: " + sha1ToCreate);
                        this.myApiStub.projects().clients().addAndroidCertificate(projectNumber, clientId, request).execute();
                        MobileSdkWrapperImpl.getLog().debug("Updated FirebaseClient with package: " + packageName + " and SHA1: " + sha1ToCreate);
                    }
                    catch (GoogleJsonResponseException exception) {
                        MobileSdkWrapperImpl.logOrThrowFirebaseClientException(warningMessages, packageName, sha1sToCreate, exception);
                    }
                }
            }
            if (clientId == null || !disableClientDataSharing) continue;
            MobileSdkWrapperImpl.getLog().info("Disabling data sharing with Android client with package: " + packageName + " and SHA1(s): " + Arrays.toString(sha1sToCreate.toArray()));
            this.myApiStub.projects().clients().setClientDataSharingSetting(projectNumber, clientId, new SetClientDataSharingSettingRequest().setClientDataSharingSetting(new ClientDataSharingSetting().setClientId(clientId).setAllProductSharingEnabled(Boolean.valueOf(false)).setNewProductsDefault(Boolean.valueOf(false)).setSharedProducts(new ArrayList()))).execute();
        }
        return warningMessages;
    }

    private static void logOrThrowFirebaseClientException(@NotNull ArrayList<String> warningMessages, @NotNull String packageName, @NotNull Set<String> sha1sToCreate, @NotNull GoogleJsonResponseException exception) throws GoogleJsonResponseException {
        if (exception.getStatusCode() == 409) {
            warningMessages.add(FirebaseBundle.message("mobileSdkService.registerClientWarning.clientAlreadyRegistered", packageName, Arrays.toString(sha1sToCreate.toArray())));
            return;
        }
        throw exception;
    }

    @NotNull
    private static HashMap<String, HashSet<String>> extractPackageSha1Map(@NotNull Collection<AndroidClient> clientsToCreate, ArrayList<String> warningMessages) {
        HashMap clientsSha1PackageMap = Maps.newHashMap();
        clientsToCreate.forEach(client -> {
            if (!MobileSdkUtil.isValidPackageName(client.getPackageName())) {
                warningMessages.add(FirebaseBundle.message("mobileSdkService.registerClientWarning.clientPackageNameInvalid", client.getPackageName(), client.getSha1()));
            } else if (!MobileSdkUtil.isValidSha1Fingerprint(client.getSha1())) {
                warningMessages.add(FirebaseBundle.message("mobileSdkService.registerClientWarning.clientSha1Invalid", client.getPackageName(), client.getSha1()));
            } else if (client.isAttemptRegistration()) {
                HashSet sha1List = (HashSet)clientsSha1PackageMap.get(client.getPackageName());
                if (sha1List == null) {
                    sha1List = Sets.newHashSet();
                    clientsSha1PackageMap.put(client.getPackageName(), sha1List);
                }
                sha1List.add(client.getSha1());
            } else {
                MobileSdkWrapperImpl.getLog().info("Client defined as not creatable: " + client);
            }
        });
        return clientsSha1PackageMap;
    }

    @NotNull
    private OnlineProject getProject(@NotNull String projectNumber) throws IOException {
        GetFirebaseProjectResponse projectResponse = (GetFirebaseProjectResponse)this.myApiStub.projects().get(projectNumber).execute();
        return OnlineProject.fromFirebaseProject(projectResponse.getFirebaseProject());
    }

    public static class InsufficientPermissionsException
    extends Exception {
        InsufficientPermissionsException(@NotNull Throwable cause) {
            super(cause);
        }
    }

    public static class Builder {
        public static final int THREE_MINUTES = 180000;
        private static final String APPLICATION_NAME = "AS_FirebasePlugin";
        private final GoogleLogin myGoogleLogin;

        public Builder(@NotNull GoogleLogin googleLogin) {
            this.myGoogleLogin = googleLogin;
        }

        public MobileSdkWrapper build() throws MobileSdkCommException {
            HttpRequestInitializer googleRequestInitializer = null;
            HttpRequestFactory requestFactory = this.myGoogleLogin.createRequestFactory();
            if (requestFactory != null) {
                googleRequestInitializer = requestFactory.getInitializer();
            }
            HttpRequestInitializer finalGoogleRequestInitializer = googleRequestInitializer;
            HttpRequestInitializer requestInitializer = this.getHttpRequestInitializer(finalGoogleRequestInitializer);
            try {
                NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
                MobilesdkPa.Builder builder = new MobilesdkPa.Builder((HttpTransport)transport, (JsonFactory)JacksonFactory.getDefaultInstance(), requestInitializer);
                builder.setHttpRequestInitializer(requestInitializer);
                builder.setApplicationName(APPLICATION_NAME);
                return new MobileSdkWrapperImpl(builder.build());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new MobileSdkCommException("mobileSdkService.internalError.couldNotCreateApiStub", (Throwable)e, new Object[0]);
            }
        }

        @NotNull
        private HttpRequestInitializer getHttpRequestInitializer(HttpRequestInitializer finalGoogleRequestInitializer) {
            HttpRequestInitializer requestInitializer = httpRequest -> {
                if (finalGoogleRequestInitializer != null) {
                    finalGoogleRequestInitializer.initialize(httpRequest);
                    httpRequest.setInterceptor(httpRequest1 -> httpRequest1.setInterceptor(httpRequest2 -> {
                        HttpHeaders currentHeaders = httpRequest2.getHeaders();
                        currentHeaders.setAuthorization("Bearer " + this.myGoogleLogin.fetchOAuth2Token());
                        httpRequest2.setHeaders(currentHeaders);
                        httpRequest2.setConnectTimeout(180000);
                        httpRequest2.setReadTimeout(180000);
                    }));
                }
            };
            return requestInitializer;
        }
    }
}

