/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.util.BooleanBiFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class IteratorUtils {
    public static <T> boolean match(@NotNull Iterator<T> iterator1, @NotNull Iterator<T> iterator2, @NotNull BooleanBiFunction<? super T, ? super T> condition) {
        while (iterator2.hasNext()) {
            if (iterator1.hasNext() && ((Boolean)condition.fun(iterator1.next(), iterator2.next())).booleanValue()) continue;
            return false;
        }
        return !iterator1.hasNext();
    }

    public static <T> boolean match(@NotNull AbstractObjectGraphIterator<T> iterator1, @NotNull AbstractObjectGraphIterator<T> iterator2, @NotNull BooleanBiFunction<? super T, ? super T> condition) {
        while (iterator2.hasNext()) {
            if (iterator1.hasNext() && ((AbstractObjectGraphIterator)iterator1).myProcessedStructure.equals(((AbstractObjectGraphIterator)iterator2).myProcessedStructure) && ((Boolean)condition.fun(iterator1.next(), iterator2.next())).booleanValue()) continue;
            return false;
        }
        return !iterator1.hasNext();
    }

    @ApiStatus.Experimental
    public static abstract class AbstractObjectGraphIterator<T>
    implements Iterator<T> {
        private final Set<T> mySeenObjects = Collections.newSetFromMap(new IdentityHashMap());
        private final LinkedList<T> myToProcess;
        private final LinkedList<Integer> myProcessedStructure;

        public AbstractObjectGraphIterator(@NotNull Collection<T> dependencies) {
            this.myToProcess = new LinkedList<T>(dependencies);
            this.myProcessedStructure = new LinkedList();
        }

        public abstract Collection<? extends T> getChildren(T var1);

        @Override
        public boolean hasNext() {
            T dependency = this.myToProcess.peekFirst();
            if (dependency == null) {
                return false;
            }
            if (this.mySeenObjects.contains(dependency)) {
                this.myToProcess.removeFirst();
                return this.hasNext();
            }
            return !this.myToProcess.isEmpty();
        }

        @Override
        public T next() {
            T dependency = this.myToProcess.removeFirst();
            if (this.mySeenObjects.add(dependency)) {
                Collection<T> children = this.getChildren(dependency);
                this.myToProcess.addAll(children);
                this.myProcessedStructure.add(children.size());
                return dependency;
            }
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

