/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u0005"}, d2={"computeUnderlyingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "inlineClassType", "shouldUseUnderlyingType", "", "descriptors.jvm"})
public final class InlineClassMappingKt {
    @Nullable
    public static final KotlinType computeUnderlyingType(@NotNull KotlinType inlineClassType) {
        TypeConstructor typeConstructor2;
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        if (!InlineClassMappingKt.shouldUseUnderlyingType(inlineClassType)) {
            return null;
        }
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        ClassifierDescriptor classifierDescriptor2 = kotlinType == null ? null : (classifierDescriptor = (typeConstructor2 = kotlinType.getConstructor()) == null ? null : typeConstructor2.getDeclarationDescriptor());
        if (classifierDescriptor == null) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor3 = classifierDescriptor;
        ClassifierDescriptor descriptor2 = classifierDescriptor3;
        return descriptor2 instanceof TypeParameterDescriptor ? TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2) : InlineClassesUtilsKt.substitutedUnderlyingType(inlineClassType);
    }

    public static final boolean shouldUseUnderlyingType(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return !inlineClassType.isMarkedNullable() || !TypeUtils.isNullableType(underlyingType) && !KotlinBuiltIns.isPrimitiveType(underlyingType);
    }
}

