/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedNioFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ByteRange;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J6\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/io/FileResponses;", "", "()V", "checkCache", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "lastModified", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "doPrepareResponse", "Lio/netty/handler/codec/http/DefaultHttpResponse;", "response", "filename", "", "getContentType", "path", "prepareSend", "Lio/netty/handler/codec/http/HttpResponse;", "sendFile", "", "file", "Ljava/nio/file/Path;", "intellij.platform.ide.util.io"})
public final class FileResponses {
    public static final FileResponses INSTANCE;

    @NotNull
    public final String getContentType(@NotNull String path) {
        String string;
        block3: {
            block2: {
                string = PathUtilRt.getFileExtension((String)path);
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = (String)FileResponsesKt.access$getFileExtToMimeType$p().get((Object)it);
                if (string != null) break block3;
            }
            string = "application/octet-stream";
        }
        return string;
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @Nullable HttpHeaders extraHeaders) {
        Long ifModified = request.headers().getTimeMillis((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModified != null && ifModified >= lastModified) {
            Responses.send$default(HttpResponseStatus.NOT_MODIFIED, channel, request, null, extraHeaders, 4, null);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean checkCache$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        return fileResponses.checkCache(httpRequest, channel, l, httpHeaders);
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified) {
        return FileResponses.checkCache$default(this, request, channel, lastModified, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename, @Nullable HttpHeaders extraHeaders) {
        if (request.headers().get((CharSequence)HttpHeaderNames.RANGE) == null && this.checkCache(request, channel, lastModified, extraHeaders)) {
            return null;
        }
        return (HttpResponse)this.doPrepareResponse(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), filename, lastModified, extraHeaders);
    }

    public static /* synthetic */ HttpResponse prepareSend$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, String string, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 0x10) != 0) {
            httpHeaders = null;
        }
        return fileResponses.prepareSend(httpRequest, channel, l, string, httpHeaders);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename) {
        return FileResponses.prepareSend$default(this, request, channel, lastModified, filename, null, 16, null);
    }

    private final DefaultHttpResponse doPrepareResponse(DefaultHttpResponse response, String filename, long lastModified, HttpHeaders extraHeaders) {
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.getContentType(filename));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
        if (Intrinsics.areEqual((Object)response.status(), (Object)HttpResponseStatus.PARTIAL_CONTENT) ^ true) {
            response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
        }
        if (extraHeaders != null) {
            response.headers().add(extraHeaders);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file, @Nullable HttpHeaders extraHeaders) {
        FileChannel fileChannel = null;
        String rangeHeader = request.headers().get((CharSequence)HttpHeaderNames.RANGE);
        long lastModified = 0L;
        try {
            lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            if (rangeHeader == null && this.checkCache(request, channel, lastModified, extraHeaders)) {
                return;
            }
            fileChannel = FileChannel.open(file, StandardOpenOption.READ);
        }
        catch (NoSuchFileException ignored) {
            Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, request, null, null, 12, null);
            return;
        }
        boolean isKeepAlive = false;
        boolean fileWillBeClosed = false;
        try {
            long fileLength = fileChannel.size();
            ByteRange byteRange = FileResponsesKt.access$parseRange(rangeHeader, fileLength);
            if (byteRange == null) {
                byteRange = new ByteRange(0L, fileLength);
            }
            ByteRange range = byteRange;
            boolean isPartialContent = range.getStart() != 0L || range.getEnd() != fileLength;
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, isPartialContent ? HttpResponseStatus.PARTIAL_CONTENT : HttpResponseStatus.OK);
            isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, request);
            this.doPrepareResponse(response, ((Object)file.getFileName()).toString(), lastModified, extraHeaders);
            if (isPartialContent) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)("bytes " + range.getStart() + '-' + (range.getEnd() - 1L) + '/' + fileLength));
            }
            long contentLength = range.getEnd() - range.getStart();
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)contentLength);
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                if (channel.pipeline().get(SslHandler.class) == null) {
                    channel.write((Object)new DefaultFileRegion(fileChannel, range.getStart(), contentLength));
                } else {
                    channel.write((Object)new ChunkedNioFile(fileChannel, range.getStart(), contentLength, 8192));
                }
            }
            fileWillBeClosed = true;
        }
        catch (Throwable throwable) {
            fileChannel.close();
            throw throwable;
        }
        FileResponsesKt.flushChunkedResponse(channel, isKeepAlive);
    }

    public static /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders);
    }

    private FileResponses() {
    }

    static {
        FileResponses fileResponses;
        INSTANCE = fileResponses = new FileResponses();
    }
}

