/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlImpl
implements Url {
    private final String scheme;
    private final String authority;
    private final String path;
    private String decodedPath;
    private final String parameters;
    private String externalForm;
    private UrlImpl withoutParameters;

    @Deprecated
    public UrlImpl(@NotNull String path) {
        this(null, null, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path) {
        this(scheme, authority, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String parameters) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = StringUtil.notNullize((String)path);
        this.parameters = StringUtil.nullize((String)parameters);
    }

    @Override
    public Url resolve(@NotNull String subPath) {
        return new UrlImpl(this.scheme, this.authority, this.path.isEmpty() ? subPath : this.path + "/" + subPath, this.parameters);
    }

    @Override
    @NotNull
    public Url addParameters(@NotNull Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        if (this.parameters == null) {
            builder.append('?');
        } else {
            builder.append(this.parameters);
            builder.append('&');
        }
        Urls.encodeParameters(parameters, builder);
        return new UrlImpl(this.scheme, this.authority, this.path, builder.toString());
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.decodedPath == null) {
            this.decodedPath = URLUtil.unescapePercentSequences((String)this.path);
        }
        return this.decodedPath;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return "file".equals(this.scheme);
    }

    @Override
    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String toDecodedForm() {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            builder.append(this.scheme);
            if (this.authority == null) {
                builder.append(':');
            } else {
                builder.append("://");
            }
            if (this.authority != null) {
                builder.append(this.authority);
            }
        }
        builder.append(this.getPath());
        if (this.parameters != null) {
            builder.append(this.parameters);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String toExternalForm() {
        String result;
        if (this.externalForm != null) {
            return this.externalForm;
        }
        if ((this.authority == null || !this.path.isEmpty() && this.path.charAt(0) != '/') && !this.isInLocalFileSystem()) {
            return this.toDecodedForm();
        }
        String string = result = StringUtil.isEmpty((String)this.authority) && StringUtil.isEmpty((String)this.path) ? this.scheme + "://" : Urls.toUriWithoutParameters(this).toASCIIString();
        if (this.parameters != null) {
            result = result + this.parameters;
        }
        this.externalForm = result;
        return result;
    }

    @Override
    @NotNull
    public Url trimParameters() {
        if (this.parameters == null) {
            return this;
        }
        if (this.withoutParameters == null) {
            this.withoutParameters = new UrlImpl(this.scheme, this.authority, this.path, null);
        }
        return this.withoutParameters;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equals((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equals((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equals(url.getPath()) && StringUtil.equals((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    @Override
    public boolean equalsIgnoreCase(@Nullable Url o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equalsIgnoreCase((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equalsIgnoreCase((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equalsIgnoreCase(url.getPath()) && StringUtil.equalsIgnoreCase((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    @Override
    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return url != null && this.equals(url.trimParameters());
    }

    private int computeHashCode(boolean caseSensitive) {
        int result = UrlImpl.stringHashCode(this.scheme, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.authority, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.getPath(), caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.parameters, caseSensitive);
        return result;
    }

    private static int stringHashCode(@Nullable CharSequence string, boolean caseSensitive) {
        return string == null ? 0 : (caseSensitive ? string.hashCode() : StringUtil.stringHashCodeInsensitive((CharSequence)string));
    }

    public int hashCode() {
        return this.computeHashCode(true);
    }

    @Override
    public int hashCodeCaseInsensitive() {
        return this.computeHashCode(false);
    }
}

