/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathEnvironmentVariableUtil {
    private static final String PATH = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, PathEnvironmentVariableUtil.getPathVariableValue(), filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable String pathVariableValue, @Nullable FileFilter filter) {
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, filter, pathVariableValue, fileBaseName);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        return PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        return PathEnvironmentVariableUtil.findExeFilesInPath(false, filter, PathEnvironmentVariableUtil.getPathVariableValue(), fileBaseName);
    }

    @NotNull
    private static List<File> findExeFilesInPath(boolean stopAfterFirstMatch, @Nullable FileFilter filter, @Nullable String pathEnvVarValue, String ... fileBaseNames) {
        if (pathEnvVarValue == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        List<String> dirPaths = PathEnvironmentVariableUtil.getPathDirs(pathEnvVarValue);
        for (String dirPath : dirPaths) {
            File dir = new File(dirPath);
            if (!dir.isAbsolute() || !dir.isDirectory()) continue;
            for (String fileBaseName : fileBaseNames) {
                File exeFile = new File(dir, fileBaseName);
                if (!exeFile.isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
                result.add(exeFile);
                if (!stopAfterFirstMatch) continue;
                return result;
            }
        }
        return result;
    }

    @NotNull
    public static List<String> getPathDirs(@NotNull String pathEnvVarValue) {
        return StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
    }

    @NotNull
    public static List<String> getWindowsExecutableFileExtensions() {
        String allExtensions;
        if (SystemInfo.isWindows && (allExtensions = System.getenv("PATHEXT")) != null) {
            List extensions = StringUtil.split((String)allExtensions, (String)";", (boolean)true, (boolean)true);
            extensions = ContainerUtil.filter((Collection)extensions, s -> !StringUtil.isEmpty((String)s) && s.startsWith("."));
            return ContainerUtil.map2List((Collection)extensions, s -> StringUtil.toLowerCase((String)s));
        }
        return Collections.emptyList();
    }

    @NotNull
    public static String findExecutableInWindowsPath(@NotNull String exePath) {
        return PathEnvironmentVariableUtil.findExecutableInWindowsPath(exePath, exePath);
    }

    @Contract(value="_, !null -> !null")
    public static String findExecutableInWindowsPath(@NotNull String exePath, @Nullable String defaultPath) {
        if (SystemInfo.isWindows && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\')) {
            List<String> executableFileExtensions = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
            String[] baseNames = (String[])ContainerUtil.map2Array(executableFileExtensions, String.class, s -> exePath + s);
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, PathEnvironmentVariableUtil.getPathVariableValue(), baseNames);
            File foundFile = (File)ContainerUtil.getFirstItem(exeFiles);
            if (foundFile != null) {
                return foundFile.getAbsolutePath();
            }
        }
        return defaultPath;
    }

    @Nullable
    public static String getPathVariableValue() {
        return EnvironmentUtil.getValue((String)PATH);
    }
}

