/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.CloudConfigurationTypeSelection;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.ConfigurationResult;
import com.google.gct.testing.ConfigurationResultListener;
import com.google.gct.testing.ScreenshotComparisonDialog;
import com.google.gct.testing.ScreenshotComparisonHeaderPanelListener;
import com.google.gct.testing.TestName;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.OrientationDimension;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.ui.CopyImageToClipboard;
import com.google.gct.testing.ui.Tab;
import com.google.gct.testing.ui.TabEventListener;
import com.google.gct.testing.ui.WipePanel;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;

public class ScreenshotComparisonPanel
implements ScreenshotComparisonHeaderPanelListener,
ConfigurationResultListener {
    public static final Function<CloudConfigurationTypeSelection, CloudTestingType> GET_SELECTED_TYPE = new Function<CloudConfigurationTypeSelection, CloudTestingType>(){

        public CloudTestingType apply(CloudConfigurationTypeSelection input) {
            return input.getType();
        }
    };
    public static final Color GREEN = new Color(61, 138, 78);
    public static final Color RED = UIUtil.isUnderDarcula() ? CloudTestingUtils.makeDarker(new Color(183, 14, 10), 2) : new Color(183, 14, 10);
    private final ScreenshotComparisonDialog parent;
    private final AbstractTestProxy testTreeRoot;
    private final CloudConfigurationImpl configuration;
    private ConfigurationInstance selectedConfigurationInstance;
    private TestName currentTest;
    private int currentStep;
    private final Map<String, ConfigurationResult> results;
    private JPanel myPanel;
    private JPanel myScreenshotPanel;
    private JPanel myImagePanel;
    private JPanel myConfigurationChooserPanel;
    private JPanel myButtonPanel;
    private final WipePanel wipePanel;
    private final List<CloudConfigurationTypeSelection> myTypeSelections;
    private JLabel myImageLabel;
    private static final int MAX_IMAGE_WIDTH = 533;
    private static final int MAX_IMAGE_HEIGHT = 533;
    private static final int PORTRAIT_WIDTH = 300;
    private static final int LANDSCAPE_HEIGHT = 300;
    private static final BufferedImage NO_IMAGE_PORTRAIT;
    private static final BufferedImage NO_IMAGE_LANSCAPE;
    private static final BufferedImage LOADING_PORTRAIT;
    private static final BufferedImage LOADING_LANDSCAPE;
    private UpdateImageThread updateImageThread;
    private final Object lock;
    private boolean isLoaded;
    private BufferedImage currentImage;
    private Icon referenceIcon;

    public ScreenshotComparisonPanel(ScreenshotComparisonDialog parent, ScreenshotComparisonPanel clonedPanel, AbstractTestProxy testTreeRoot, CloudConfigurationImpl configuration, ConfigurationInstance configurationInstance, TestName currentTest, int currentStep, Map<String, ConfigurationResult> results) {
        this.$$$setupUI$$$();
        this.myTypeSelections = new LinkedList<CloudConfigurationTypeSelection>();
        this.referenceIcon = null;
        this.lock = this;
        this.parent = parent;
        if (clonedPanel != null) {
            this.referenceIcon = clonedPanel.myImageLabel.getIcon();
        }
        this.testTreeRoot = testTreeRoot;
        this.configuration = configuration;
        this.selectedConfigurationInstance = configurationInstance;
        this.currentTest = currentTest;
        this.currentStep = currentStep;
        this.results = results;
        this.wipePanel = new WipePanel();
        this.wipePanel.setContentPanel(this.myPanel);
        ConfigurationResult selectedConfigurationResult = this.getSelectedConfigurationResult();
        if (selectedConfigurationResult != null) {
            selectedConfigurationResult.addConfigurationResultListener(this);
        }
        this.init(clonedPanel);
    }

    public void init(ScreenshotComparisonPanel clonedPanel) {
        if (UIUtil.isUnderDarcula()) {
            this.myConfigurationChooserPanel.setBackground(CloudTestingUtils.makeDarker(UIUtil.getPanelBackground(), 1));
        }
        DefaultListCellRenderer dimensionChooserRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof CloudTestingType) {
                    CloudTestingType type = (CloudTestingType)value;
                    label.setText(type.getResultsViewerDisplayName());
                }
                return label;
            }
        };
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.fill = 2;
        bagConstraints.ipadx = 5;
        int index = 0;
        for (final CloudConfigurationDimension dimension : this.configuration.getDimensions()) {
            JLabel label = new JLabel(dimension.getIcon());
            label.setToolTipText(dimension.getDisplayName());
            Font oldFont = label.getFont();
            label.setFont(new Font(oldFont.getFontName(), 1, oldFont.getSize()));
            bagConstraints.gridy = index;
            bagConstraints.gridx = 0;
            this.myConfigurationChooserPanel.add((Component)label, bagConstraints);
            bagConstraints.gridy = index;
            bagConstraints.gridx = 1;
            if (dimension.getEnabledTypes().size() > 1) {
                final JComboBox<Object> comboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(dimension.getEnabledTypes().toArray()));
                comboBox.setRenderer(dimensionChooserRenderer);
                comboBox.setSelectedItem(this.selectedConfigurationInstance.getTypeForDimension(dimension));
                final ScreenshotComparisonPanel thisPanel = this;
                comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConfigurationResult currentConfigurationResult = ScreenshotComparisonPanel.this.getSelectedConfigurationResult();
                        if (currentConfigurationResult != null) {
                            currentConfigurationResult.removeConfigurationResultListener(thisPanel);
                        }
                        ScreenshotComparisonPanel.this.selectedConfigurationInstance = ScreenshotComparisonPanel.this.computeSelectedConfigurationInstance();
                        currentConfigurationResult = ScreenshotComparisonPanel.this.getSelectedConfigurationResult();
                        if (currentConfigurationResult != null) {
                            currentConfigurationResult.addConfigurationResultListener(thisPanel);
                        }
                        ScreenshotComparisonPanel.this.updateHeaderBar();
                        if (dimension instanceof OrientationDimension) {
                            ScreenshotComparisonPanel.this.referenceIcon = null;
                        } else {
                            ScreenshotComparisonPanel.this.referenceIcon = ScreenshotComparisonPanel.this.myImageLabel.getIcon();
                        }
                        ScreenshotComparisonPanel.this.updateImage();
                        ScreenshotComparisonPanel.this.parent.updateMaxStep();
                    }
                });
                this.myConfigurationChooserPanel.add(comboBox, bagConstraints);
                this.myTypeSelections.add(new CloudConfigurationTypeSelection(){

                    @Override
                    public CloudTestingType getType() {
                        return (CloudTestingType)comboBox.getSelectedItem();
                    }
                });
            } else {
                final CloudTestingType type = (CloudTestingType)Iterables.getOnlyElement(dimension.getEnabledTypes());
                this.myConfigurationChooserPanel.add((Component)new JLabel(" " + type.getResultsViewerDisplayName()), bagConstraints);
                this.myTypeSelections.add(new CloudConfigurationTypeSelection(){

                    @Override
                    public CloudTestingType getType() {
                        return type;
                    }
                });
            }
            ++index;
        }
        this.myImageLabel = new JLabel();
        this.myImagePanel.add((Component)this.myImageLabel, "Center");
        this.updateHeaderBar();
        if (clonedPanel != null && clonedPanel.isLoaded) {
            this.myImageLabel.setIcon(clonedPanel.myImageLabel.getIcon());
            this.isLoaded = true;
        } else {
            this.updateImage();
        }
    }

    public int getMaxStep() {
        ConfigurationResult selectedConfigurationResult = this.getSelectedConfigurationResult();
        return selectedConfigurationResult == null ? 0 : selectedConfigurationResult.maxScreenshotStep(this.currentTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage() {
        Object object = this.lock;
        synchronized (object) {
            ConfigurationResult selectedConfigurationResult;
            this.isLoaded = false;
            if (this.updateImageThread != null) {
                this.updateImageThread.makeObsolete();
            }
            if ((selectedConfigurationResult = this.getSelectedConfigurationResult()) == null) {
                this.setStaticImage(StaticImageKind.NO_IMAGE);
                return;
            }
            this.setStaticImage(StaticImageKind.LOADING);
            this.updateImageThread = new UpdateImageThread(this.currentTest, this.currentStep, selectedConfigurationResult);
            this.updateImageThread.start();
        }
    }

    private void setStaticImage(StaticImageKind imageKind) {
        BufferedImage staticImage = imageKind == StaticImageKind.LOADING ? (this.isPortrait() ? LOADING_PORTRAIT : LOADING_LANDSCAPE) : (this.isPortrait() ? NO_IMAGE_PORTRAIT : NO_IMAGE_LANSCAPE);
        Pair<Integer, Integer> imageSize = this.getStaticImageSize();
        this.myImageLabel.setIcon(new ImageIcon(staticImage.getScaledInstance((Integer)imageSize.getFirst(), (Integer)imageSize.getSecond(), 4)));
        this.isLoaded = imageKind != StaticImageKind.LOADING;
        this.parent.fitWindow();
    }

    private Pair<Integer, Integer> getStaticImageSize() {
        if (this.referenceIcon != null) {
            return new Pair((Object)this.referenceIcon.getIconWidth(), (Object)this.referenceIcon.getIconHeight());
        }
        if (this.isPortrait()) {
            return new Pair((Object)300, (Object)533);
        }
        return new Pair((Object)533, (Object)300);
    }

    private void updateHeaderBar() {
        GoogleCloudTestProxy testNode;
        String configurationInstanceName = this.selectedConfigurationInstance.getResultsViewerDisplayString();
        try {
            testNode = (GoogleCloudTestProxy)this.getChild(this.getChild(this.getChild(this.testTreeRoot, configurationInstanceName), this.currentTest.getClassName()), this.currentTest.getMethodName());
        }
        catch (NoSuchElementException e) {
            this.createTabsAndBorders("No Result", AllIcons.RunConfigurations.TestNotRan, Color.BLACK);
            return;
        }
        if (testNode.isPassed()) {
            this.createTabsAndBorders("Passed", AllIcons.RunConfigurations.TestPassed, GREEN);
        } else if (testNode.isError()) {
            this.createTabsAndBorders("Error", AllIcons.RunConfigurations.TestError, RED);
        } else if (testNode.isFailure()) {
            this.createTabsAndBorders("Failed", AllIcons.RunConfigurations.TestFailed, RED);
        } else if (testNode.isIgnored()) {
            this.createTabsAndBorders("Ignored", AllIcons.RunConfigurations.TestIgnored, RED);
        } else {
            this.createTabsAndBorders("Interrupted", AllIcons.RunConfigurations.TestTerminated, RED);
        }
    }

    private void createTabsAndBorders(String status, Icon icon, Color color) {
        this.myScreenshotPanel.setBorder(new MatteBorder(8, 2, 2, 2, color));
        if (UIUtil.isUnderDarcula()) {
            this.myScreenshotPanel.setBackground(CloudTestingUtils.makeDarker(UIUtil.getPanelBackground(), 1));
        }
        this.myButtonPanel.removeAll();
        Tab mainTab = Tab.makeStandardTab(status, icon, color);
        this.myButtonPanel.add((Component)mainTab, "Center");
        this.myButtonPanel.updateUI();
        final ScreenshotComparisonPanel thisPanel = this;
        mainTab.addTabEventListener(new TabEventListener(){

            @Override
            public void closeEvent() {
                ScreenshotComparisonPanel.this.parent.removeScreenshotComparisonPanel(thisPanel);
            }

            @Override
            public void openEvent() {
                ScreenshotComparisonPanel.this.parent.addScreenshotComparisonPanel(thisPanel);
            }

            @Override
            public void saveImage() {
                BufferedImage image = ScreenshotComparisonPanel.this.getImage();
                ConfigurationResult selectedConfigurationResult = ScreenshotComparisonPanel.this.getSelectedConfigurationResult();
                if (selectedConfigurationResult == null || image == null) {
                    return;
                }
                ConfigurationInstance configurationInstance = selectedConfigurationResult.getConfigurationInstance();
                String proposedFileName = configurationInstance.getEncodedString();
                String description = "Save screenshot of " + configurationInstance.getResultsViewerDisplayString();
                FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Screenshot", description, new String[]{"png"});
                FileSaverDialogImpl fileSaverDialog = new FileSaverDialogImpl(descriptor, (Component)ScreenshotComparisonPanel.this.parent.getWindow());
                VirtualFileWrapper fileWrapper = fileSaverDialog.save(null, proposedFileName);
                if (fileWrapper != null) {
                    try {
                        ImageIO.write((RenderedImage)image, "png", fileWrapper.getFile());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void copyImage() {
                BufferedImage image = ScreenshotComparisonPanel.this.getImage();
                if (image == null) {
                    return;
                }
                CopyImageToClipboard.copy(image);
            }
        });
    }

    private BufferedImage getImage() {
        return this.currentImage;
    }

    private AbstractTestProxy getChild(AbstractTestProxy parent, String childName) {
        for (AbstractTestProxy child : parent.getChildren()) {
            if (!child.getName().equals(childName)) continue;
            return child;
        }
        throw new NoSuchElementException("Could not find child: " + childName);
    }

    private ConfigurationResult getSelectedConfigurationResult() {
        return this.results.get(this.selectedConfigurationInstance.getEncodedString());
    }

    private boolean isPortrait() {
        return this.selectedConfigurationInstance.getEncodedString().endsWith("portrait");
    }

    public void stopListeningToResults() {
        ConfigurationResult selectedConfigurationResult = this.getSelectedConfigurationResult();
        if (selectedConfigurationResult != null) {
            selectedConfigurationResult.removeConfigurationResultListener(this);
        }
    }

    public ConfigurationInstance computeSelectedConfigurationInstance() {
        return new ConfigurationInstance(Lists.newArrayList((Iterable)Iterables.transform(this.myTypeSelections, GET_SELECTED_TYPE)));
    }

    public WipePanel getPanel() {
        return this.wipePanel;
    }

    @Override
    public void updateTest(TestName test, boolean shouldUpdateImage) {
        this.currentTest = test;
        if (shouldUpdateImage) {
            this.updateHeaderBar();
            this.referenceIcon = this.myImageLabel.getIcon();
            this.updateImage();
        }
    }

    @Override
    public void updateStep(int step, boolean shouldUpdateImage) {
        this.currentStep = step;
        if (shouldUpdateImage) {
            this.referenceIcon = this.myImageLabel.getIcon();
            this.updateImage();
        }
    }

    private void createUIComponents() {
    }

    @Override
    public void screenshotsUpdated() {
        this.updateImage();
        this.parent.updateMaxStep();
    }

    static {
        try {
            NO_IMAGE_PORTRAIT = ImageIO.read(ScreenshotComparisonPanel.class.getResourceAsStream("NoImagePortrait.png"));
            NO_IMAGE_PORTRAIT.flush();
            NO_IMAGE_LANSCAPE = ImageIO.read(ScreenshotComparisonPanel.class.getResourceAsStream("NoImageLandscape.png"));
            NO_IMAGE_LANSCAPE.flush();
            LOADING_PORTRAIT = ImageIO.read(ScreenshotComparisonPanel.class.getResourceAsStream("LoadingPortrait.png"));
            LOADING_PORTRAIT.flush();
            LOADING_LANDSCAPE = ImageIO.read(ScreenshotComparisonPanel.class.getResourceAsStream("LoadingLandscape.png"));
            LOADING_PORTRAIT.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        this.myScreenshotPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 3, 0), -1, -1, false, false));
        ((Component)jPanel4).setBackground(new Color(-723724));
        ((Component)jPanel4).setEnabled(false);
        jPanel5.add((Component)jPanel4, "Center");
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-10066330)), null, 0, 0, null, new Color(-16777216)));
        this.myImagePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 2, 3, 3, null, null, null));
        this.myConfigurationChooserPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        ((Component)jPanel2).setBackground(new Color(-1513240));
        jPanel2.setOpaque(false);
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myButtonPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, "North");
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class UpdateImageThread
    extends Thread {
        private final TestName test;
        private final int step;
        private final ConfigurationResult configurationResult;
        private BufferedImage loadedImage;
        private volatile boolean isObsolete = false;

        public UpdateImageThread(TestName test, int step, ConfigurationResult configurationResult) {
            this.test = test;
            this.step = step;
            this.configurationResult = configurationResult;
        }

        public synchronized void makeObsolete() {
            this.isObsolete = true;
        }

        public synchronized boolean isObsolete() {
            return this.isObsolete;
        }

        @Override
        public void run() {
            this.loadedImage = this.configurationResult.getScreenshotForTestAndStep(this.test, this.step);
            if (this.loadedImage != null) {
                ScreenshotComparisonPanel.this.parent.incrementLoadedScreenshotsCount();
            }
            if (this.isObsolete()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ScreenshotComparisonPanel.this.lock;
                    synchronized (object) {
                        if (UpdateImageThread.this.isObsolete()) {
                            return;
                        }
                        ScreenshotComparisonPanel.this.currentImage = UpdateImageThread.this.loadedImage;
                        if (ScreenshotComparisonPanel.this.currentImage == null) {
                            ScreenshotComparisonPanel.this.setStaticImage(StaticImageKind.NO_IMAGE);
                            return;
                        }
                        if (ScreenshotComparisonPanel.this.selectedConfigurationInstance.getEncodedString().endsWith("landscape") && ScreenshotComparisonPanel.this.currentImage.getHeight() > ScreenshotComparisonPanel.this.currentImage.getWidth()) {
                            AffineTransform transform = new AffineTransform();
                            transform.translate(ScreenshotComparisonPanel.this.currentImage.getHeight() / 2, ScreenshotComparisonPanel.this.currentImage.getWidth() / 2);
                            transform.rotate(-1.5707963267948966);
                            transform.translate(-ScreenshotComparisonPanel.this.currentImage.getWidth() / 2, -ScreenshotComparisonPanel.this.currentImage.getHeight() / 2);
                            AffineTransformOp op = new AffineTransformOp(transform, 1);
                            ScreenshotComparisonPanel.this.currentImage = op.filter(ScreenshotComparisonPanel.this.currentImage, null);
                        }
                        int imageWidth = ScreenshotComparisonPanel.this.currentImage.getWidth();
                        int imageHeight = ScreenshotComparisonPanel.this.currentImage.getHeight();
                        if (imageWidth > 533) {
                            imageHeight = imageHeight * 533 / imageWidth;
                            imageWidth = 533;
                        }
                        if (imageHeight > 533) {
                            imageWidth = imageWidth * 533 / imageHeight;
                            imageHeight = 533;
                        }
                        ScreenshotComparisonPanel.this.myImageLabel.setIcon(new ImageIcon(ScreenshotComparisonPanel.this.currentImage.getScaledInstance(imageWidth, imageHeight, 4)));
                        ScreenshotComparisonPanel.this.isLoaded = true;
                        ScreenshotComparisonPanel.this.parent.fitWindow();
                    }
                }
            });
        }
    }

    private static enum StaticImageKind {
        LOADING,
        NO_IMAGE;

    }
}

