/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.editorconfig.language.codeinsight.EditorConfigFoldingBuilder;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/editorconfig/language/codeinsight/EditorConfigFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "COMMENT_FOLD_LENGTH_LIMIT", "", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getPlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "Companion", "intellij.editorconfig"})
public final class EditorConfigFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private final int COMMENT_FOLD_LENGTH_LIMIT;
    private static final Logger Log;
    private static final Regex LINE_BREAK;
    private static final Companion Companion;

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (!(root instanceof EditorConfigPsiFile)) {
            Log.warn("Folding builder was given unexpected element");
            return new FoldingDescriptor[0];
        }
        boolean bl = false;
        List descriptors = new ArrayList();
        Function3<Integer, Integer, PsiElement, Unit> $fun$add$1 = new Function3<Integer, Integer, PsiElement, Unit>(descriptors){
            final /* synthetic */ List $descriptors;

            public final void invoke(int start, int end, @NotNull PsiElement element) {
                TextRange range = new TextRange(start, end);
                FoldingDescriptor descriptor = new FoldingDescriptor(element, range);
                this.$descriptors.add(descriptor);
            }
            {
                this.$descriptors = list;
                super(3);
            }
        };
        Function1<PsiElement, Unit> $fun$findCommentFoldingInChildren$2 = new Function1<PsiElement, Unit>($fun$add$1){
            final /* synthetic */ buildFoldRegions.1 $add$1;

            public final void invoke(@NotNull PsiElement element) {
                PsiComment firstComment = null;
                int start = 0;
                int end = 0;
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof PsiComment) {
                        if (firstComment == null) {
                            start = ((PsiComment)child).getTextRange().getStartOffset();
                            firstComment = (PsiComment)child;
                        }
                        end = ((PsiComment)child).getTextRange().getEndOffset();
                        PsiElement next = ((PsiComment)child).getNextSibling();
                        if (org.editorconfig.language.codeinsight.EditorConfigFoldingBuilder$Companion.access$isLineBreak(EditorConfigFoldingBuilder.access$Companion(), next)) {
                            child = next;
                            continue;
                        }
                        this.$add$1.invoke(start, end, (PsiElement)firstComment);
                        firstComment = null;
                        continue;
                    }
                    if (firstComment != null) {
                        this.$add$1.invoke(start, end, (PsiElement)firstComment);
                        firstComment = null;
                    }
                    this.invoke(child);
                }
                if (firstComment != null) {
                    this.$add$1.invoke(start, end, (PsiElement)firstComment);
                }
            }
            {
                this.$add$1 = var1_1;
                super(1);
            }
        };
        Function1<PsiElement, Unit> $fun$findSectionFoldingInElement$3 = new Function1<PsiElement, Unit>(descriptors){
            final /* synthetic */ List $descriptors;

            public final void invoke(@NotNull PsiElement element) {
                PsiElement psiElement = element;
                if (psiElement instanceof EditorConfigSection) {
                    EditorConfigOption editorConfigOption = (EditorConfigOption)CollectionsKt.firstOrNull(((EditorConfigSection)element).getOptionList());
                    if (editorConfigOption == null || (editorConfigOption = editorConfigOption.getTextRange()) == null) {
                        return;
                    }
                    int start = editorConfigOption.getStartOffset();
                    EditorConfigOption editorConfigOption2 = (EditorConfigOption)CollectionsKt.lastOrNull(((EditorConfigSection)element).getOptionList());
                    if (editorConfigOption2 == null || (editorConfigOption2 = editorConfigOption2.getTextRange()) == null) {
                        return;
                    }
                    int end = editorConfigOption2.getEndOffset();
                    TextRange range = new TextRange(start, end);
                    FoldingDescriptor descriptor = new FoldingDescriptor(element, range);
                    this.$descriptors.add(descriptor);
                } else {
                    PsiElement[] $this$forEach$iv = element.getChildren();
                    boolean $i$f$forEach = false;
                    PsiElement[] psiElementArray = $this$forEach$iv;
                    int n = psiElementArray.length;
                    for (int i = 0; i < n; ++i) {
                        PsiElement element$iv;
                        PsiElement p1 = element$iv = psiElementArray[i];
                        boolean bl = false;
                        this.invoke(p1);
                    }
                }
            }
            {
                this.$descriptors = list;
                super(1);
            }
        };
        $fun$findCommentFoldingInChildren$2.invoke(root);
        $fun$findSectionFoldingInElement$3.invoke(root);
        Collection $this$toTypedArray$iv = descriptors;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FoldingDescriptor[] foldingDescriptorArray = thisCollection$iv.toArray(new FoldingDescriptor[0]);
        if (foldingDescriptorArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return foldingDescriptorArray;
    }

    @NotNull
    public String getPlaceholderText(@NotNull ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.LINE_COMMENT)) {
            string = StringsKt.substring((String)node.getText(), (IntRange)RangesKt.until((int)0, (int)Math.min(node.getTextLength(), this.COMMENT_FOLD_LENGTH_LIMIT))) + "...";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.SECTION)) {
            string = "...";
        } else {
            Log.warn("Requested folding placeholder for unknown node (" + node.getElementType() + ')');
            string = "...";
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }

    public EditorConfigFoldingBuilder() {
        this.COMMENT_FOLD_LENGTH_LIMIT = 40;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Log = Logger.getInstance(EditorConfigFoldingBuilder.class);
        String string = "\\R";
        boolean bl = false;
        LINE_BREAK = new Regex(string);
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/editorconfig/language/codeinsight/EditorConfigFoldingBuilder$Companion;", "", "()V", "LINE_BREAK", "Lkotlin/text/Regex;", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isLineBreak", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.editorconfig"})
    private static final class Companion {
        private final boolean isLineBreak(PsiElement element) {
            return element != null && LINE_BREAK.matches((CharSequence)element.getText());
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isLineBreak(Companion $this, PsiElement element) {
            return $this.isLineBreak(element);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

