/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigNavigationActionsFactory {
    private static final Key<EditorConfigNavigationActionsFactory> NAVIGATION_FACTORY_KEY = Key.create((String)"editor.config.navigation.factory");
    private final List<String> myEditorConfigFilePaths = new ArrayList<String>();
    private static final Object INSTANCE_LOCK = new Object();

    private EditorConfigNavigationActionsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<AnAction> getNavigationActions(@NotNull Project project, @NotNull VirtualFile sourceFile) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        List<String> list = this.myEditorConfigFilePaths;
        synchronized (list) {
            List<VirtualFile> editorConfigFiles = Utils.pathsToFiles(this.myEditorConfigFilePaths);
            for (VirtualFile editorConfigFile : editorConfigFiles) {
                if (editorConfigFile == null) continue;
                actions.add((AnAction)DumbAwareAction.create((String)EditorConfigNavigationActionsFactory.getActionName(editorConfigFile, editorConfigFiles.size() > 1), event -> EditorConfigNavigationActionsFactory.openEditorConfig(project, sourceFile, editorConfigFile)));
            }
        }
        return actions.size() <= 1 ? actions : Collections.singletonList(new NavigationActionGroup(actions.toArray(AnAction.EMPTY_ARRAY)));
    }

    private static void openEditorConfig(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull VirtualFile editorConfigFile) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (fileEditorManager.isFileOpen(editorConfigFile)) {
            fileEditorManager.closeFile(editorConfigFile);
        }
        EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, sourceFile);
        fileEditorManager.openFile(editorConfigFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEditorConfigFilePaths(@NotNull List<String> editorConfigFilePaths) {
        List<String> list = this.myEditorConfigFilePaths;
        synchronized (list) {
            this.myEditorConfigFilePaths.clear();
            this.myEditorConfigFilePaths.addAll(editorConfigFilePaths);
        }
    }

    @NotNull
    private static String getActionName(@NotNull VirtualFile file, boolean withFolder) {
        String fileName = EditorConfigPresentationUtil.getFileName(file, withFolder);
        return !withFolder ? EditorConfigBundle.message("action.open.file") : fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static EditorConfigNavigationActionsFactory getInstance(@NotNull PsiFile psiFile) {
        Project project = psiFile.getProject();
        VirtualFile file = psiFile.getVirtualFile();
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            UserDataHolder dataHolder = CodeStyleCachingService.getInstance((Project)project).getDataHolder(file);
            EditorConfigNavigationActionsFactory instance = null;
            if (dataHolder != null && (instance = (EditorConfigNavigationActionsFactory)dataHolder.getUserData(NAVIGATION_FACTORY_KEY)) == null) {
                instance = new EditorConfigNavigationActionsFactory();
                dataHolder.putUserData(NAVIGATION_FACTORY_KEY, (Object)instance);
            }
            return instance;
        }
    }

    private static class NavigationActionGroup
    extends ActionGroup {
        private final AnAction[] myChildActions;

        private NavigationActionGroup(AnAction[] actions) {
            super(EditorConfigBundle.message("action.open.file"), true);
            this.myChildActions = actions;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return this.myChildActions;
        }
    }
}

