/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.ArrayList;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigActionUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("EditorConfig", NotificationDisplayType.STICKY_BALLOON, true);

    public static AnAction[] createNavigationActions(@NotNull PsiFile file) {
        EditorConfigNavigationActionsFactory navigationActionsFactory = EditorConfigNavigationActionsFactory.getInstance(file);
        if (navigationActionsFactory == null) {
            return AnAction.EMPTY_ARRAY;
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>(navigationActionsFactory.getNavigationActions(file.getProject(), file.getVirtualFile()));
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    public static AnAction createDisableAction(@NotNull Project project, @NotNull String message2) {
        return DumbAwareAction.create((String)message2, e -> {
            EditorConfigSettings settings = (EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = false;
            CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
            EditorConfigActionUtil.showDisabledDetectionNotification(project);
        });
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        EditorConfigDisabledNotification notification = new EditorConfigDisabledNotification(project);
        notification.notify(project);
    }

    public static AnAction createShowEditorConfigFilesAction() {
        return new DumbAwareAction(EditorConfigBundle.message("editor.config.files.show")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project = e.getProject();
                if (project != null) {
                    EditorConfigActionUtil.showEditorConfigFiles(e.getProject(), e);
                }
            }
        };
    }

    public static void showEditorConfigFiles(@NotNull Project project, @NotNull AnActionEvent event) {
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance((Project)project);
        String searchProviderID = "SearchEverywhereContributor.All";
        if (seManager.isShown() && !searchProviderID.equals(seManager.getSelectedContributorID())) {
            seManager.setSelectedContributor(searchProviderID);
        }
        seManager.show(searchProviderID, ".editorconfig", event);
    }

    private static class ReEnableAction
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableAction(@NotNull Project project, Notification notification) {
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CodeStyleSettings rootSettings = CodeStyle.getSettings((Project)this.myProject);
            EditorConfigSettings settings = (EditorConfigSettings)rootSettings.getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = true;
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
            this.myNotification.expire();
        }
    }

    private static class ShowEditorConfigOption
    extends DumbAwareAction {
        private ShowEditorConfigOption(@Nullable String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ShowSettingsUtilImpl.showSettingsDialog((Project)e.getProject(), (String)"preferences.sourceCode", (String)"EditorConfig");
        }
    }

    private static class EditorConfigDisabledNotification
    extends Notification {
        private EditorConfigDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), EditorConfigBundle.message("disabled.notification"), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableAction(project, this));
            this.addAction((AnAction)new ShowEditorConfigOption(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }
}

