/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret;

import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil;", "", "()V", "createIndexByTime", "", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "elements", "", "extractMap", "Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil$MapRepresentation;", "value", "Lcom/sun/jdi/Value;", "MapRepresentation", "kotlin.jvm-debugger.sequence"})
public final class InterpreterUtil {
    @NotNull
    public static final InterpreterUtil INSTANCE;

    @NotNull
    public final MapRepresentation extractMap(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference) || ((ArrayReference)value).length() != 2) {
            throw (Throwable)new UnexpectedValueException("Map should be represented by array with two nested arrays: keys and values");
        }
        Value keys = ((ArrayReference)value).getValue(0);
        Value values = ((ArrayReference)value).getValue(1);
        if (!(keys instanceof ArrayReference) || !(values instanceof ArrayReference) || ((ArrayReference)keys).length() != ((ArrayReference)values).length()) {
            throw (Throwable)new UnexpectedValueException("Keys and values should be arrays with equal counts of elements");
        }
        return new MapRepresentation((ArrayReference)keys, (ArrayReference)values);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, TraceElement> createIndexByTime(@NotNull List<? extends TraceElement> elements) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$associateBy$iv = elements;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void elem;
            TraceElement traceElement = (TraceElement)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Integer n = elem.getTime();
            map2.put(n, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private InterpreterUtil() {
    }

    static {
        InterpreterUtil interpreterUtil;
        INSTANCE = interpreterUtil = new InterpreterUtil();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil$MapRepresentation;", "", "keys", "Lcom/sun/jdi/ArrayReference;", "values", "(Lcom/sun/jdi/ArrayReference;Lcom/sun/jdi/ArrayReference;)V", "getKeys", "()Lcom/sun/jdi/ArrayReference;", "getValues", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.sequence"})
    public static final class MapRepresentation {
        @NotNull
        private final ArrayReference keys;
        @NotNull
        private final ArrayReference values;

        @NotNull
        public final ArrayReference getKeys() {
            return this.keys;
        }

        @NotNull
        public final ArrayReference getValues() {
            return this.values;
        }

        public MapRepresentation(@NotNull ArrayReference keys, @NotNull ArrayReference values) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.keys = keys;
            this.values = values;
        }

        @NotNull
        public final ArrayReference component1() {
            return this.keys;
        }

        @NotNull
        public final ArrayReference component2() {
            return this.values;
        }

        @NotNull
        public final MapRepresentation copy(@NotNull ArrayReference keys, @NotNull ArrayReference values) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return new MapRepresentation(keys, values);
        }

        public static /* synthetic */ MapRepresentation copy$default(MapRepresentation mapRepresentation, ArrayReference arrayReference, ArrayReference arrayReference2, int n, Object object) {
            if ((n & 1) != 0) {
                arrayReference = mapRepresentation.keys;
            }
            if ((n & 2) != 0) {
                arrayReference2 = mapRepresentation.values;
            }
            return mapRepresentation.copy(arrayReference, arrayReference2);
        }

        @NotNull
        public String toString() {
            return "MapRepresentation(keys=" + this.keys + ", values=" + this.values + ")";
        }

        public int hashCode() {
            ArrayReference arrayReference = this.keys;
            ArrayReference arrayReference2 = this.values;
            return (arrayReference != null ? arrayReference.hashCode() : 0) * 31 + (arrayReference2 != null ? arrayReference2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MapRepresentation)) break block3;
                    MapRepresentation mapRepresentation = (MapRepresentation)object;
                    if (!Intrinsics.areEqual((Object)this.keys, (Object)mapRepresentation.keys) || !Intrinsics.areEqual((Object)this.values, (Object)mapRepresentation.values)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

