/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ExpressionHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrCallMatcher;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionWithCopy;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/DefaultProgressionHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ExpressionHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "allowUnsignedBounds", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "rangeClassesTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "matchIterable", "ir.backend.common"})
public final class DefaultProgressionHandler
implements ExpressionHandler {
    @NotNull
    private final CommonBackendContext context;
    private final boolean allowUnsignedBounds;
    @NotNull
    private final Symbols<CommonBackendContext> symbols;
    @NotNull
    private final Set<IrType> rangeClassesTypes;

    /*
     * WARNING - void declaration
     */
    public DefaultProgressionHandler(@NotNull CommonBackendContext context2, boolean allowUnsignedBounds) {
        Collection<IrType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.allowUnsignedBounds = allowUnsignedBounds;
        this.symbols = this.context.getIr().getSymbols();
        Iterable iterable = this.symbols.getRangeClasses();
        DefaultProgressionHandler defaultProgressionHandler = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType = IrTypesKt.getDefaultType((IrClassifierSymbol)it);
            collection.add(irType);
        }
        collection = (List)destination$iv$iv;
        defaultProgressionHandler.rangeClassesTypes = CollectionsKt.toSet((Iterable)collection);
    }

    public /* synthetic */ DefaultProgressionHandler(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return ProgressionType.Companion.fromIrType(expression2.getType(), this.symbols, this.allowUnsignedBounds) != null;
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @NotNull IrSymbol scopeOwner) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(scopeOwner, "scopeOwner");
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$build_u24lambda_u2d4 = declarationIrBuilder;
        boolean bl3 = false;
        Pair pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$build_u24lambda_u2d4, expression2, "progression", null, false, 12, null);
        IrVariable progressionVar = (IrVariable)pair.component1();
        IrExpressionWithCopy progressionExpression = (IrExpressionWithCopy)pair.component2();
        IrClass irClass2 = IrTypesKt.getClass(expression2.getType());
        Intrinsics.checkNotNull(irClass2);
        IrClass progressionClass = irClass2;
        IrBuilderWithScope irBuilderWithScope = $this$build_u24lambda_u2d4;
        Object object = AdditionalIrUtilsKt.getPropertyGetter(progressionClass.getSymbol(), "first");
        Intrinsics.checkNotNull(object);
        object = ExpressionHelpersKt.irCall(irBuilderWithScope, (IrSimpleFunctionSymbol)object);
        boolean bl4 = false;
        boolean bl5 = false;
        Object $this$build_u24lambda_u2d4_u24lambda_u2d422 = object;
        boolean bl6 = false;
        ((IrMemberAccessExpression)$this$build_u24lambda_u2d4_u24lambda_u2d422).setDispatchReceiver(progressionExpression.copy());
        Object first = object;
        IrBuilderWithScope irBuilderWithScope2 = $this$build_u24lambda_u2d4;
        Object object2 = AdditionalIrUtilsKt.getPropertyGetter(progressionClass.getSymbol(), "last");
        Intrinsics.checkNotNull(object2);
        object2 = ExpressionHelpersKt.irCall(irBuilderWithScope2, (IrSimpleFunctionSymbol)object2);
        bl5 = false;
        boolean $this$build_u24lambda_u2d4_u24lambda_u2d422 = false;
        Object $this$build_u24lambda_u2d4_u24lambda_u2d2 = object2;
        boolean bl7 = false;
        ((IrMemberAccessExpression)$this$build_u24lambda_u2d4_u24lambda_u2d2).setDispatchReceiver(progressionExpression.copy());
        Object last = object2;
        boolean isRange = this.rangeClassesTypes.contains(expression2.getType());
        if (isRange) {
            irExpression = ExpressionHelpersKt.irInt$default($this$build_u24lambda_u2d4, 1, null, 2, null);
        } else {
            IrBuilderWithScope irBuilderWithScope3 = $this$build_u24lambda_u2d4;
            Object $this$build_u24lambda_u2d4_u24lambda_u2d422 = AdditionalIrUtilsKt.getPropertyGetter(progressionClass.getSymbol(), "step");
            Intrinsics.checkNotNull($this$build_u24lambda_u2d4_u24lambda_u2d422);
            $this$build_u24lambda_u2d4_u24lambda_u2d422 = ExpressionHelpersKt.irCall(irBuilderWithScope3, (IrSimpleFunctionSymbol)$this$build_u24lambda_u2d4_u24lambda_u2d422);
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$build_u24lambda_u2d4_u24lambda_u2d3 = $this$build_u24lambda_u2d4_u24lambda_u2d422;
            boolean bl10 = false;
            ((IrMemberAccessExpression)$this$build_u24lambda_u2d4_u24lambda_u2d3).setDispatchReceiver(progressionExpression.copy());
            irExpression = (IrExpression)$this$build_u24lambda_u2d4_u24lambda_u2d422;
        }
        IrExpression step = irExpression;
        ProgressionDirection direction = isRange ? ProgressionDirection.INCREASING : ProgressionDirection.UNKNOWN;
        Object object3 = ProgressionType.Companion.fromIrType(expression2.getType(), this.symbols, this.allowUnsignedBounds);
        Intrinsics.checkNotNull(object3);
        ProgressionType progressionType = object3;
        object3 = CollectionsKt.listOfNotNull(progressionVar);
        return new ProgressionHeaderInfo(progressionType, (IrExpression)first, (IrExpression)last, step, false, false, null, direction, (List)object3, 112, null);
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        return ExpressionHandler.DefaultImpls.build(this, expression2, data, scopeOwner);
    }

    @Nullable
    public HeaderInfo handle(@NotNull IrExpression expression2, @Nullable IrCall iteratorCall, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        return ExpressionHandler.DefaultImpls.handle(this, expression2, iteratorCall, data, scopeOwner);
    }

    @Override
    @Nullable
    public IrCallMatcher getIteratorCallMatcher() {
        return ExpressionHandler.DefaultImpls.getIteratorCallMatcher(this);
    }
}

