/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.DataManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesCopyHandler;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class PropertiesCopyHandlerEx
extends PropertiesCopyHandler {
    protected void updateBundleEditors(@NotNull String newName, @NotNull ResourceBundle targetResourceBundle, @NotNull ResourceBundle sourceResourceBundle, @NotNull Project project) {
        if (sourceResourceBundle.equals(targetResourceBundle)) {
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
                if (fileEditor instanceof ResourceBundleEditor) {
                    ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)fileEditor;
                    resourceBundleEditor.updateTreeRoot();
                    resourceBundleEditor.selectProperty(newName);
                }
            });
        } else {
            for (FileEditor editor : FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new ResourceBundleAsVirtualFile(targetResourceBundle), true)) {
                ((ResourceBundleEditor)editor).updateTreeRoot();
                ((ResourceBundleEditor)editor).selectProperty(newName);
            }
        }
    }
}

