/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.ide.common.gradle.model.IdeSigningConfig;
import com.android.tools.idea.instantapp.InstantApps;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostSpecifier;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.UrlAssistColors;
import com.google.urlassistant.UrlAssistIcons;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.util.DalUtils;
import com.google.urlassistant.util.DalVerifier;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.Sha256FingerprintUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigitalAssetLinkWindow
extends JPanel
implements UrlAssistantWindowBase {
    private DocumentListener myKeystorePathDocumentListener;
    private JBTextField myDomainField;
    private JBTextField myPackageIDField;
    private JButton myGenerateButton;
    private JTextPane mySaveFileMessageEditPane;
    private JButton mySaveFileButton;
    private JButton myVerifyButton;
    private JPanel myRootPanel;
    private JPanel myPreviewPanel;
    private JRadioButton myAppKeystoreRadioButton;
    private JRadioButton mySigningConfigRadioButton;
    private JTextField myKeystoreFilePathTextField;
    private JButton myBrowseButton;
    private JPanel myChooseFilePanel;
    private JPanel myCardPanel;
    private JComboBox<String> mySigningConfigComboBox;
    private JComboBox<Module> myModuleComboBox;
    private JTextPane myAddedStatementsTextPane;
    private JTextPane myLinkedStringsTextPane;
    private JTextPane myAddedAutoVerifyTextPane;
    private JPanel myAddedStatementsJPanel;
    private JBLabel myAddedStatementsLabel;
    private JTextPane mySuccessTextPane;
    private JBLabel myAddedAutoVerifyLabel;
    private JBLabel mySuccessLabel;
    private JBLabel myLinkedStringsLabel;
    private JPanel myAddedAutoVerifyPanel;
    private JPanel mySuccessPanel;
    private JPanel myLinkedStringsPanel;
    private JPanel myResultContainerPanel;
    private AsyncProcessIcon myAsyncProcessIcon;
    private JPanel myProgressPanel;
    private JPanel myResultPanel;
    private JEditorPane myPreviewEditorPane;
    private JBLabel mySmallTitleLabel;
    private JTextPane myInstructionTextPane;
    private JBLabel mySelectModuleInstructionLabel;
    private JPanel mySelectModulePanel;
    private JTextPane myKeystoreWarningTextPane;
    private JComboBox<String> myKeyStoreAlias;
    private JCheckBox mySupportSmartLockCheckBox;
    private JBTextField mySignInUrlTextField;
    private JPanel mySmartLockPanel;
    private HyperlinkLabel myWhatIsSmartLockTextPane;
    private JBLabel myDomainErrorMessageLabel;
    private JBLabel mySignInUrlErrorMessageLabel;
    private JBLabel myApplicationIdErrorMessageLabel;
    private JBLabel myKeystoreErrorMessageLabel;
    private JCheckBox mySameAsSiteDomainCheckBox;
    private JPanel myTextFieldPanel;
    private JPanel myKeystorePanel;
    private DalUtils.SigningConfigComboBoxModel mySigningConfigComboBoxModel;
    private Project myProject;
    private CardLayout myCardLayout;
    private String myStringResText;
    private String myFingerprints;
    private String myJsonFileUrl;
    private VirtualFile myStringsFile;
    private List<AndroidFacet> myAndroidFacetList;
    private Color myPanelBackground;
    private Module myCurrentModule;
    private String myLoadedAliases;
    private FullUrl myDomainFullUrl;
    private FullUrl mySignInFullUrl;
    private boolean myIsSmartLockSupported;
    private ItemListener moduleItemListener;
    private HyperlinkListener myHyperlinkListener;

    private static Logger getLog() {
        return Logger.getInstance(DigitalAssetLinkWindow.class);
    }

    public DigitalAssetLinkWindow(@NotNull Project project) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myKeystorePathDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DigitalAssetLinkWindow.this.hideKeyAlias();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DigitalAssetLinkWindow.this.hideKeyAlias();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DigitalAssetLinkWindow.this.hideKeyAlias();
            }
        };
        this.moduleItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DigitalAssetLinkWindow.this.myModuleComboBox.getItemCount() > 0) {
                    DigitalAssetLinkWindow.this.myCurrentModule = (Module)DigitalAssetLinkWindow.this.myModuleComboBox.getSelectedItem();
                    String firstUrl = UrlAssistUtils.getFirstValidUrl(DigitalAssetLinkWindow.this.myCurrentModule);
                    if (StringUtil.isNotEmpty((String)firstUrl)) {
                        DigitalAssetLinkWindow.this.myDomainField.setText(UrlAssistUtils.getFirstValidUrl(DigitalAssetLinkWindow.this.myCurrentModule));
                    }
                    DigitalAssetLinkWindow.this.reloadSigningConfigs();
                    DigitalAssetLinkWindow.this.hideResultPanels();
                }
            }
        };
        this.myHyperlinkListener = e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                BrowserUtil.browse((URL)e.getURL());
            }
        };
        this.myProject = project;
        this.myPanelBackground = this.myPreviewPanel.getBackground();
        this.fillContent();
        ButtonGroup group = new ButtonGroup();
        group.add(this.myAppKeystoreRadioButton);
        group.add(this.mySigningConfigRadioButton);
        this.myAppKeystoreRadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.myCardLayout.first(this.myCardPanel);
            }
        });
        this.mySigningConfigRadioButton.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.myCardLayout.last(this.myCardPanel);
            }
        });
        this.myKeystoreFilePathTextField.addActionListener(e -> this.reloadKeyAliases(this.myKeystoreFilePathTextField.getText()));
        this.myKeystoreFilePathTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DigitalAssetLinkWindow.this.reloadKeyAliases(DigitalAssetLinkWindow.this.myKeystoreFilePathTextField.getText());
            }
        });
        this.hideResultPanels();
        this.add(this.myRootPanel);
    }

    private void createUIComponents() {
        this.myAsyncProcessIcon = new AsyncProcessIcon.Big(UrlAssistantBundle.message("dal.link.and.verify", new Object[0]));
    }

    private void hideKeyAlias() {
        this.myKeyStoreAlias.setVisible(false);
        this.myLoadedAliases = null;
    }

    private void reloadKeyAliases(@NotNull String keystorePath) {
        if (keystorePath.equals(this.myLoadedAliases)) {
            return;
        }
        if (!new File(keystorePath).isFile()) {
            this.hideKeyAlias();
            return;
        }
        List<String> aliases = Sha256FingerprintUtils.getAliases(keystorePath);
        this.myKeyStoreAlias.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(aliases)));
        if (aliases.size() > 1) {
            this.myKeyStoreAlias.setVisible(true);
        } else {
            this.hideKeyAlias();
        }
        this.myLoadedAliases = keystorePath;
    }

    private void fillContent() {
        this.mySaveFileMessageEditPane.addHyperlinkListener(this.myHyperlinkListener);
        this.myCardLayout = (CardLayout)this.myCardPanel.getLayout();
        this.myCardLayout.first(this.myCardPanel);
        this.myGenerateButton.addActionListener(e -> {
            if (!this.generateDalPreviewText()) {
                this.showDalErrorAndHideUi();
            } else {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_GENERATE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
                if (this.mySupportSmartLockCheckBox.isSelected()) {
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
                }
            }
        });
        this.myBrowseButton.addActionListener(e -> {
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false), (Project)this.myProject, null);
            if (virtualFile != null) {
                this.myKeystoreFilePathTextField.getDocument().removeDocumentListener(this.myKeystorePathDocumentListener);
                this.myKeystoreFilePathTextField.setText(virtualFile.getPath());
                this.myKeystoreFilePathTextField.getDocument().addDocumentListener(this.myKeystorePathDocumentListener);
                this.reloadKeyAliases(virtualFile.getPath());
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_BROWSE_KEYSTORE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
            } else {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_BROWSE_KEYSTORE_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
            }
        });
        this.mySaveFileButton.addActionListener(e -> this.saveDalTextAsFile());
        this.myVerifyButton.addActionListener(e -> {
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myCurrentModule);
            if (facet != null && (DalUtils.checkDalStringResourceExists(facet, this.myStringResText) || DalUtils.checkMetaDataInAndroidManifestExists(facet))) {
                DialogBuilder dialogBuilder = new DialogBuilder();
                dialogBuilder.setTitle(UrlAssistantBundle.message("dal.file.save.overwrite.title", new Object[0]));
                dialogBuilder.setCenterPanel((JComponent)new JLabel(UrlAssistantBundle.message("dal.file.save.overwrite.message", new Object[0])));
                dialogBuilder.setOkOperation(() -> {
                    this.linkAndVerify();
                    dialogBuilder.getDialogWrapper().close(0);
                });
                dialogBuilder.setCancelOperation(() -> {
                    this.myResultContainerPanel.setVisible(false);
                    dialogBuilder.getDialogWrapper().close(1);
                });
                dialogBuilder.show();
            } else {
                this.linkAndVerify();
            }
        });
        this.myAddedStatementsTextPane.setBackground(this.myPanelBackground);
        this.myAddedStatementsTextPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(this.myStringsFile, true);
            }
        });
        this.myLinkedStringsTextPane.setBackground(this.myPanelBackground);
        this.myLinkedStringsTextPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                try {
                    VirtualFile virtualFile = ManifestUtils.getAndroidManiFest(this.myAndroidFacetList.get(Integer.valueOf(e.getDescription()) - 1));
                    if (virtualFile != null) {
                        FileEditorManager.getInstance((Project)this.myProject).openFile(virtualFile, true);
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        });
        this.myAddedAutoVerifyTextPane.setBackground(this.myPanelBackground);
        this.mySuccessTextPane.setBackground(this.myPanelBackground);
        this.mySuccessTextPane.addHyperlinkListener(this.myHyperlinkListener);
        this.myKeystoreWarningTextPane.setText(UrlAssistantBundle.message("dal.debug.keystore.warning", new Object[0]));
        this.myKeystoreWarningTextPane.setForeground((Color)UrlAssistColors.SUBTITLE_TEXT_COLOR);
        this.myKeystoreWarningTextPane.setBackground(this.myPanelBackground);
        this.myKeystoreFilePathTextField.getDocument().addDocumentListener(this.myKeystorePathDocumentListener);
        this.myPreviewEditorPane.setBackground(this.myPanelBackground);
        this.mySaveFileMessageEditPane.setBackground(this.myPanelBackground);
        this.myInstructionTextPane.setBackground(this.myPanelBackground);
        this.myInstructionTextPane.setText(UrlAssistantBundle.message("dal.panel.instruction", new Object[0]));
        this.mySmallTitleLabel.setForeground((Color)UrlAssistColors.SUBTITLE_TEXT_COLOR);
        this.myPackageIDField.getEmptyText().setText(UrlAssistantBundle.message("dal.package.id.hint", new Object[0]));
        this.myRootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myDomainField.getEmptyText().setText(UrlAssistantBundle.message("dal.domain.hint", new Object[0]));
        this.mySignInUrlTextField.getEmptyText().setText(UrlAssistantBundle.message("dal.sign.in.url.hint", new Object[0]));
        this.mySignInUrlTextField.setTextToTriggerEmptyTextStatus("https://");
        this.mySignInUrlTextField.setText("https://");
        this.mySupportSmartLockCheckBox.setText(UrlAssistantBundle.message("dal.support.smart.lock.checkbox.text", new Object[0]));
        this.mySupportSmartLockCheckBox.addItemListener(e -> {
            this.mySmartLockPanel.setVisible(!this.mySmartLockPanel.isVisible());
            if (this.mySmartLockPanel.isVisible()) {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            } else {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.EXIT, this.myProject);
            }
        });
        this.mySameAsSiteDomainCheckBox.addItemListener(e -> {
            this.mySignInUrlTextField.setEnabled(!this.mySignInUrlTextField.isEnabled());
            if (!this.mySignInUrlTextField.isEnabled()) {
                this.mySignInUrlTextField.setText(this.myDomainField.getText());
            } else {
                this.mySignInUrlTextField.setText("https://");
            }
        });
        this.myDomainField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!DigitalAssetLinkWindow.this.mySignInUrlTextField.isEnabled()) {
                    DigitalAssetLinkWindow.this.mySignInUrlTextField.setText(DigitalAssetLinkWindow.this.myDomainField.getText());
                }
                if (DigitalAssetLinkWindow.this.myDomainField.getDocument().getLength() == 0 || DigitalAssetLinkWindow.this.generateDomainFullUrl()) {
                    DigitalAssetLinkWindow.this.myDomainErrorMessageLabel.setText("");
                }
            }
        });
        this.mySignInUrlTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (DigitalAssetLinkWindow.this.generateSignInFullUrl()) {
                    DigitalAssetLinkWindow.this.mySignInUrlErrorMessageLabel.setText("");
                }
            }
        });
        this.myWhatIsSmartLockTextPane.setHyperlinkText(UrlAssistantBundle.message("dal.what.is.smart.lock.text", new Object[0]));
        this.myWhatIsSmartLockTextPane.setHyperlinkTarget(UrlAssistantBundle.message("dal.what.is.smart.lock.url", new Object[0]));
        this.myWhatIsSmartLockTextPane.setBackground(this.myPanelBackground);
    }

    private void hideResultPanels() {
        this.myPreviewPanel.setVisible(false);
        this.myResultContainerPanel.setVisible(false);
        this.clearErrorMessages();
    }

    public void reload() {
        Module[] modules;
        this.myModuleComboBox.removeItemListener(this.moduleItemListener);
        this.myModuleComboBox.removeAllItems();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null) continue;
            Module baseFeature = InstantApps.findBaseFeature((Project)this.myProject);
            if (baseFeature != null) {
                this.myModuleComboBox.addItem(baseFeature);
                break;
            }
            if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            this.myModuleComboBox.addItem(module);
        }
        if (this.myCurrentModule != null && this.myCurrentModule.isLoaded()) {
            this.myModuleComboBox.setSelectedItem(this.myCurrentModule);
        } else {
            this.myCurrentModule = (Module)this.myModuleComboBox.getSelectedItem();
        }
        this.myModuleComboBox.addItemListener(this.moduleItemListener);
        if (StringUtil.isEmpty((String)this.myDomainField.getText())) {
            this.myDomainField.setText(UrlAssistUtils.getFirstValidUrl(this.myCurrentModule));
        }
        this.mySelectModulePanel.setVisible(this.myModuleComboBox.getItemCount() > 1);
        this.reloadSigningConfigs();
    }

    private void reloadSigningConfigs() {
        ArrayList<IdeSigningConfig> results = new ArrayList<IdeSigningConfig>();
        this.myPackageIDField.setText(DalUtils.loadSigningConfigsFromGradle(this.myCurrentModule, results));
        if (results.isEmpty()) {
            this.mySigningConfigRadioButton.setEnabled(false);
            this.myAppKeystoreRadioButton.setSelected(true);
        } else {
            this.mySigningConfigRadioButton.setEnabled(true);
            this.mySigningConfigRadioButton.setSelected(true);
            this.mySigningConfigComboBoxModel = new DalUtils.SigningConfigComboBoxModel(results);
            this.mySigningConfigComboBox.setModel(this.mySigningConfigComboBoxModel);
        }
    }

    private boolean generateDalPreviewText() {
        this.clearErrorMessages();
        if (StringUtil.isEmpty((String)this.myPackageIDField.getText())) {
            this.myApplicationIdErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.package.id", new Object[0]));
            return false;
        }
        if (StringUtil.isEmpty((String)this.myDomainField.getText())) {
            this.myDomainErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.domain", new Object[0]));
            return false;
        }
        if (this.myAppKeystoreRadioButton.isSelected() && StringUtil.isEmpty((String)this.myKeystoreFilePathTextField.getText())) {
            this.myKeystoreErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.keystore.file", new Object[0]));
            return false;
        }
        if (this.mySupportSmartLockCheckBox.isSelected() && (StringUtil.isEmpty((String)this.mySignInUrlTextField.getText()) || this.mySignInUrlTextField.getText().equals("https://"))) {
            this.mySignInUrlErrorMessageLabel.setText(UrlAssistantBundle.message("dal.empty.sign.in.url", new Object[0]));
            return false;
        }
        if (this.myAppKeystoreRadioButton.isSelected()) {
            String keystorePath = this.myKeystoreFilePathTextField.getText();
            this.reloadKeyAliases(keystorePath);
            return this.showPreviewText(Sha256FingerprintUtils.generateFingerprints(keystorePath, this.myKeyStoreAlias.getSelectedItem() != null ? this.myKeyStoreAlias.getSelectedItem().toString() : null));
        }
        return this.showPreviewText(this.getFingerPrintsFromSigningConfig());
    }

    private void clearErrorMessages() {
        this.myApplicationIdErrorMessageLabel.setText("");
        this.myDomainErrorMessageLabel.setText("");
        this.myKeystoreErrorMessageLabel.setText("");
        this.mySignInUrlErrorMessageLabel.setText("");
    }

    private void showDalErrorAndHideUi() {
        this.myPreviewPanel.setVisible(false);
        this.myResultContainerPanel.setVisible(false);
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_GENERATE_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
        if (this.mySupportSmartLockCheckBox.isSelected()) {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SMART_LOCK_CHECKBOX, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
        }
    }

    private boolean generateDomainFullUrl() {
        try {
            this.myDomainFullUrl = DalUtils.getFullUrlWithHttps(this.myDomainField.getText());
            if (!HostSpecifier.isValid((String)this.myDomainFullUrl.getHost())) {
                this.myDomainErrorMessageLabel.setText(UrlAssistantBundle.message("add.url.invalid.input.host", new Object[0]));
                return false;
            }
        }
        catch (MalformedURLException e) {
            this.myDomainErrorMessageLabel.setText(UrlAssistantBundle.message("url.malformed", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean generateSignInFullUrl() {
        try {
            if (this.mySupportSmartLockCheckBox.isSelected()) {
                this.mySignInFullUrl = DalUtils.getFullUrlWithHttps(this.mySignInUrlTextField.getText());
                if (!HostSpecifier.isValid((String)this.mySignInFullUrl.getHost())) {
                    this.mySignInUrlErrorMessageLabel.setText(UrlAssistantBundle.message("dal.invalid.sign.in.url", new Object[0]));
                    return false;
                }
            } else {
                this.mySignInFullUrl = null;
            }
        }
        catch (MalformedURLException e) {
            this.mySignInUrlErrorMessageLabel.setText(UrlAssistantBundle.message("dal.invalid.sign.in.url", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean showPreviewText(@NotNull String fingerprints) {
        this.myResultContainerPanel.setVisible(false);
        if (StringUtil.isEmpty((String)fingerprints)) {
            return false;
        }
        this.myFingerprints = fingerprints;
        if (!this.generateDomainFullUrl()) {
            return false;
        }
        if (!this.generateSignInFullUrl()) {
            return false;
        }
        this.myIsSmartLockSupported = this.mySupportSmartLockCheckBox.isSelected();
        this.myPreviewPanel.setVisible(true);
        String digitalAssetLinkText = DalUtils.getDalFileText(this.myPackageIDField.getText(), fingerprints, this.mySignInFullUrl == null ? null : this.mySignInFullUrl.toString());
        this.myStringResText = DalUtils.getDalStringResText(this.myDomainFullUrl.toString());
        this.myPreviewEditorPane.setText(digitalAssetLinkText);
        String jsonFileUrl = DalUtils.getDalJsonFileUrl(this.myDomainFullUrl.toString());
        if (this.mySignInFullUrl == null) {
            this.mySaveFileMessageEditPane.setText(UrlAssistantBundle.message("dal.save.file.message", jsonFileUrl));
        } else {
            String smartLockJsonFileUrl = DalUtils.getDalJsonFileUrl(this.mySignInFullUrl.toString());
            if (jsonFileUrl.equals(smartLockJsonFileUrl)) {
                this.mySaveFileMessageEditPane.setText(UrlAssistantBundle.message("dal.save.file.message", jsonFileUrl));
            } else {
                this.mySaveFileMessageEditPane.setText(UrlAssistantBundle.message("dal.save.file.two.places.message", jsonFileUrl, smartLockJsonFileUrl));
            }
        }
        return true;
    }

    @NotNull
    private String getFingerPrintsFromSigningConfig() {
        IdeSigningConfig signingConfig = this.mySigningConfigComboBoxModel.getSelectedSigningConfig();
        File keystoreFile = signingConfig == null ? null : signingConfig.getStoreFile();
        String alias = signingConfig == null ? null : signingConfig.getKeyAlias();
        return Sha256FingerprintUtils.generateFingerprints(keystoreFile == null ? "" : keystoreFile.getAbsolutePath(), alias);
    }

    private void saveDalTextAsFile() {
        FileSaverDescriptor descriptor = new FileSaverDescriptor(UrlAssistantBundle.message("dal.save.file", new Object[0]), UrlAssistantBundle.message("dal.save.file.as.json", new Object[0]), new String[]{"json"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this.myRootPanel);
        VirtualFileWrapper target = saveFileDialog.save(null, "assetlinks.json");
        if (target == null) {
            return;
        }
        AccessToken writeToken = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
        VirtualFile virtualFile = target.getVirtualFile(true);
        try {
            if (virtualFile != null) {
                virtualFile.setBinaryContent(this.myPreviewEditorPane.getText().getBytes("UTF-8"));
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SAVE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
            } else {
                this.showSaveFailDialog(null);
            }
        }
        catch (IOException e) {
            this.showSaveFailDialog(e);
        }
        writeToken.finish();
    }

    private void linkAndVerify() {
        CardLayout cl = (CardLayout)this.myResultContainerPanel.getLayout();
        cl.last(this.myResultContainerPanel);
        this.myResultContainerPanel.setVisible(true);
        new Thread(() -> {
            this.addResourcesForDal(this.myStringResText);
            DalVerifier dalVerifier = new DalVerifier();
            DalVerifier.ErrorMessage errorMessage = this.checkDalFile(dalVerifier, this.myPackageIDField.getText(), this.myDomainFullUrl.toString(), this.myFingerprints, this.mySignInFullUrl == null ? null : this.mySignInFullUrl.toString());
            ApplicationManager.getApplication().invokeLater(() -> {
                this.mySuccessLabel.setIcon(errorMessage.getErrorCode() == DalVerifier.ErrorCode.SUCCESS ? UrlAssistIcons.SUCCESS_ICON : UrlAssistIcons.FAIL_ICON);
                this.mySuccessTextPane.setText(errorMessage.toMessage());
                cl.first(this.myResultContainerPanel);
            });
        }).start();
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_VERIFY_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
    }

    private void addResourcesForDal(final @NotNull String statementText) {
        this.setResultForAddStringResource(false);
        this.setResultForLinkStringsToManifest(false);
        this.myAddedStatementsJPanel.setVisible(this.myIsSmartLockSupported);
        this.myLinkedStringsPanel.setVisible(this.myIsSmartLockSupported);
        this.setResultForAddAutoVerify(false);
        final AndroidFacet facet = AndroidFacet.getInstance((Module)this.myCurrentModule);
        if (facet != null) {
            new WriteCommandAction<PsiClass>(this.myProject, new PsiFile[0]){

                protected void run(@NotNull Result<PsiClass> result) {
                    if (DigitalAssetLinkWindow.this.myIsSmartLockSupported) {
                        DigitalAssetLinkWindow.this.myStringsFile = DalUtils.addDalStringResource(facet, statementText);
                        DigitalAssetLinkWindow.this.setResultForAddStringResource(DigitalAssetLinkWindow.this.myStringsFile != null);
                        DigitalAssetLinkWindow.this.myAndroidFacetList = DalUtils.addMetaDataToAndroidManifest(facet);
                        DigitalAssetLinkWindow.this.setResultForLinkStringsToManifest(!DigitalAssetLinkWindow.this.myAndroidFacetList.isEmpty());
                    }
                    boolean anySucceeded = UrlAssistUtils.getFacets(DigitalAssetLinkWindow.this.myProject).stream().filter(DalUtils::addAutoVerifyToAppLinks).count() > 0L;
                    DigitalAssetLinkWindow.this.setResultForAddAutoVerify(anySucceeded);
                }
            }.execute();
        }
    }

    private void setResultForAddStringResource(boolean isSuccessful) {
        this.myAddedStatementsTextPane.setText(UrlAssistantBundle.message(isSuccessful ? "dal.add.statements.success" : "dal.add.statements.fail", new Object[0]));
        this.myAddedStatementsLabel.setIcon(isSuccessful ? UrlAssistIcons.SUCCESS_ICON : UrlAssistIcons.FAIL_ICON);
    }

    private void setResultForLinkStringsToManifest(boolean isSuccessful) {
        String finalText;
        this.myLinkedStringsLabel.setIcon(isSuccessful ? UrlAssistIcons.SUCCESS_ICON : UrlAssistIcons.FAIL_ICON);
        if (!isSuccessful) {
            finalText = UrlAssistantBundle.message("dal.linked.strings.fail", new Object[0]);
        } else if (this.myAndroidFacetList.size() == 1) {
            finalText = UrlAssistantBundle.message("dal.linked.strings.success", new Object[0]);
        } else {
            StringBuilder messageBuilder = new StringBuilder(UrlAssistantBundle.message("dal.linked.strings.success.multiple", new Object[0]));
            for (int i = 1; i <= this.myAndroidFacetList.size(); ++i) {
                messageBuilder.append("  ").append(i).append(". <a href=\"").append(i).append("\">AndroidManifest.xml (").append(this.myAndroidFacetList.get(i - 1).getModule().getName()).append(")</a>");
            }
            finalText = messageBuilder.toString();
        }
        this.myLinkedStringsTextPane.setText(finalText);
    }

    private void setResultForAddAutoVerify(boolean isSuccessful) {
        this.myAddedAutoVerifyTextPane.setText(UrlAssistantBundle.message(isSuccessful ? "dal.add.autoverify.success" : "dal.add.autoverify.fail", new Object[0]));
        this.myAddedAutoVerifyLabel.setIcon(isSuccessful ? UrlAssistIcons.SUCCESS_ICON : UrlAssistIcons.FAIL_ICON);
    }

    @VisibleForTesting
    public DalVerifier.ErrorMessage checkDalFile(@NotNull DalVerifier dalVerifier, @NotNull String packageId, @NotNull String domain, @NotNull String fingerprints, @Nullable String signInUrl) {
        DalVerifier.ErrorMessage errorMessage = dalVerifier.validateAssetLinksFile(packageId, domain, fingerprints, false);
        if (DalVerifier.ErrorCode.SUCCESS == errorMessage.getErrorCode() && signInUrl != null) {
            errorMessage = dalVerifier.validateAssetLinksFile(packageId, signInUrl, fingerprints, true);
        }
        return errorMessage;
    }

    private void showSaveFailDialog(@Nullable Exception e) {
        Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.file.save.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        if (e == null) {
            DigitalAssetLinkWindow.getLog().warn("Failed to save the DAL file.");
        } else {
            DigitalAssetLinkWindow.getLog().warn((Throwable)e);
        }
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.DAL_PANEL_SAVE_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
    }

    @Override
    public void selectNotify() {
        this.reload();
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        HyperlinkLabel hyperlinkLabel;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JBTextField jBTextField;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JPanel jPanel4;
        JEditorPane jEditorPane;
        JPanel jPanel5;
        JBLabel jBLabel6;
        JTextPane jTextPane2;
        JPanel jPanel6;
        JBLabel jBLabel7;
        JTextPane jTextPane3;
        JPanel jPanel7;
        JBLabel jBLabel8;
        JTextPane jTextPane4;
        JPanel jPanel8;
        JBLabel jBLabel9;
        JTextPane jTextPane5;
        JPanel jPanel9;
        JPanel jPanel10;
        JPanel jPanel11;
        JButton jButton;
        JButton jButton2;
        JTextPane jTextPane6;
        JPanel jPanel12;
        JButton jButton3;
        JBLabel jBLabel10;
        JButton jButton4;
        JTextField jTextField;
        JPanel jPanel13;
        JPanel jPanel14;
        JTextPane jTextPane7;
        JPanel jPanel15;
        this.createUIComponents();
        this.myRootPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(23, 4, new Insets(20, 30, 20, 30), -1, -1, false, false));
        jPanel15.setFocusCycleRoot(true);
        jPanel15.setFocusTraversalPolicyProvider(false);
        jPanel15.setMinimumSize(new Dimension(1000, 1400));
        jPanel15.setPreferredSize(new Dimension(1000, 1400));
        jPanel15.setRequestFocusEnabled(true);
        this.myInstructionTextPane = jTextPane7 = new JTextPane();
        jTextPane7.setContentType("text/html");
        jTextPane7.setEditable(false);
        jTextPane7.setFocusCycleRoot(false);
        jTextPane7.setFocusable(false);
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            jTextPane7.setFont(font);
        }
        jTextPane7.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        jTextPane7.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel15.add((Component)jTextPane7, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 0, new Dimension(-1, 15), null, null));
        Spacer spacer = new Spacer();
        jPanel15.add((Component)spacer, new GridConstraints(22, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel15.add((Component)spacer2, new GridConstraints(8, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer3 = new Spacer();
        jPanel15.add((Component)spacer3, new GridConstraints(10, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setFocusable(false);
        Font font2 = this.$$$getFont$$$(null, -1, 14, jBLabel11.getFont());
        if (font2 != null) {
            jBLabel11.setFont(font2);
        }
        jBLabel11.setText("SHA256 Fingerprint of signing certificate");
        jPanel15.add((Component)jBLabel11, new GridConstraints(14, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myCardPanel = jPanel14 = new JPanel();
        jPanel14.setLayout(new CardLayout(0, 0));
        jPanel15.add((Component)jPanel14, new GridConstraints(17, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myChooseFilePanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel13, "Card2");
        this.myKeystoreFilePathTextField = jTextField = new JTextField();
        jTextField.setEditable(true);
        jPanel13.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myBrowseButton = jButton4 = new JButton();
        jButton4.setText("Browse");
        jPanel13.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myKeyStoreAlias = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        ((Component)jComboBox).setVisible(false);
        jPanel13.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.myKeystoreErrorMessageLabel = jBLabel10 = new JBLabel();
        jBLabel10.setFocusable(false);
        jBLabel10.setForeground(new Color(-65536));
        jPanel13.add((Component)jBLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel16, "Card3");
        JComboBox jComboBox2 = new JComboBox();
        this.mySigningConfigComboBox = jComboBox2;
        jPanel16.add(jComboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel15.add((Component)spacer4, new GridConstraints(19, 0, 1, 4, 0, 0, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myGenerateButton = jButton3 = new JButton();
        jButton3.setText("Generate Digital Asset Links file");
        jPanel15.add((Component)jButton3, new GridConstraints(20, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myPreviewPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel12).setVisible(true);
        jPanel15.add((Component)jPanel12, new GridConstraints(21, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.mySaveFileMessageEditPane = jTextPane6 = new JTextPane();
        ((Component)jTextPane6).setBackground(new Color(-1513240));
        jTextPane6.setContentType("text/html");
        jTextPane6.setEditable(false);
        jTextPane6.setFocusCycleRoot(false);
        jTextPane6.setFocusable(false);
        Font font3 = UIManager.getFont("Label.font");
        if (font3 != null) {
            jTextPane6.setFont(font3);
        }
        jTextPane6.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel12.add((Component)jTextPane6, new GridConstraints(3, 0, 1, 1, 8, 0, 7, 0, new Dimension(-1, 20), null, null));
        this.mySaveFileButton = jButton2 = new JButton();
        jButton2.setText("Save file");
        jPanel12.add((Component)jButton2, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel12.add((Component)jSeparator, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setFocusable(false);
        Font font4 = this.$$$getFont$$$(null, -1, 14, jBLabel12.getFont());
        if (font4 != null) {
            jBLabel12.setFont(font4);
        }
        jBLabel12.setText("Complete the association");
        jPanel12.add((Component)jBLabel12, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setFocusable(false);
        jBLabel13.setText("Link your Digital Asset Links file with your app and verify that it has been uploaded to the current location.");
        jPanel12.add((Component)jBLabel13, new GridConstraints(8, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myVerifyButton = jButton = new JButton();
        jButton.setText("Link and Verify");
        jPanel12.add((Component)jButton, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setFocusable(false);
        Font font5 = this.$$$getFont$$$(null, -1, 14, jBLabel14.getFont());
        if (font5 != null) {
            jBLabel14.setFont(font5);
        }
        jBLabel14.setText("Preview:");
        jPanel12.add((Component)jBLabel14, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel12.add((Component)spacer5, new GridConstraints(0, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myResultContainerPanel = jPanel11 = new JPanel();
        jPanel11.setLayout(new CardLayout(0, 0));
        jPanel12.add((Component)jPanel11, new GridConstraints(12, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myResultPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.setMinimumSize(new Dimension(-1, 117));
        jPanel10.setPreferredSize(new Dimension(-1, 155));
        jPanel11.add((Component)jPanel10, "Card1");
        this.myAddedStatementsJPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel9).setVisible(true);
        jPanel10.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myAddedStatementsTextPane = jTextPane5 = new JTextPane();
        jTextPane5.setContentType("text/html");
        jTextPane5.setEditable(false);
        jTextPane5.setFocusCycleRoot(false);
        jTextPane5.setFocusable(false);
        Font font6 = UIManager.getFont("Label.font");
        if (font6 != null) {
            jTextPane5.setFont(font6);
        }
        jTextPane5.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        ((Component)jTextPane5).setVisible(true);
        jTextPane5.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel9.add((Component)jTextPane5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddedStatementsLabel = jBLabel9 = new JBLabel();
        jBLabel9.setFocusable(false);
        jPanel9.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLinkedStringsPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setVisible(true);
        jPanel10.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myLinkedStringsTextPane = jTextPane4 = new JTextPane();
        jTextPane4.setContentType("text/html");
        jTextPane4.setEditable(false);
        jTextPane4.setFocusCycleRoot(false);
        jTextPane4.setFocusable(false);
        Font font7 = UIManager.getFont("Label.font");
        if (font7 != null) {
            jTextPane4.setFont(font7);
        }
        jTextPane4.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        ((Component)jTextPane4).setVisible(true);
        jTextPane4.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel8.add((Component)jTextPane4, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myLinkedStringsLabel = jBLabel8 = new JBLabel();
        jBLabel8.setFocusable(false);
        jPanel8.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAddedAutoVerifyPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel7).setVisible(true);
        jPanel10.add((Component)jPanel7, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myAddedAutoVerifyTextPane = jTextPane3 = new JTextPane();
        jTextPane3.setContentType("text/html");
        jTextPane3.setEditable(false);
        jTextPane3.setFocusCycleRoot(false);
        jTextPane3.setFocusable(false);
        Font font8 = UIManager.getFont("Label.font");
        if (font8 != null) {
            jTextPane3.setFont(font8);
        }
        jTextPane3.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        ((Component)jTextPane3).setVisible(true);
        jTextPane3.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel7.add((Component)jTextPane3, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myAddedAutoVerifyLabel = jBLabel7 = new JBLabel();
        jBLabel7.setFocusable(false);
        jPanel7.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySuccessPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setVisible(true);
        jPanel10.add((Component)jPanel6, new GridConstraints(6, 0, 1, 1, 1, 1, 3, 7, null, null, null));
        this.mySuccessTextPane = jTextPane2 = new JTextPane();
        jTextPane2.setContentType("text/html");
        jTextPane2.setEditable(false);
        jTextPane2.setFocusCycleRoot(false);
        jTextPane2.setFocusable(false);
        Font font9 = UIManager.getFont("Label.font");
        if (font9 != null) {
            jTextPane2.setFont(font9);
        }
        jTextPane2.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        ((Component)jTextPane2).setVisible(true);
        jTextPane2.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel6.add((Component)jTextPane2, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.mySuccessLabel = jBLabel6 = new JBLabel();
        jBLabel6.setFocusable(false);
        jPanel6.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel10.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5)));
        Spacer spacer7 = new Spacer();
        jPanel10.add((Component)spacer7, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5)));
        Spacer spacer8 = new Spacer();
        jPanel10.add((Component)spacer8, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5)));
        this.myProgressPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setMinimumSize(new Dimension(-1, -1));
        jPanel11.add((Component)jPanel5, "Card2");
        AsyncProcessIcon asyncProcessIcon = this.myAsyncProcessIcon;
        asyncProcessIcon.setFocusable(false);
        jPanel5.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel15 = new JBLabel();
        jBLabel15.setFocusable(false);
        jBLabel15.setInheritsPopupMenu(false);
        jBLabel15.setOpaque(true);
        jBLabel15.setText("Verifying..");
        jPanel5.add((Component)jBLabel15, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel5.add((Component)spacer9, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel12.add((Component)spacer10, new GridConstraints(9, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 8), new Dimension(-1, 8)));
        Spacer spacer11 = new Spacer();
        jPanel12.add((Component)spacer11, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setFocusable(false);
        jPanel12.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 1, 1, 2, null, null, null));
        this.myPreviewEditorPane = jEditorPane = new JEditorPane();
        ((Component)jEditorPane).setBackground(new Color(-1513240));
        jEditorPane.setEditable(false);
        jEditorPane.setFocusCycleRoot(false);
        jEditorPane.setFocusable(true);
        jEditorPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
        jBScrollPane.setViewportView(jEditorPane);
        Spacer spacer12 = new Spacer();
        jPanel12.add((Component)spacer12, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer13 = new Spacer();
        jPanel12.add((Component)spacer13, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 8), new Dimension(-1, 8)));
        this.myTextFieldPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel4.setFocusCycleRoot(false);
        jPanel15.add((Component)jPanel4, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myDomainField = jBTextField3 = new JBTextField();
        jPanel4.add((Component)jBTextField3, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel16 = new JBLabel();
        jBLabel16.setFocusable(false);
        Font font10 = this.$$$getFont$$$(null, -1, 14, jBLabel16.getFont());
        if (font10 != null) {
            jBLabel16.setFont(font10);
        }
        jBLabel16.setText("Site domain");
        jPanel4.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageIDField = jBTextField2 = new JBTextField();
        jBTextField2.setAutoscrolls(true);
        jPanel4.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel17 = new JBLabel();
        jBLabel17.setFocusable(false);
        Font font11 = this.$$$getFont$$$(null, -1, 14, jBLabel17.getFont());
        if (font11 != null) {
            jBLabel17.setFont(font11);
        }
        jBLabel17.setText("Application ID");
        jPanel4.add((Component)jBLabel17, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDomainErrorMessageLabel = jBLabel5 = new JBLabel();
        jBLabel5.setFocusable(false);
        jBLabel5.setForeground(new Color(-65536));
        jPanel4.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myApplicationIdErrorMessageLabel = jBLabel4 = new JBLabel();
        jBLabel4.setFocusable(false);
        jBLabel4.setForeground(new Color(-65536));
        jPanel4.add((Component)jBLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.mySmallTitleLabel = jBLabel3 = new JBLabel();
        jBLabel3.setFocusable(false);
        Font font12 = this.$$$getFont$$$(null, -1, 12, jBLabel3.getFont());
        if (font12 != null) {
            jBLabel3.setFont(font12);
        }
        jBLabel3.setText("Android App Links Support");
        jPanel15.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 2, 10, 0, 0, 0, null, null, null));
        JBLabel jBLabel18 = new JBLabel();
        jBLabel18.setFocusable(false);
        jBLabel18.setIcon(new ImageIcon(this.getClass().getResource("/url_assistant/step_three.png")));
        jPanel15.add((Component)jBLabel18, new GridConstraints(1, 0, 2, 1, 0, 0, 0, 0, null, new Dimension(50, 50), null));
        JBLabel jBLabel19 = new JBLabel();
        jBLabel19.setFocusable(false);
        Font font13 = this.$$$getFont$$$(null, -1, 22, jBLabel19.getFont());
        if (font13 != null) {
            jBLabel19.setFont(font13);
        }
        jBLabel19.setText("Declare Website Association");
        jBLabel19.setVerticalAlignment(1);
        jBLabel19.setVerticalTextPosition(1);
        jPanel15.add((Component)jBLabel19, new GridConstraints(2, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel15.add((Component)jSeparator2, new GridConstraints(9, 0, 1, 4, 0, 1, 0, 0, null, null, null));
        this.myKeystorePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel3, new GridConstraints(16, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myAppKeystoreRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Select keystore file");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.mySigningConfigRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(2, 2, 2, 100));
        jRadioButton.setText("Signing config");
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel20 = new JBLabel();
        jBLabel20.setFocusable(false);
        jBLabel20.setText("Specify either the signing config or the keystore file used to sign your app to obtain the SHA256 fingerprint.");
        jPanel15.add((Component)jBLabel20, new GridConstraints(15, 0, 1, 4, 0, 1, 0, 0, null, null, null));
        Spacer spacer14 = new Spacer();
        jPanel15.add((Component)spacer14, new GridConstraints(5, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 7), new Dimension(-1, 7)));
        this.mySelectModulePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel2, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.mySelectModuleInstructionLabel = jBLabel2 = new JBLabel();
        jBLabel2.setFocusable(false);
        jBLabel2.setText("Select a module you want to work on");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myModuleComboBox = jComboBox3;
        jPanel2.add(jComboBox3, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer15 = new Spacer();
        jPanel2.add((Component)spacer15, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer16 = new Spacer();
        jPanel15.add((Component)spacer16, new GridConstraints(3, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.mySupportSmartLockCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(true);
        Font font14 = UIManager.getFont("Label.font");
        if (font14 != null) {
            jCheckBox2.setFont(font14);
        }
        jCheckBox2.setText("Support Smart Lock for Passwords");
        jPanel15.add((Component)jCheckBox2, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySmartLockPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setVisible(false);
        jPanel15.add((Component)jPanel, new GridConstraints(12, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        JBLabel jBLabel21 = new JBLabel();
        jBLabel21.setFocusable(false);
        jBLabel21.setText("Sign in URL");
        jPanel.add((Component)jBLabel21, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySignInUrlTextField = jBTextField = new JBTextField();
        jBTextField.setEditable(true);
        jBTextField.setEnabled(true);
        jBTextField.setFocusable(true);
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.mySignInUrlErrorMessageLabel = jBLabel = new JBLabel();
        jBLabel.setFocusable(false);
        jBLabel.setForeground(new Color(-65536));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySameAsSiteDomainCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Sign in URL is the same as site domain");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer17 = new Spacer();
        jPanel15.add((Component)spacer17, new GridConstraints(13, 0, 1, 4, 0, 2, 1, 0, null, new Dimension(-1, 13), new Dimension(-1, 13)));
        this.myWhatIsSmartLockTextPane = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setFocusable(false);
        Font font15 = UIManager.getFont("Label.font");
        if (font15 != null) {
            hyperlinkLabel.setFont(font15);
        }
        hyperlinkLabel.setRequestFocusEnabled(true);
        hyperlinkLabel.setVerifyInputWhenFocusTarget(true);
        jPanel15.add((Component)hyperlinkLabel, new GridConstraints(11, 2, 1, 1, 8, 0, 3, 1, null, null, null));
        Spacer spacer18 = new Spacer();
        jPanel15.add((Component)spacer18, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 1, null, null, null));
        Spacer spacer19 = new Spacer();
        jPanel15.add((Component)spacer19, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myKeystoreWarningTextPane = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setFocusCycleRoot(false);
        jTextPane.setFocusable(false);
        Font font16 = UIManager.getFont("Label.font");
        if (font16 != null) {
            jTextPane.setFont(font16);
        }
        jTextPane.setText("");
        jPanel15.add((Component)jTextPane, new GridConstraints(18, 0, 1, 4, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

