/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.editor;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.google.urlassistant.UrlAssistIcons;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.ui.AppLinkTestingWindow;
import com.google.urlassistant.ui.DigitalAssetLinkWindow;
import com.google.urlassistant.ui.UrlAssistantWindow;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlAssistantVirtualFile
extends LightVirtualFile {
    private Project myProject;
    private UrlAssistantWindowBase myWindow;

    public UrlAssistantVirtualFile(@NotNull Project project, @NotNull String name) {
        super(name);
        this.myProject = project;
    }

    @NotNull
    public UrlAssistantWindowBase getEditorWindow() {
        if (this.myWindow != null) {
            return this.myWindow;
        }
        if (UrlAssistantBundle.message("test.url.launch.url.panel.title", new Object[0]).equals(this.getName())) {
            this.myWindow = new AppLinkTestingWindow(this.myProject);
        } else if (UrlAssistantBundle.message("dal.title", new Object[0]).equals(this.getName())) {
            this.myWindow = new DigitalAssetLinkWindow(this.myProject);
        } else if (UrlAssistantBundle.message("url.assistant.editor.title", new Object[0]).equals(this.getName())) {
            this.myWindow = new UrlAssistantWindow(this.myProject);
        }
        return this.myWindow;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public FileType getFileType() {
        return UrlAssistantVirtualFileBaseType.INSTANCE;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    public static UrlAssistantVirtualFile createVirtualFile(Project project, String name) {
        return new UrlAssistantVirtualFile(project, name);
    }

    private static class UrlAssistantVirtualFileBaseType
    extends FakeFileType {
        public static final UrlAssistantVirtualFileBaseType INSTANCE = new UrlAssistantVirtualFileBaseType();

        private UrlAssistantVirtualFileBaseType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            return file.getFileType() instanceof UrlAssistantVirtualFileBaseType;
        }

        @NotNull
        public String getName() {
            return "UrlAssistantVirtualFileType";
        }

        @NotNull
        public String getDescription() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return UrlAssistIcons.ACTION_ICON;
        }
    }
}

