/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.RuntimeDictionaryProvider;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.grazie.GrazieSpellCheckerEngine;
import com.intellij.spellchecker.grazie.GrazieSuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.CachedDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SpellCheckerManager.class);
    private static final int MAX_METRICS = 1;
    public static final String PROJECT = "project";
    public static final String APP = "application";
    private final Project project;
    private ProjectDictionary myProjectDictionary;
    private EditableDictionary myAppDictionary;
    private final SpellCheckerSettings settings;
    private final VirtualFileListener myCustomDictFileListener;
    private final String myProjectDictionaryPath;
    private final String myAppDictionaryPath;
    public static final String PROJECT_DICTIONARY_PATH = "dictionaries" + File.separator + System.getProperty("user.name").replace('.', '_') + ".xml";
    public static final String CACHED_DICTIONARY_FILE = "cachedDictionary.xml";
    private final EventDispatcher<DictionaryStateListener> myUserDictionaryListenerEventDispatcher = EventDispatcher.create(DictionaryStateListener.class);
    private SpellCheckerEngine mySpellChecker;
    private SuggestionProvider mySuggestionProvider;

    public static SpellCheckerManager getInstance(Project project) {
        return (SpellCheckerManager)ServiceManager.getService((Project)project, SpellCheckerManager.class);
    }

    public SpellCheckerManager(Project project) {
        this.project = project;
        this.settings = SpellCheckerSettings.getInstance(project);
        this.mySpellChecker = new GrazieSpellCheckerEngine(project);
        this.mySuggestionProvider = new GrazieSuggestionProvider(this.mySpellChecker);
        this.fullConfigurationReload();
        VirtualFile projectStoreDir = project.getBaseDir() != null ? ProjectKt.getProjectStoreDirectory((VirtualFile)project.getBaseDir()) : null;
        this.myProjectDictionaryPath = projectStoreDir != null ? projectStoreDir.getPath() + File.separator + PROJECT_DICTIONARY_PATH : "";
        this.myAppDictionaryPath = PathManager.getOptionsPath() + File.separator + CACHED_DICTIONARY_FILE;
        this.myCustomDictFileListener = new CustomDictFileListener(this.settings);
        LocalFileSystem.getInstance().addVirtualFileListener(this.myCustomDictFileListener);
        BundledDictionaryProvider.EP_NAME.addChangeListener(this::fillEngineDictionary, (Disposable)this);
        RuntimeDictionaryProvider.EP_NAME.addChangeListener(this::fillEngineDictionary, (Disposable)this);
        CustomDictionaryProvider.EP_NAME.addChangeListener(this::fillEngineDictionary, (Disposable)this);
    }

    public SpellCheckerEngine getSpellChecker() {
        return this.mySpellChecker;
    }

    public void fullConfigurationReload() {
        this.mySpellChecker = new GrazieSpellCheckerEngine(this.project);
        this.mySuggestionProvider = new GrazieSuggestionProvider(this.mySpellChecker);
        this.fillEngineDictionary();
    }

    public void updateBundledDictionaries(List<String> removedDictionaries) {
        for (Object provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            for (String string : provider.getBundledDictionaries()) {
                if (this.mySpellChecker.isDictionaryLoad(string)) continue;
                this.loadBundledDictionary((BundledDictionaryProvider)provider, string);
            }
        }
        for (Object provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            for (Dictionary dictionary : provider.getDictionaries()) {
                boolean dictionaryShouldBeLoad = this.settings == null || !this.settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName());
                boolean dictionaryIsLoad = this.mySpellChecker.isDictionaryLoad(dictionary.getName());
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.mySpellChecker.removeDictionary(dictionary.getName());
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                this.loadRuntimeDictionary(dictionary);
            }
        }
        if (this.settings != null && this.settings.getCustomDictionariesPaths() != null) {
            for (String dictionary : this.settings.getCustomDictionariesPaths()) {
                if (this.mySpellChecker.isDictionaryLoad(dictionary)) continue;
                this.loadDictionary(dictionary);
            }
        }
        if (!ContainerUtil.isEmpty(removedDictionaries)) {
            for (String name : removedDictionaries) {
                this.mySpellChecker.removeDictionary(name);
            }
        }
        SpellCheckerManager.restartInspections();
    }

    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Set<String> getUserDictionaryWords() {
        return ContainerUtil.union(this.myProjectDictionary.getEditableWords(), this.myAppDictionary.getEditableWords());
    }

    private void fillEngineDictionary() {
        this.mySpellChecker.reset();
        this.loadBundledDictionaries();
        this.loadRuntimeDictionaries();
        this.loadCustomDictionaries();
        this.initUserDictionaries();
    }

    private void loadBundledDictionaries() {
        for (BundledDictionaryProvider provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            for (String dictionary : provider.getBundledDictionaries()) {
                this.loadBundledDictionary(provider, dictionary);
            }
        }
    }

    private void loadRuntimeDictionaries() {
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            for (Dictionary dictionary : provider.getDictionaries()) {
                if (this.settings != null && this.settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName())) continue;
                this.loadRuntimeDictionary(dictionary);
            }
        }
    }

    private void loadCustomDictionaries() {
        if (this.settings != null && this.settings.getCustomDictionariesPaths() != null) {
            this.settings.getCustomDictionariesPaths().forEach(this::loadDictionary);
        }
    }

    private void initUserDictionaries() {
        CachedDictionaryState cachedDictionaryState = CachedDictionaryState.getInstance();
        cachedDictionaryState.addCachedDictListener(dict -> SpellCheckerManager.restartInspections());
        if (cachedDictionaryState.getDictionary() == null) {
            cachedDictionaryState.setDictionary(new UserDictionary("cached"));
        }
        this.myAppDictionary = cachedDictionaryState.getDictionary();
        this.mySpellChecker.addModifiableDictionary(this.myAppDictionary);
        ProjectDictionaryState dictionaryState = (ProjectDictionaryState)ServiceManager.getService((Project)this.project, ProjectDictionaryState.class);
        dictionaryState.addProjectDictListener(dict -> SpellCheckerManager.restartInspections());
        this.myProjectDictionary = dictionaryState.getProjectDictionary();
        this.myProjectDictionary.setActiveName(System.getProperty("user.name"));
        this.mySpellChecker.addModifiableDictionary(this.myProjectDictionary);
    }

    private void loadDictionary(@NotNull String path) {
        CustomDictionaryProvider dictionaryProvider = SpellCheckerManager.findApplicable(path);
        if (dictionaryProvider != null) {
            Dictionary dictionary = dictionaryProvider.get(path);
            if (dictionary != null) {
                this.mySpellChecker.addDictionary(dictionary);
            }
        } else {
            this.mySpellChecker.loadDictionary(new FileLoader(path));
        }
    }

    private void loadBundledDictionary(@NotNull BundledDictionaryProvider provider, @NotNull String dictionary) {
        Class<?> loaderClass = provider.getClass();
        InputStream stream = loaderClass.getResourceAsStream(dictionary);
        if (stream != null) {
            this.mySpellChecker.loadDictionary(new StreamLoader(stream, dictionary));
        } else {
            LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
        }
    }

    private void loadRuntimeDictionary(@NotNull Dictionary dictionary) {
        this.mySpellChecker.addDictionary(dictionary);
    }

    public boolean hasProblem(@NotNull String word) {
        return !this.mySpellChecker.isCorrect(word);
    }

    public void acceptWordAsCorrect(@NotNull String word, Project project) {
        this.acceptWordAsCorrect(word, null, project, DictionaryLevel.PROJECT);
    }

    public void acceptWordAsCorrect(@NotNull String word, @Nullable VirtualFile file, @NotNull Project project, @NotNull DictionaryLevel dictionaryLevel) {
        EditableDictionary dictionary;
        if (DictionaryLevel.NOT_SPECIFIED == dictionaryLevel) {
            return;
        }
        final String transformed = this.mySpellChecker.getTransformation().transform(word);
        EditableDictionary editableDictionary = dictionary = DictionaryLevel.PROJECT == dictionaryLevel ? this.myProjectDictionary : this.myAppDictionary;
        if (transformed != null) {
            if (file != null) {
                WriteCommandAction.writeCommandAction((Project)project).run(() -> UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{file}){

                    public void undo() {
                        SpellCheckerManager.this.removeWordFromDictionary(dictionary, transformed);
                    }

                    public void redo() {
                        SpellCheckerManager.this.addWordToDictionary(dictionary, transformed);
                    }
                }));
            }
            this.addWordToDictionary(dictionary, transformed);
        }
    }

    private void addWordToDictionary(@NotNull EditableDictionary dictionary, @NotNull String word) {
        dictionary.addToDictionary(word);
        this.fireDictionaryChanged(dictionary);
    }

    private void removeWordFromDictionary(@NotNull EditableDictionary dictionary, String transformed) {
        dictionary.removeFromDictionary(transformed);
        this.fireDictionaryChanged(dictionary);
    }

    private void fireDictionaryChanged(@NotNull EditableDictionary dictionary) {
        ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(dictionary);
        SpellCheckerManager.restartInspections();
        SaveAndSyncHandler.getInstance().scheduleProjectSave(this.project);
    }

    public void updateUserDictionary(@NotNull Collection<String> words) {
        Collection addedToProjectWords = ContainerUtil.subtract(words, this.getUserDictionaryWords());
        addedToProjectWords.forEach(this.myProjectDictionary::addToDictionary);
        Collection deletedFromProjectWords = ContainerUtil.subtract(this.myProjectDictionary.getEditableWords(), words);
        deletedFromProjectWords.forEach(this.myProjectDictionary::removeFromDictionary);
        if (addedToProjectWords.size() + deletedFromProjectWords.size() > 0) {
            ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.myProjectDictionary);
        }
        Collection deletedFromApplicationWords = ContainerUtil.subtract(this.myAppDictionary.getEditableWords(), words);
        deletedFromApplicationWords.forEach(this.myAppDictionary::removeFromDictionary);
        if (deletedFromApplicationWords.size() > 0) {
            ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.myAppDictionary);
        }
        SpellCheckerManager.restartInspections();
    }

    @NotNull
    public static List<String> getBundledDictionaries() {
        ArrayList<String> dictionaries = new ArrayList<String>();
        for (BundledDictionaryProvider provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getBundledDictionaries());
        }
        return dictionaries;
    }

    @NotNull
    public static List<Dictionary> getRuntimeDictionaries() {
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getDictionaries());
        }
        return dictionaries;
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        int correctionsLimit = Registry.intValue((String)"spellchecker.corrections.limit", (int)5);
        return this.mySuggestionProvider.getSuggestions(text, correctionsLimit, 1);
    }

    public static void restartInspections() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project[] projects;
            for (Project project1 : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (!project1.isInitialized() || !project1.isOpen() || project1.isDefault()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project1).restart();
            }
        });
    }

    @Nullable
    private static CustomDictionaryProvider findApplicable(@NotNull String path) {
        return CustomDictionaryProvider.EP_NAME.getExtensionList().stream().filter(dictionaryProvider -> dictionaryProvider.isApplicable(path)).findAny().orElse(null);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myCustomDictFileListener);
    }

    @NotNull
    public String getProjectDictionaryPath() {
        return this.myProjectDictionaryPath;
    }

    @NotNull
    public String getAppDictionaryPath() {
        return this.myAppDictionaryPath;
    }

    public void openDictionaryInEditor(@NotNull String dictPath) {
        VirtualFile file;
        VirtualFile virtualFile = file = StringUtil.isEmpty((String)dictPath) ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(dictPath);
        if (file == null) {
            String title = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
            String message = SpellCheckerBundle.message("dictionary.not.found", dictPath);
            Messages.showMessageDialog((Project)this.project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
            return;
        }
        FileEditorManager fileManager = FileEditorManager.getInstance((Project)this.project);
        if (fileManager != null) {
            fileManager.openFile(file, true);
        }
    }

    public void addUserDictionaryChangedListener(DictionaryStateListener listener, Disposable parentDisposable) {
        this.myUserDictionaryListenerEventDispatcher.addListener((EventListener)listener);
        Disposer.register((Disposable)parentDisposable, () -> this.myUserDictionaryListenerEventDispatcher.removeListener((EventListener)listener));
    }

    private class CustomDictFileListener
    implements VirtualFileListener {
        private final SpellCheckerSettings mySettings;

        CustomDictFileListener(SpellCheckerSettings settings) {
            this.mySettings = settings;
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            this.removeCustomDictionaries(event.getFile().getPath());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            this.loadCustomDictionaries(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String oldPath = event.getOldParent().getPath() + File.separator + event.getFileName();
            if (!this.affectCustomDicts(oldPath)) {
                this.loadCustomDictionaries(event.getFile());
            } else {
                String newPath = event.getNewParent().getPath() + File.separator + event.getFileName();
                if (!this.affectCustomDicts(newPath)) {
                    this.removeCustomDictionaries(oldPath);
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            String path = FileUtilRt.toSystemDependentName((String)event.getFile().getPath());
            if (!SpellCheckerManager.this.mySpellChecker.isDictionaryLoad(path)) {
                return;
            }
            SpellCheckerManager.this.mySpellChecker.removeDictionary(path);
            SpellCheckerManager.this.loadDictionary(path);
            SpellCheckerManager.restartInspections();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file = event.getFile();
            if (file.isDirectory()) {
                return;
            }
            if ("name".equals(event.getPropertyName())) {
                String oldName = (String)event.getOldValue();
                if (!this.isDic(oldName)) {
                    this.loadCustomDictionaries(file);
                } else {
                    String newName = (String)event.getNewValue();
                    if (!this.isDic(newName)) {
                        this.removeCustomDictionaries(file.getParent().getPath() + File.separator + oldName);
                    }
                }
            }
        }

        private void removeCustomDictionaries(@NotNull String path) {
            String systemDependentPath = FileUtilRt.toSystemDependentName((String)path);
            if (this.affectCustomDicts(path)) {
                SpellCheckerManager.this.mySpellChecker.removeDictionariesRecursively(systemDependentPath);
                this.mySettings.getCustomDictionariesPaths().removeIf(dict -> FileUtil.isAncestor((String)systemDependentPath, (String)dict, (boolean)false));
                SpellCheckerManager.restartInspections();
            }
        }

        private void loadCustomDictionaries(@NotNull VirtualFile file) {
            String path = FileUtilRt.toSystemDependentName((String)file.getPath());
            if (!this.affectCustomDicts(path)) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    boolean isDirectory = file.isDirectory();
                    String path = file.getPath();
                    if (!isDirectory && CustomDictFileListener.this.mySettings.getCustomDictionariesPaths().contains(path)) {
                        SpellCheckerManager.this.loadDictionary(path);
                        SpellCheckerManager.restartInspections();
                    }
                    return isDirectory;
                }
            });
        }

        private boolean isDic(String path) {
            return FileUtilRt.extensionEquals((String)path, (String)"dic");
        }

        private boolean affectCustomDicts(@NotNull String path) {
            return this.mySettings.getCustomDictionariesPaths().stream().anyMatch(dicPath -> FileUtil.isAncestor((String)path, (String)dicPath, (boolean)false));
        }
    }

    public static enum DictionaryLevel {
        APP("application-level"),
        PROJECT("project-level"),
        NOT_SPECIFIED("not specified");

        private final String myName;
        private static final Map<String, DictionaryLevel> DICTIONARY_LEVELS;

        private DictionaryLevel(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        @NotNull
        public static DictionaryLevel getLevelByName(@NotNull String name) {
            return DICTIONARY_LEVELS.getOrDefault(name, NOT_SPECIFIED);
        }

        static {
            DICTIONARY_LEVELS = Maps.uniqueIndex(EnumSet.allOf(DictionaryLevel.class), DictionaryLevel::getName);
        }
    }
}

