/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShFileType;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShellcheckSetupNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"sh.shellcheck.installation");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file.getFileType() instanceof ShFileType && !ShShellcheckUtil.isValidPath(ShSettings.getShellcheckPath())) {
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(ShBundle.message("sh.shellcheck.install.question", new Object[0]));
            Runnable onSuccess = () -> {
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
                }
                Notifications.Bus.notify((Notification)new Notification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.title.case", new Object[0]), ShBundle.message("sh.shellcheck.success.install", new Object[0]), NotificationType.INFORMATION));
            };
            Runnable onFailure = () -> Notifications.Bus.notify((Notification)new Notification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.title.case", new Object[0]), ShBundle.message("sh.shellcheck.cannot.download", new Object[0]), NotificationType.ERROR));
            panel.createActionLabel(ShBundle.message("sh.install", new Object[0]), () -> ShShellcheckUtil.download(null, onSuccess, onFailure));
            panel.createActionLabel(ShBundle.message("sh.no.thanks", new Object[0]), () -> {
                ShSettings.setShellcheckPath("I do mind");
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            return panel;
        }
        return null;
    }
}

