/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import org.jetbrains.annotations.NotNull;

public class ShRunConfigurationProducer
extends LazyRunConfigurationProducer<ShRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ShConfigurationType.getInstance();
    }

    protected boolean setupConfigurationFromContext(@NotNull ShRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile psiFile = ((PsiElement)sourceElement.get()).getContainingFile();
        if (!(psiFile instanceof ShFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String defaultShell = ShConfigurationType.getDefaultShell();
        if (defaultShell != null) {
            configuration.setInterpreterPath(defaultShell);
        }
        configuration.setScriptWorkingDirectory(virtualFile.getParent().getPath());
        configuration.setName(virtualFile.getPresentableName());
        configuration.setScriptPath(virtualFile.getPath());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull ShRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement psiLocation = context.getPsiLocation();
        if (psiLocation == null) {
            return false;
        }
        PsiFile psiFile = psiLocation.getContainingFile();
        if (!(psiFile instanceof ShFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String scriptPath = configuration.getScriptPath();
        String workingDirectory = configuration.getScriptWorkingDirectory();
        return scriptPath != null && scriptPath.equals(virtualFile.getPath()) && workingDirectory != null && workingDirectory.equals(virtualFile.getParent().getPath());
    }
}

