/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClassIndexKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u001e\u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e0\u00140\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirGlobalClassGenerationProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "generateClass", "", "extension", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "owners", "", "newClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "generateClasses", "declarations", "Lkotlin/Pair;", "process", "resolve"})
public final class FirGlobalClassGenerationProcessor
extends FirGlobalResolveProcessor {
    public FirGlobalClassGenerationProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, scopeSession);
    }

    @Override
    public void process() {
        List<FirDeclarationGenerationExtension> extensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        if (extensions.isEmpty()) {
            return;
        }
        FirPredicateBasedProvider provider = FirPredicateBasedProviderKt.getPredicateBasedProvider(this.getSession());
        block0: for (FirDeclarationGenerationExtension extension : extensions) {
            List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> annotatedDeclarations = provider.getSymbolsWithOwnersByPredicate(extension.getPredicate());
            while (true) {
                Collection collection = annotatedDeclarations;
                boolean bl = false;
                if (!(!collection.isEmpty())) continue block0;
                List<FirRegularClass> newClasses = this.generateClasses(annotatedDeclarations, extension);
                annotatedDeclarations = provider.getSymbolsWithOwnersByPredicate((Collection<? extends FirAnnotatedDeclaration>)newClasses, extension.getPredicate());
            }
        }
    }

    private final List<FirRegularClass> generateClasses(List<? extends Pair<? extends FirAnnotatedDeclaration, ? extends List<? extends FirAnnotatedDeclaration>>> declarations2, FirDeclarationGenerationExtension extension) {
        boolean bl = false;
        List newClasses = new ArrayList();
        for (Pair<? extends FirAnnotatedDeclaration, ? extends List<? extends FirAnnotatedDeclaration>> pair : declarations2) {
            FirAnnotatedDeclaration declaration = (FirAnnotatedDeclaration)pair.component1();
            List owners = (List)pair.component2();
            this.generateClass(extension, declaration, owners, newClasses);
        }
        return newClasses;
    }

    private final void generateClass(FirDeclarationGenerationExtension extension, FirAnnotatedDeclaration declaration, List<? extends FirAnnotatedDeclaration> owners, List<FirRegularClass> newClasses) {
        List<FirDeclarationGenerationExtension.GeneratedDeclaration<FirRegularClass>> generatedClasses = extension.generateClasses(declaration, owners);
        for (FirDeclarationGenerationExtension.GeneratedDeclaration<FirRegularClass> generatedDeclaration : generatedClasses) {
            FirRegularClass klass = generatedDeclaration.component1();
            FirAnnotatedDeclaration owner = generatedDeclaration.component2();
            Object object = owner;
            if (object instanceof FirRegularClass) {
                FirDeclarationUtilKt.addDeclaration((FirRegularClass)owner, (FirDeclaration)klass);
            } else if (object instanceof FirFile) {
                FirDeclarationUtilKt.addDeclaration((FirFile)owner, (FirDeclaration)klass);
            }
            GeneratedClassIndexKt.getGeneratedClassIndex(this.getSession()).registerClass(klass, owner);
            FirPredicateBasedProviderKt.getPredicateBasedProvider(this.getSession()).registerGeneratedDeclaration(klass, owner);
            MainSessionComponentsKt.getFirProvider(this.getSession()).recordGeneratedClass(owner, klass);
            object = newClasses;
            boolean bl = false;
            object.add(klass);
        }
    }
}

